/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector.editors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSimplePropretyEditor<T>
implements PropertyEditor {
    private T _value;
    private final PropertyChangeSupport _support;
    private final Class<T> _clazz;

    protected AbstractSimplePropretyEditor(Class<T> clazz) {
        this.$init$();
        this._clazz = clazz;
    }

    @Override
    public final void setValue(Object o) {
        T newValue;
        if (this._clazz.isInstance(o)) {
            newValue = this._clazz.cast(o);
        } else if (o instanceof String) {
            newValue = this.getValueForString(o.toString());
        } else if (o == null) {
            newValue = null;
        } else {
            throw new IllegalArgumentException("illegal value " + o);
        }
        this._setValueAndFireEvent(newValue);
    }

    public T getValue() {
        return this._value;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public final String getAsText() {
        if (this._value == null) {
            return null;
        }
        return this.getStringForValue(this._value);
    }

    @Override
    public final String getJavaInitializationString() {
        T value = this.getValue();
        if (value == null) {
            return "null";
        }
        return this.getJavaInitializationStringImpl(value);
    }

    @Override
    public final void setAsText(String text) throws IllegalArgumentException {
        if (!ModelUtil.hasLength((String)text)) {
            this._setValueAndFireEvent(null);
        } else {
            this._setValueAndFireEvent(this.getValueForString(text));
        }
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public Component getCustomEditor() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    @Override
    public final void addPropertyChangeListener(PropertyChangeListener l) {
        this._support.addPropertyChangeListener(l);
    }

    @Override
    public final void removePropertyChangeListener(PropertyChangeListener l) {
        this._support.removePropertyChangeListener(l);
    }

    protected abstract T getValueForString(String var1) throws IllegalArgumentException;

    protected abstract String getStringForValue(T var1) throws IllegalArgumentException;

    protected String getJavaInitializationStringImpl(T value) {
        return "???";
    }

    private void _setValueAndFireEvent(T newValue) {
        T oldValue = this._value;
        this._value = newValue;
        this._support.firePropertyChange("value", oldValue, this._value);
    }

    private void $init$() {
        this._support = new PropertyChangeSupport(this);
    }
}

