/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.palette;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.util.XmlKeyDisplayNameComparator;

public class BasePaletteGui
extends XmlGui {
    public BasePaletteGui(XmlView view) {
        super(view);
    }

    public Map getPalettePages(Grammar g) {
        this.getView().acquireReadLock();
        try {
            XmlMetadataResolver resolver = this.getView().getXmlMetadataResolver();
            if (!resolver.isPaletteDisplayedForGrammar(g)) {
                Map map = Collections.EMPTY_MAP;
                return map;
            }
            TreeMap map = new TreeMap();
            String ns = g.getTargetNamespace();
            XmlKey nsKey = ImmutableXmlKey.createNamespaceKey((String)ns);
            Collection<XmlKey> elements = this.getView().getXmlMetadataResolver().getCreateableChildrenXmlKeys(null, nsKey);
            ArrayList allList = new ArrayList(elements.size());
            for (XmlKey elementKey : elements) {
                this._addKey(elementKey, resolver, map, allList);
            }
            if (map.size() > 1 && resolver.isAllPalettePageDisplayedForGrammar(g)) {
                String name = resolver.getShortDisplayName(nsKey);
                String titleFormatKey = name.equals(ns) ? "PALETTE.NO_DISPLAY_NAME_TITLE_FORMAT" : "PALETTE.HAS_DISPLAY_NAME_TITLE_FORMAT";
                String titleFormat = this.getTranslatedString(titleFormatKey);
                String pageTitle = FastMessageFormat.formatMessage(titleFormat, name);
                map.put(pageTitle, allList);
            }
            Collection values = map.values();
            Iterator i = values.iterator();
            XmlKeyDisplayNameComparator c = new XmlKeyDisplayNameComparator(resolver);
            while (i.hasNext()) {
                List l = (List)i.next();
                Collections.sort(l, c);
            }
            TreeMap treeMap = map;
            return treeMap;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.getView().releaseReadLock();
        }
    }

    public boolean isGuiActivatable() {
        return false;
    }

    private void _addKey(XmlKey elementKey, XmlMetadataResolver resolver, Map map, List allList) {
        String palettePage;
        if (resolver.isXmlKeyCreatableInPalette(elementKey) && (palettePage = resolver.getGroup(elementKey)) != null) {
            ArrayList<XmlKey> list = (ArrayList<XmlKey>)map.get(palettePage);
            if (list == null) {
                list = new ArrayList<XmlKey>();
                map.put(palettePage, list);
            }
            list.add(elementKey);
            if (allList != null) {
                allList.add(elementKey);
            }
        }
    }
}

