/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.indexing;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.standalone.AttributeMetadata;
import oracle.bali.xml.metadata.standalone.ElementMetadata;
import oracle.bali.xml.metadata.standalone.GrammarMetadata;
import oracle.bali.xml.metadata.standalone.MetadataGroup;
import oracle.bali.xml.metadata.standalone.OracleStandaloneMetadataFactory;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFile;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFileException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexingMetadataParser {
    private List<QualifiedName> _metadataKeys;
    private Map<String, Map<XmlKey, Map<QualifiedName, List<String>>>> _urlMap;

    public IndexingMetadataParser(List<QualifiedName> metadataKeys) {
        this._metadataKeys = metadataKeys;
        this._urlMap = new HashMap<String, Map<XmlKey, Map<QualifiedName, List<String>>>>();
    }

    public Map<XmlKey, Map<QualifiedName, List<String>>> getMetadataMap(URL fileUrl) throws StandaloneMetadataFileException {
        if (this._urlMap.containsKey(fileUrl.toString())) {
            return this._urlMap.get(fileUrl.toString());
        }
        HashMap<XmlKey, Map<QualifiedName, List<String>>> resultMap = new HashMap<XmlKey, Map<QualifiedName, List<String>>>();
        StandaloneMetadataFile file = OracleStandaloneMetadataFactory.createStandaloneMetadataFile((URL)fileUrl);
        GrammarMetadata gm = file.getGrammarMetadata();
        ArrayList<String> groups = new ArrayList<String>();
        this._parseElementMetadata(gm.getElementMetadataMap(), this._metadataKeys, groups, resultMap);
        this._urlMap.put(fileUrl.toString(), resultMap);
        return resultMap;
    }

    private void _parseElementMetadata(Map elementMetadataMap, List<QualifiedName> metadataKeys, Collection<String> groups, Map<XmlKey, Map<QualifiedName, List<String>>> resultMap) {
        if (elementMetadataMap == null || elementMetadataMap.isEmpty()) {
            return;
        }
        for (ElementMetadata em : elementMetadataMap.values()) {
            QualifiedName emQName = QualifiedName.getQualifiedName((String)em.getTargetNamespace(), (String)em.getElementName());
            XmlKey elementKey = ImmutableXmlKey.createElementKey((QualifiedName)emQName);
            Map emMap = em.getMetadataMap();
            this._findInMetadataMap(emMap, metadataKeys, elementKey, resultMap);
            this._parseAttributeMetadata(emQName, em.getAttributeMetadataMap(), metadataKeys, resultMap);
            this._parseElementMetadata(em.getElementMetadataMap(), metadataKeys, groups, resultMap);
            List metadataGroups = em.getMetadataGroups();
            for (MetadataGroup group : metadataGroups) {
                this._parseAttributeMetadata(emQName, group.getAttributeMetadataMap(), metadataKeys, resultMap);
                if (groups.contains(group.getName())) continue;
                groups.add(group.getName());
                this._parseElementMetadata(group.getElementMetadataMap(), metadataKeys, groups, resultMap);
            }
        }
    }

    private void _parseAttributeMetadata(QualifiedName elementName, Map attributeMetadataMap, List<QualifiedName> metadataKeys, Map<XmlKey, Map<QualifiedName, List<String>>> resultMap) {
        for (AttributeMetadata am : attributeMetadataMap.values()) {
            XmlKey attrKey = ImmutableXmlKey.createAttributeKey((QualifiedName)elementName, (String)am.getAttributeName());
            Map amMap = am.getMetadataMap();
            this._findInMetadataMap(amMap, metadataKeys, attrKey, resultMap);
        }
    }

    private void _findInMetadataMap(Map metadataMap, List<QualifiedName> metadataKeys, XmlKey xmlKey, Map<XmlKey, Map<QualifiedName, List<String>>> resultMap) {
        for (QualifiedName metadataKey : metadataKeys) {
            Map<Object, Object> metadataKeyMap;
            if (!metadataMap.containsKey(metadataKey)) continue;
            String metadataValue = (String)metadataMap.get(metadataKey);
            if (resultMap.containsKey(xmlKey)) {
                metadataKeyMap = resultMap.get(xmlKey);
                if (metadataKeyMap.containsKey(metadataKey)) {
                    List valueList = (List)metadataKeyMap.get(metadataKey);
                    valueList.add(metadataValue);
                    continue;
                }
                ArrayList<String> valueList = new ArrayList<String>();
                valueList.add(metadataValue);
                metadataKeyMap.put(metadataKey, valueList);
                continue;
            }
            metadataKeyMap = new HashMap();
            ArrayList<String> valueList = new ArrayList<String>();
            valueList.add(metadataValue);
            metadataKeyMap.put(metadataKey, valueList);
            resultMap.put(xmlKey, metadataKeyMap);
        }
    }
}

