/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.indexing;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.indexing.IndexingFactory;
import oracle.bali.xml.indexing.IndexingMetadataMapper;
import oracle.bali.xml.indexing.IndexingMetadataParser;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFileException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexingProvider {
    private static final QualifiedName REFERENCE_FACTORY = QualifiedName.getQualifiedName((String)"http://xmlns.oracle.com/bali/xml/metadata/model", (String)"reference");
    private static final QualifiedName INDEXING_FACTORY = QualifiedName.getQualifiedName((String)"http://xmlns.oracle.com/bali/xml/metadata/model", (String)"indexingFactory");
    private static final ArrayList<QualifiedName> _qnList = new ArrayList();
    private static final IndexingMetadataParser _parser;
    private static final Logger _LOGGER;
    private IndexingMetadataMapper _mapper;
    private List<Map<XmlKey, Map<QualifiedName, List<String>>>> _metadataList;
    private HashMap<XmlKey, List<IndexingFactory>> _factoryMap;

    public IndexingProvider(IndexingMetadataMapper mapper, List<URL> urls) {
        this.$init$();
        this._mapper = mapper;
        if (!urls.isEmpty()) {
            this._metadataList = new ArrayList<Map<XmlKey, Map<QualifiedName, List<String>>>>();
            for (URL url : urls) {
                try {
                    Map<XmlKey, Map<QualifiedName, List<String>>> metadata = _parser.getMetadataMap(url);
                    this._metadataList.add(metadata);
                }
                catch (StandaloneMetadataFileException e) {
                    _LOGGER.log(Level.WARNING, "Error while loading standalone metadata file; url={0}", url);
                }
            }
        }
    }

    public final List<IndexingFactory> getIndexingFactories(QualifiedName elementQN, QualifiedName attrQN, String value) {
        if (this._mapper != null) {
            XmlKey newKey = this._mapper.getXmlKeyFor(this._getXmlKey(elementQN, attrQN), true);
            elementQN = newKey.getElementQName();
            attrQN = newKey.getAttributeQName();
        }
        return this.getIndexingFactoriesImpl(elementQN, attrQN, value);
    }

    public List<IndexingFactory.IndexEntry> getCommentIndexEntries(String value) {
        return Collections.emptyList();
    }

    protected List<IndexingFactory> getIndexingFactoriesImpl(QualifiedName elementQN, QualifiedName attrQN, String value) {
        XmlKey key = this._getXmlKey(elementQN, attrQN);
        if (this._factoryMap.containsKey(key)) {
            return this._factoryMap.get(key);
        }
        ArrayList<IndexingFactory> factories = null;
        if (this._metadataList != null) {
            for (Map<XmlKey, Map<QualifiedName, List<String>>> metadata : this._metadataList) {
                if (!metadata.containsKey(key)) continue;
                Map<QualifiedName, List<String>> factoryMap = metadata.get(key);
                for (QualifiedName qName : _qnList) {
                    if (!factoryMap.containsKey(qName)) continue;
                    if (factories == null) {
                        factories = new ArrayList<IndexingFactory>();
                    }
                    factories.addAll(this._getIndexingFactories(factoryMap.get(qName)));
                }
            }
        }
        this._factoryMap.put(key, factories);
        return factories;
    }

    private XmlKey _getXmlKey(QualifiedName elementQN, QualifiedName attrQN) {
        XmlKey key = null;
        key = attrQN == null ? ImmutableXmlKey.createElementKey((QualifiedName)elementQN) : ImmutableXmlKey.createAttributeKey((QualifiedName)elementQN, (QualifiedName)attrQN);
        return key;
    }

    private Collection<IndexingFactory> _getIndexingFactories(List<String> classes) {
        ArrayList<IndexingFactory> factories = new ArrayList<IndexingFactory>();
        for (String clazz : classes) {
            try {
                Class<?> factoryClass = Class.forName(clazz);
                if (!IndexingFactory.class.isAssignableFrom(factoryClass)) continue;
                factories.add(IndexingProvider._instantiate(factoryClass.asSubclass(IndexingFactory.class)));
            }
            catch (ClassNotFoundException e) {
                _LOGGER.log(Level.WARNING, "Unable to load class: {0}", clazz);
            }
        }
        return factories;
    }

    private static <T> T _instantiate(Class<T> clazz) {
        try {
            T t = clazz.newInstance();
            return t;
        }
        catch (Exception e) {
            _LOGGER.log(Level.WARNING, "Could not instantiate class " + clazz, e);
            return (T)((Object)null);
        }
    }

    static {
        _qnList.add(REFERENCE_FACTORY);
        _qnList.add(INDEXING_FACTORY);
        _parser = new IndexingMetadataParser(_qnList);
        _LOGGER = Logger.getLogger(IndexingProvider.class.getName());
    }

    private void $init$() {
        this._factoryMap = new HashMap();
    }
}

