/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model;

import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.Action;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.NodeChangeDetails;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.ServiceProvider;
import oracle.bali.xml.model.TransactionOptions;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.datatransfer.operation.Operation;
import oracle.bali.xml.model.datatransfer.operation.PerformOperationAction;
import oracle.bali.xml.model.task.StandardTransactionTask;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.share.PropertyChange;
import oracle.bali.xml.share.TransactionToken;
import oracle.bali.xml.util.DomPositionMapper;
import oracle.bali.xml.util.XmlModelUtils;
import oracle.javatools.datatransfer.TransferDataInfo;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.TreeWalker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModel
implements ServiceProvider {
    public static final String DOM_DOCUMENT_CHANGED_PROPERTY = "documentChanged";
    public static final String DROP_LOCATION_PROPERTY = "dropLocation";
    public static final String CURSOR_LOCATION_PROPERTY = "cursorLocation";
    public static final String RANGE_SELECTION_PROPERTY = "rangeSelection";
    public static final String SELECTION_CLEARED_PROPERTY = "selectionCleared";
    public static final String READONLY_PROPERTY = "readOnly";
    private static final Logger _LOGGER = Logger.getLogger("oracle.bali.xml.model");
    private final XmlModelEvent _emptyEvent = new XmlModelEvent(this);

    AbstractModel() {
        this._emptyEvent.prepareForDelivery();
    }

    public abstract XmlModel getBaseModel();

    public abstract DomModel getDomModel();

    public abstract XmlContext getContext();

    @Override
    public abstract Object getService(Object var1);

    public final void startTransaction(String description) {
        this.startTransaction(new TransactionOptions(description));
    }

    public abstract void startTransaction(TransactionOptions var1);

    public abstract boolean commitTransaction() throws XmlCommitException;

    public abstract void rollbackTransaction();

    public abstract void addModelListener(XmlModelListener var1);

    public abstract void removeModelListener(XmlModelListener var1);

    public abstract boolean isDeliveringEvents();

    public abstract Selection getSelection();

    public abstract String getTranslatedString(String var1);

    public void performOperationAction(ActionEvent event, PerformOperationAction performOperationAction, AbstractModel model, DomPosition position, Operation operation, TransferDataInfo transferDataInfo) {
        TransactionToken token = model.getContext().createTransactionToken();
        token.setOwnerIfUnset(performOperationAction);
        boolean success = false;
        try {
            try {
                success = operation.apply(model, position, transferDataInfo, token);
            }
            catch (IOException e) {
                e.printStackTrace();
                success = false;
            }
            catch (XmlCommitException e) {
                e.printStackTrace();
                success = false;
            }
        }
        finally {
            TransactionToken.dispatch(token, performOperationAction, success);
        }
    }

    public boolean transformModelAndDomPosition() {
        return false;
    }

    public AbstractModel transformModel() {
        return this;
    }

    public DomPosition transformDomPosition(DomPosition domPosition) {
        return domPosition;
    }

    public final String getTranslatedString(String key, Object[] params) {
        return FastMessageFormat.formatMessage(this.getTranslatedString(key), params);
    }

    public final String getTranslatedString(String key, String param1) {
        return FastMessageFormat.formatMessage(this.getTranslatedString(key), param1);
    }

    public abstract Action getAction(String var1);

    public abstract Document getDocument();

    public abstract TreeWalker createTreeWalker();

    public abstract TreeTraversal getTreeTraversal();

    public abstract XmlMetadataResolver getXmlMetadataResolver();

    public abstract XmlKey getNodeXmlKey(Node var1);

    public final DomPosition remapPosition(DomPosition oldPosition) {
        Node remappedTarget;
        if (oldPosition != null && (remappedTarget = this.remapNode(oldPosition.getTargetNode())) != null) {
            return oldPosition.getRetargetedPosition(remappedTarget, false);
        }
        return null;
    }

    public final Node remapNode(Node oldNode) {
        List nodePath;
        if (oldNode != null && !(nodePath = DomUtils.getNodePath((TreeTraversal)this.getTreeTraversal(), (Node)oldNode, null)).isEmpty()) {
            return this.remapNode(nodePath);
        }
        return null;
    }

    public final boolean isInModelDocumentHierarchy(Node node) {
        if (node == null || DomUtils.getOwnerDocument((Node)node) != this.getDocument()) {
            return false;
        }
        if (DomUtils.isAttribute((Node)node)) {
            node = ((Attr)node).getOwnerElement();
        }
        return DomUtils.isInDocumentHierarchy((TreeTraversal)this.getTreeTraversal(), (Node)node);
    }

    public final boolean isInModelDocumentHierarchy(DomPosition pos) {
        if (pos == null) {
            return false;
        }
        return this.isInModelDocumentHierarchy(pos.getTargetNode());
    }

    public abstract DomPosition convertInsertionPosition(DomPosition var1);

    public abstract Node remapNode(List var1);

    public abstract Collection deleteNodes(String var1, Collection var2, boolean var3) throws XmlCommitException;

    public abstract Collection deleteNodes(String var1, DomRange var2, boolean var3) throws XmlCommitException;

    public abstract Collection insertNodes(DomPosition var1, String var2, Collection var3, boolean var4) throws XmlCommitException;

    public abstract boolean isReadOnly();

    protected abstract boolean isImmutable(Node var1);

    protected abstract boolean isDeletable(Node var1);

    protected abstract boolean canAddChild(DomPosition var1);

    protected abstract boolean canAddAttribute(Element var1, XmlKey var2);

    protected abstract boolean isValueModifiable(Node var1);

    public abstract Transferable createTransferable();

    public boolean requiresValidModel() {
        return false;
    }

    public final Logger getLogger() {
        return _LOGGER;
    }

    public final Node insertXmlKey(XmlKey xmlKey, DomPosition position) throws XmlCommitException {
        if (xmlKey != null && position != null) {
            Node[] ret = new Node[1];
            new 1(this, xmlKey, position, ret).runThrowingXCE(this);
            return ret[0];
        }
        return null;
    }

    public final Node insertXmlKey(XmlKey xmlKey, DomPosition position, Node node) throws XmlCommitException {
        if (xmlKey != null && position != null) {
            Node[] ret = new Node[1];
            new 2(this, xmlKey, node, position, ret).runThrowingXCE(this);
            return ret[0];
        }
        return null;
    }

    public final Node insertNode(Node node, DomPosition position) throws XmlCommitException {
        return this.insertNode(node, position, true);
    }

    public final Node insertNode(Node node, DomPosition position, boolean updateSelection) throws XmlCommitException {
        String txnName;
        this.acquireReadLock();
        try {
            txnName = FastMessageFormat.formatMessage(this.getTranslatedString("INSERT_NODE_DESCRIPTION_FORMAT"), this.getXmlMetadataResolver().getMediumDisplayName(node));
        }
        finally {
            this.releaseReadLock();
        }
        Collection ret = this.insertNodes(position, txnName, Collections.singleton(node), updateSelection);
        if (ret == null || ret.isEmpty()) {
            return null;
        }
        return (Node)ret.iterator().next();
    }

    public final void insertIntoTextNode(CharacterData node, int offset, String data) {
        this.__verifyWriteLock();
        if (!this.isInModelDocumentHierarchy(node)) {
            throw new IllegalArgumentException("node null or not in hierarchy: " + node);
        }
        if (data == null) {
            throw new IllegalArgumentException("null data");
        }
        String oldValue = node.getNodeValue();
        int oldLength = oldValue.length();
        if (offset < 0 || offset > oldLength) {
            throw new IllegalArgumentException("offset out of bounds");
        }
        MapperForInsertOrDeleteFromText mapper = new MapperForInsertOrDeleteFromText(node, offset, data.length());
        node.setNodeValue(this._insertIntoString(oldValue, offset, data));
        mapper.applyMappings();
    }

    public final void deleteFromTextNode(CharacterData node, int offset, int length) {
        this.__verifyWriteLock();
        if (!this.isInModelDocumentHierarchy(node)) {
            throw new IllegalArgumentException("node null or not in hierarchy");
        }
        String oldValue = node.getNodeValue();
        int oldLength = oldValue.length();
        if (offset < 0 || length <= 0 || offset + length > oldLength || length >= oldLength) {
            throw new IllegalArgumentException("offset/length out of bounds");
        }
        MapperForInsertOrDeleteFromText mapper = new MapperForInsertOrDeleteFromText(node, offset, -length);
        node.setNodeValue(this._deleteFromString(oldValue, offset, length));
        mapper.applyMappings();
    }

    public final void mergeTextNodes(Text a, Text b) {
        if (a == null || b == null) {
            throw new IllegalArgumentException("one node was null");
        }
        this.__verifyWriteLock();
        TreeTraversal traversal = this.getTreeTraversal();
        if (traversal.getNextSibling((Node)a) != b) {
            if (traversal.getPreviousSibling((Node)a) == b) {
                Text temp = a;
                a = b;
                b = temp;
            } else {
                throw new IllegalArgumentException("nodes must be siblings!");
            }
        }
        this.mergeTextNodesImpl(a, b);
    }

    public final Text splitTextNode(Text orig, int offset) {
        if (orig == null) {
            throw new IllegalArgumentException("null parameter");
        }
        this.__verifyWriteLock();
        int oldLength = orig.getLength();
        if (offset <= 0 || offset >= oldLength) {
            return null;
        }
        return this.splitTextNodeImpl(orig, offset);
    }

    public final DomPosition splitAtPositionIfNeeded(DomPosition location, boolean backward) {
        Node target;
        this.__verifyWriteLock();
        if (location.hasTextOffset() && DomUtils.isText((Node)(target = location.getTargetNode()))) {
            int offset = location.getTextOffset();
            Text casted = (Text)target;
            if (offset == 0) {
                return DomPositionFactory.before((Node)casted);
            }
            if (offset == casted.getLength()) {
                return DomPositionFactory.after((Node)casted);
            }
            Text created = this.splitTextNode(casted, offset);
            if (created != null) {
                if (backward) {
                    return DomPositionFactory.after((Node)target);
                }
                return DomPositionFactory.before((Node)created);
            }
        }
        return location;
    }

    protected Collection getNodesForDeletion(DomRange range, boolean updateSelection) {
        this.__verifyWriteLock();
        TreeTraversal traversal = this.getTreeTraversal();
        DomPosition end = this.splitAtPositionIfNeeded(range.getEnd(), false);
        DomPosition start = this.splitAtPositionIfNeeded(range.getStart(), true);
        if (updateSelection) {
            DomPosition nextSelection = null;
            if (start != range.getStart()) {
                nextSelection = start;
            } else if (end != range.getEnd()) {
                nextSelection = end;
            } else if (start.isBefore()) {
                if (end.isBefore()) {
                    nextSelection = end;
                } else {
                    Node startTarget = start.getTargetNode();
                    Node beforeStart = traversal.getPreviousSibling(startTarget);
                    if (beforeStart != null) {
                        nextSelection = DomPositionFactory.after((Node)beforeStart);
                    } else {
                        Node afterEnd = traversal.getNextSibling(end.getTargetNode());
                        if (afterEnd != null) {
                            nextSelection = DomPositionFactory.before((Node)afterEnd);
                        } else {
                            Node startParent = traversal.getParentNode(startTarget);
                            if (startParent != null) {
                                nextSelection = DomPositionFactory.inside((Node)startParent);
                            }
                        }
                    }
                }
            } else {
                nextSelection = start;
            }
            Selection sel = this.getSelection();
            if (nextSelection == null) {
                sel.clear();
                sel.setCursorLocation(null);
            } else {
                nextSelection = this.getTextPositionIfPossible(nextSelection);
                sel.setCursorLocation(nextSelection);
                sel.setRangeSelection(DomRange.create((DomPosition)nextSelection, (DomPosition)nextSelection, (TreeTraversal)traversal));
            }
        }
        if (start != range.getStart() || end != range.getEnd()) {
            range = DomRange.create((DomPosition)start, (DomPosition)end, (TreeTraversal)traversal);
        }
        return range.getNodesEntirelyInRange(traversal);
    }

    protected void selectInsertedNodes(Collection<? extends Node> nodes) {
        this.__verifyWriteLock();
        if (nodes != null) {
            if (nodes.isEmpty()) {
                this.getSelection().clear();
            } else {
                this.getSelection().set(nodes);
                Node first = nodes.iterator().next();
                this.getSelection().setCursorLocation(DomPositionFactory.createInsideOrAfterPosition((Node)first));
            }
        }
    }

    protected abstract Text splitTextNodeImpl(Text var1, int var2);

    protected abstract void mergeTextNodesImpl(Text var1, Text var2);

    public abstract void acquireReadLock();

    public abstract void releaseReadLock();

    abstract void __acquireWriteLock();

    abstract void __releaseWriteLock();

    abstract void __verifyLock();

    abstract void __verifyWriteLock();

    protected final DomPosition getTextPositionIfPossible(DomPosition orig) {
        this.__verifyLock();
        return DomPositionFactory.asTextOffsetPositionIfPossible((DomPosition)orig);
    }

    protected final void deliverInvalidateEvent(XmlModelEvent event, Iterator listeners) {
        event.prepareForDelivery();
        this._deliverEventUnderReadLock(event, listeners, true);
    }

    protected final void deliverNoChangeEvent(Iterator listeners) {
        this._deliverEventUnderReadLock(this._emptyEvent, listeners, false);
    }

    /*
     * Exception decompiling
     */
    private void _deliverEventUnderReadLock(XmlModelEvent event, Iterator listeners, boolean isInvalidate) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected final XmlModelEvent createEvent(boolean isAdding) {
        this.acquireReadLock();
        try {
            int domChangeFlags;
            Document rootNode;
            Set<Node> selectionSet = this.getSelection().getSelectedNodeSet();
            Set<Node> selectionsAdded = null;
            Set<Node> selectionsRemoved = null;
            if (isAdding) {
                rootNode = this.getDocument();
                domChangeFlags = 1;
                selectionsAdded = selectionSet;
            } else {
                rootNode = null;
                domChangeFlags = 2;
                selectionsRemoved = selectionSet;
            }
            HashMap<String, PropertyChange> propertyChanges = new HashMap<String, PropertyChange>(11);
            this.addCurrentPropertiesToEvent(propertyChanges, isAdding);
            XmlModelEvent xmlModelEvent = new XmlModelEvent(this, rootNode, domChangeFlags, propertyChanges, selectionsAdded, selectionsRemoved, null, NodeChangeDetails.NO_DETAILS_AVAILABLE);
            return xmlModelEvent;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.releaseReadLock();
        }
    }

    protected void addCurrentPropertiesToEvent(Map<String, PropertyChange> propertyChanges, boolean isAdding) {
        PropertyChange cursorLocationChange;
        PropertyChange dropLocationChange;
        PropertyChange documentChange;
        Selection selection = this.getSelection();
        Document documentNode = this.getDocument();
        DomPosition dropLocation = selection.getDropLocation();
        DomPosition cursorLocation = selection.getCursorLocation();
        if (isAdding) {
            documentChange = PropertyChange.getPropertyChange(DOM_DOCUMENT_CHANGED_PROPERTY, null, documentNode);
            dropLocationChange = PropertyChange.getPropertyChange(DROP_LOCATION_PROPERTY, null, dropLocation);
            cursorLocationChange = PropertyChange.getPropertyChange(CURSOR_LOCATION_PROPERTY, null, cursorLocation);
        } else {
            documentChange = PropertyChange.getPropertyChange(DOM_DOCUMENT_CHANGED_PROPERTY, documentNode, null);
            dropLocationChange = PropertyChange.getPropertyChange(DROP_LOCATION_PROPERTY, dropLocation, null);
            cursorLocationChange = PropertyChange.getPropertyChange(CURSOR_LOCATION_PROPERTY, cursorLocation, null);
        }
        if (documentChange != null) {
            propertyChanges.put(DOM_DOCUMENT_CHANGED_PROPERTY, documentChange);
        }
        if (dropLocationChange != null) {
            propertyChanges.put(DROP_LOCATION_PROPERTY, dropLocationChange);
        }
        if (cursorLocationChange != null) {
            propertyChanges.put(CURSOR_LOCATION_PROPERTY, cursorLocationChange);
        }
    }

    private String _deleteFromString(String orig, int offset, int length) {
        StringBuffer buf = new StringBuffer(orig.length() - length);
        buf.append(orig.substring(0, offset));
        buf.append(orig.substring(offset + length));
        return buf.toString();
    }

    private String _insertIntoString(String orig, int offset, String data) {
        StringBuffer buf = new StringBuffer(orig.length() + data.length());
        buf.append(orig.substring(0, offset));
        buf.append(data);
        buf.append(orig.substring(offset));
        return buf.toString();
    }

    final class 1
    extends StandardTransactionTask {
        private final /* synthetic */ XmlKey v$xmlKey;
        private final /* synthetic */ DomPosition v$position;
        private final /* synthetic */ Node[] v$ret;
        final /* synthetic */ AbstractModel this$0;

        protected String computeTransactionName(AbstractModel model) {
            return model.getTranslatedString("INSERT_NODE_DESCRIPTION_FORMAT", this.this$0.getXmlMetadataResolver().getShortDisplayName(this.v$xmlKey));
        }

        protected void performTask(AbstractModel model) throws XmlCommitException {
            Collection inserted;
            Node node = XmlModelUtils.createNodeFromKey(model, this.v$xmlKey, this.v$position);
            if (node != null && (inserted = model.insertNodes(this.v$position, "internal txn", DomUtils.nodeToList((Node)node), true)) != null && !inserted.isEmpty()) {
                this.v$ret[0] = inserted.contains(node) ? node : (Node)inserted.iterator().next();
                return;
            }
            this.cancelTask();
        }

        public 1(AbstractModel abstractModel, XmlKey xmlKey, DomPosition domPosition, Node[] nodeArray) {
            this.v$ret = nodeArray;
            this.v$position = domPosition;
            this.v$xmlKey = xmlKey;
            this.this$0 = abstractModel;
        }
    }

    final class 2
    extends StandardTransactionTask {
        private final /* synthetic */ XmlKey v$xmlKey;
        private final /* synthetic */ Node v$node;
        private final /* synthetic */ DomPosition v$position;
        private final /* synthetic */ Node[] v$ret;
        final /* synthetic */ AbstractModel this$0;

        protected String computeTransactionName(AbstractModel model) {
            return model.getTranslatedString("INSERT_NODE_DESCRIPTION_FORMAT", this.this$0.getXmlMetadataResolver().getShortDisplayName(this.v$xmlKey));
        }

        protected void performTask(AbstractModel model) throws XmlCommitException {
            Collection inserted;
            if (this.v$node != null && (inserted = model.insertNodes(this.v$position, "internal txn", DomUtils.nodeToList((Node)this.v$node), true)) != null && !inserted.isEmpty()) {
                this.v$ret[0] = inserted.contains(this.v$node) ? this.v$node : (Node)inserted.iterator().next();
                return;
            }
            this.cancelTask();
        }

        public 2(AbstractModel abstractModel, XmlKey xmlKey, Node node, DomPosition domPosition, Node[] nodeArray) {
            this.v$ret = nodeArray;
            this.v$position = domPosition;
            this.v$node = node;
            this.v$xmlKey = xmlKey;
            this.this$0 = abstractModel;
        }
    }

    protected class MapperForMergeTextNodes
    extends DomPositionMapper {
        private final Text _target;
        private final Text _source;
        private final int _targetOldLength;

        public MapperForMergeTextNodes(Text target, Text source) {
            super(AbstractModel.this);
            this._target = target;
            this._source = source;
            this._targetOldLength = this._target.getLength();
        }

        protected DomPosition mapPosition(DomPosition origPos) {
            Node origNode = origPos.getTargetNode();
            if (origNode == this._source) {
                if (origPos.isBefore()) {
                    return DomPositionFactory.createTextPosition((CharacterData)this._target, (int)this._targetOldLength);
                }
                if (origPos.isAfter()) {
                    return DomPositionFactory.after((Node)this._target);
                }
                if (origPos.hasTextOffset()) {
                    return DomPositionFactory.createTextPosition((CharacterData)this._target, (int)(this._targetOldLength + origPos.getTextOffset()));
                }
            } else if (origNode == this._target && origPos.isAfter()) {
                return DomPositionFactory.createTextPosition((CharacterData)this._target, (int)this._targetOldLength);
            }
            return origPos;
        }
    }

    protected class MapperForSplitTextNode
    extends DomPositionMapper {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final Text _original;
        private Text _created;
        private final int _splitOffset;

        public MapperForSplitTextNode(Text original, int splitOffset) {
            super(AbstractModel.this);
            this._original = original;
            this._splitOffset = splitOffset;
        }

        public void setCreated(Text created) {
            this._created = created;
        }

        static {
            $assertionsDisabled = MapperForSplitTextNode.class.desiredAssertionStatus() ^ true;
        }

        protected DomPosition mapPosition(DomPosition originalPos) {
            if (!$assertionsDisabled && this._created == null) {
                throw new AssertionError();
            }
            if (originalPos != null && originalPos.getTargetNode() == this._original) {
                int posOffset;
                if (originalPos.isAfter()) {
                    return DomPositionFactory.after((Node)this._created);
                }
                if (originalPos.hasTextOffset() && (posOffset = originalPos.getTextOffset()) > this._splitOffset) {
                    return DomPositionFactory.createTextPosition((CharacterData)this._created, (int)(posOffset - this._splitOffset));
                }
            }
            return originalPos;
        }
    }

    private class MapperForInsertOrDeleteFromText
    extends DomPositionMapper {
        private final CharacterData _node;
        private final int _offset;
        private final int _delta;

        public MapperForInsertOrDeleteFromText(CharacterData node, int offset, int delta) {
            super(AbstractModel.this);
            this._node = node;
            this._offset = offset;
            this._delta = delta;
        }

        protected DomPosition mapPosition(DomPosition origPos) {
            if (this._delta != 0 && origPos.hasTextOffset() && origPos.getTargetNode() == this._node) {
                int newOffset = -1;
                int oldOffset = origPos.getTextOffset();
                if (this._delta < 0) {
                    if (this._offset < oldOffset) {
                        newOffset = Math.max(this._offset, oldOffset + this._delta);
                    }
                } else if (this._offset <= oldOffset) {
                    newOffset = oldOffset + this._delta;
                }
                if (newOffset != -1) {
                    return DomPositionFactory.createTextPosition((CharacterData)this._node, (int)newOffset);
                }
            }
            return origPos;
        }
    }
}

