/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.DomMutationListener;
import oracle.bali.xml.dom.changes.AbstractAttrChange;
import oracle.bali.xml.dom.changes.AttrAddedChange;
import oracle.bali.xml.dom.changes.AttrRemovedChange;
import oracle.bali.xml.dom.changes.AttrValueChange;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.DomChangeHandler;
import oracle.bali.xml.dom.changes.NodeInsertedChange;
import oracle.bali.xml.dom.changes.NodeRemovedChange;
import oracle.bali.xml.dom.changes.NodeValueChange;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.MutationEvent;

final class ModelSelection
extends Selection {
    private DomPosition _pendingCursorLocation;

    ModelSelection(XmlModel model) {
        super(model);
    }

    public DomPosition getCursorLocation() {
        this._fixPendingCursorIfNeeded();
        return super.getCursorLocation();
    }

    public DomPosition setCursorLocation(DomPosition newCursorLocation) {
        DomPosition modelPosition = super.setCursorLocation(newCursorLocation);
        this._pendingCursorLocation = null;
        return modelPosition;
    }

    protected void restoreSnapshotState(Map snapshotState) {
        super.restoreSnapshotState(snapshotState);
        this._pendingCursorLocation = null;
    }

    protected boolean commitTransaction() {
        this._fixPendingCursorIfNeeded();
        return super.commitTransaction();
    }

    void __attachToDomModel() {
        XmlModel model = this.getModel().getBaseModel();
        DomModel domModel = model.getDomModel();
        domModel.addDomMutationListener(new SelectionDomMutationListener(null));
    }

    private void _fixPendingCursorIfNeeded() {
        if (this._pendingCursorLocation != null) {
            if (this.getModel().isInModelDocumentHierarchy(this._pendingCursorLocation)) {
                this.setCursorLocation(this._pendingCursorLocation);
            }
            this._pendingCursorLocation = null;
        }
    }

    private void _setPendingCursorLocation(DomPosition pendingLocation) {
        if (pendingLocation != this.getCursorLocation()) {
            this.setCursorLocationImpl(null);
            this._pendingCursorLocation = pendingLocation;
        }
    }

    static void mav$_setPendingCursorLocation(ModelSelection modelSelection, DomPosition domPosition) {
        modelSelection._setPendingCursorLocation(domPosition);
    }

    private class SelectionDomMutationListener
    implements DomMutationListener,
    DomChangeHandler {
        private transient MutationEvent _mEvent;

        public void domMutated(DomModel domModel, DomChange change, MutationEvent mEvent) {
            if (!ModelSelection.this.isInTransaction()) {
                return;
            }
            this._mEvent = mEvent;
            try {
                if (change == null) {
                    this._handleDocumentReplacement();
                } else {
                    change.process(this);
                }
            }
            finally {
                this._mEvent = null;
            }
        }

        public void handleAttrAddedChange(AttrAddedChange change) {
        }

        public void handleAttrRemovedChange(AttrRemovedChange change) {
            if (this._hasRangeSelectionTargetingAttribute(change)) {
                ModelSelection.this.clearRangeSelectionPreservingNodes();
            }
        }

        public void handleAttrValueChange(AttrValueChange change) {
            if (this._hasRangeSelectionTargetingAttribute(change)) {
                String value = change.getNewValue();
                DomRange oldRange = ModelSelection.this.getRangeSelection();
                DomPosition oldStart = oldRange.getStart();
                int oldStartOffset = oldStart.getTextOffset();
                if (oldStartOffset >= value.length()) {
                    ModelSelection.this.clearRangeSelectionPreservingNodes();
                } else {
                    DomPosition oldEnd = oldRange.getEnd();
                    if (oldEnd.getTextOffset() > value.length()) {
                        DomPosition newEnd = oldEnd.createPositionWithNewOffset(value.length());
                        DomRange newRange = oldRange.getRangeWithNewEnd(ModelSelection.this.getModel().getTreeTraversal(), newEnd);
                        ModelSelection.this.setRangeSelection(newRange);
                    }
                }
            }
        }

        public void handleNodeInsertedChange(NodeInsertedChange change) {
            Node node = change.getNodeRef().getCorrespondingNode(ModelSelection.this.getSelectionDocument());
            ModelSelection.this.addNodeSubtreeIfWithinSelectedRange(node);
        }

        public void handleNodeRemovedChange(NodeRemovedChange change) {
            Node targetNode = this._mEvent != null ? (Node)((Object)this._mEvent.getTarget()) : null;
            if (targetNode == null || targetNode.getNodeType() == 9) {
                this._handleDocumentReplacement();
            } else {
                ModelSelection.this.handleRemovalFromModel(targetNode);
                this._fixCursorAndDropPositions(targetNode);
            }
        }

        public void handleNodeValueChange(NodeValueChange change) {
            if (ModelSelection.this.hasRangeSelection()) {
                int oldEndOffset;
                int oldStartOffset;
                DomRange range = ModelSelection.this.getRangeSelection();
                DomPosition oldStart = range.getStart();
                DomPosition oldEnd = range.getEnd();
                Node changedNode = change.getNodeRef().getCorrespondingNode(ModelSelection.this.getSelectionDocument());
                String newValue = change.getNewValue();
                DomPosition newStart = oldStart;
                DomPosition newEnd = oldEnd;
                if (oldStart.hasTextOffset() && oldStart.getTargetNode() == changedNode && (oldStartOffset = oldStart.getTextOffset()) >= newValue.length()) {
                    if (oldEnd.hasTextOffset() && oldEnd.getTargetNode() == changedNode) {
                        ModelSelection.this.clearRangeSelectionPreservingNodes();
                        return;
                    }
                    newStart = oldStart.getAfterPosition();
                }
                if (oldEnd.hasTextOffset() && oldEnd.getTargetNode() == changedNode && (oldEndOffset = oldEnd.getTextOffset()) > newValue.length()) {
                    newEnd = oldEnd.createPositionWithNewOffset(newValue.length());
                }
                if (oldStart != newStart || oldEnd != newEnd) {
                    ModelSelection.this.setRangeSelection(ModelSelection.this.createDomRange(newStart, newEnd));
                }
            }
        }

        private void _handleDocumentReplacement() {
            Iterator<Node> selectedNodes = ModelSelection.this.getSelectedNodes();
            ArrayList<Node> remappedNodes = new ArrayList<Node>(ModelSelection.this.getSelectedNodesCount());
            List remappedPath = new LinkedList();
            AbstractModel model = ModelSelection.this.getModel();
            TreeTraversal traversal = model.getTreeTraversal();
            while (selectedNodes.hasNext()) {
                Node currSelectedNode = selectedNodes.next();
                remappedPath = DomUtils.getNodePath((TreeTraversal)traversal, (Node)currSelectedNode, remappedPath);
                Node remappedNode = null;
                if (!remappedPath.isEmpty()) {
                    remappedNode = model.remapNode(remappedPath);
                }
                if (remappedNode == null || DomUtils.isDocument((Node)remappedNode)) continue;
                remappedNodes.add(remappedNode);
            }
            ModelSelection.this.clear();
            ModelSelection.this.add(remappedNodes);
            ModelSelection.this.setCursorLocation(model.remapPosition(ModelSelection.this.getCursorLocation()));
            ModelSelection.this.setDropLocation(null);
        }

        private boolean _hasRangeSelectionTargetingAttribute(AbstractAttrChange change) {
            DomRange range = ModelSelection.this.getRangeSelection();
            if (range != null) {
                QualifiedName changeQName;
                QualifiedName posQName;
                Element changeOwner = change.getOwnerElement(ModelSelection.this.getSelectionDocument());
                DomPosition start = range.getStart();
                if (start.hasAttributeQName() && start.getTargetNode() == changeOwner && (posQName = start.getAttributeQName()) == (changeQName = QualifiedName.getQualifiedName((String)change.getAffectedAttrNamespace(), (String)change.getAffectedAttrLocalName()))) {
                    return true;
                }
            }
            return false;
        }

        private DomPosition _updatePositionForDeletion(DomPosition origPos, Node deletedNode) {
            if (origPos == null) {
                return null;
            }
            Node origTarget = origPos.getTargetNode();
            if (!DomUtils.isNodeOrDescendant((Node)origTarget, (Node)deletedNode)) {
                return origPos;
            }
            Node prevSibling = deletedNode.getPreviousSibling();
            if (prevSibling != null) {
                return DomPositionFactory.after((Node)prevSibling);
            }
            Node nextSibling = deletedNode.getNextSibling();
            if (nextSibling != null) {
                return DomPositionFactory.before((Node)nextSibling);
            }
            return DomPositionFactory.inside((Node)deletedNode.getParentNode());
        }

        private void _fixCursorAndDropPositions(Node targetNode) {
            DomPosition oldCursor = ModelSelection.this.getCursorLocation();
            DomPosition nowCursor = this._updatePositionForDeletion(oldCursor, targetNode);
            ModelSelection.mav$_setPendingCursorLocation(ModelSelection.this, nowCursor);
            DomPosition oldDrop = ModelSelection.this.getDropLocation();
            DomPosition nowDrop = this._updatePositionForDeletion(oldDrop, targetNode);
            ModelSelection.this.setDropLocation(nowDrop);
        }

        private SelectionDomMutationListener() {
        }

        SelectionDomMutationListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

