/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model;

import java.util.Map;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.metadata.DerivedXmlKey;
import oracle.bali.xml.metadata.DomNodeXmlKey;
import oracle.bali.xml.metadata.GlobalNodeTypeKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.validator.ErrorHandlerValidationContext;
import oracle.bali.xml.validator.PerValidationState;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelValidationContext
extends ErrorHandlerValidationContext {
    private final XmlModel _model;
    private final XmlMetadataResolver _resolver;
    private final Map<Node, XmlKey> _nodeToKeyCache;

    public ModelValidationContext(XmlModel model, Map<Node, XmlKey> nodeToKeyCache, ErrorHandler errorHandler) {
        super(model.getContext().getGrammarResolver(), errorHandler);
        this._model = model;
        this._resolver = model.getXmlMetadataResolver();
        this._nodeToKeyCache = nodeToKeyCache;
    }

    public void performAdditionalValidation(PerValidationState validationState, Document document) {
        this._resolver.performAdditionalValidation(this, validationState, document, (XmlKey)GlobalNodeTypeKey.DOCUMENT_KEY);
    }

    public void performAdditionalValidation(PerValidationState validationState, Element element, ElementDef elementDef, int processingRule, boolean deep) {
        XmlKey elementKey = this._nodeToKeyCache.get(element);
        if (elementKey == null) {
            XmlKey parentKey = null;
            Node parent = element.getParentNode();
            if (parent != null) {
                parentKey = this._nodeToKeyCache.get(parent);
            }
            elementKey = parentKey == null ? DomNodeXmlKey.createImmutableXmlKey((GrammarResolver)this.getGrammarResolver(), (Node)element) : DerivedXmlKey.createElementKey((GrammarResolver)this.getGrammarResolver(), (XmlKey)parentKey, (Element)element);
            this._nodeToKeyCache.put(element, elementKey);
        }
        this._resolver.performAdditionalValidation(this, validationState, element, elementDef, elementKey, processingRule, deep);
    }

    public void performAdditionalValidation(PerValidationState validationState, Attr attribute, AttributeDef attributeDef, int processingRule) {
        XmlKey attributeKey = this._nodeToKeyCache.get(attribute);
        if (attributeKey == null) {
            XmlKey parentKey = null;
            Element parent = attribute.getOwnerElement();
            if (parent != null) {
                parentKey = this._nodeToKeyCache.get(parent);
            }
            attributeKey = parentKey == null ? DomNodeXmlKey.createImmutableXmlKey((GrammarResolver)this.getGrammarResolver(), (Node)attribute) : DerivedXmlKey.createAttributeKey((GrammarResolver)this.getGrammarResolver(), (XmlKey)parentKey, (QualifiedName)DomUtils.getQualifiedName((Node)attribute));
            this._nodeToKeyCache.put(attribute, attributeKey);
        }
        this._resolver.performAdditionalValidation(this, validationState, attribute, attributeDef, attributeKey, processingRule);
    }
}

