/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import oracle.bali.share.util.IntegerUtils;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.SetChangeEvent;
import oracle.bali.xml.model.SetChangeListener;
import oracle.bali.xml.share.SafeListenerManager;
import oracle.bali.xml.share.SafePropertyChangeSupport;

class SelectionTransaction {
    static final /* synthetic */ boolean $assertionsDisabled;
    private final int _addStartIndex;
    private final int _removeStartIndex;
    private final Map _snapshotState;
    private final SelectionTransaction _parentTransaction;
    private SafeListenerManager _selectionChangeListeners;
    private SafePropertyChangeSupport _propertyChangeSupport;
    private boolean _cleared;

    public SelectionTransaction(SelectionTransaction parentTransaction, int addStartIndex, int removeStartIndex, Map snapshotState) {
        this.$init$();
        this._parentTransaction = parentTransaction;
        this._addStartIndex = addStartIndex;
        this._removeStartIndex = removeStartIndex;
        this._snapshotState = snapshotState;
    }

    public void addSelectionChangeListener(SetChangeListener listener) {
        if (this._selectionChangeListeners == null) {
            this._selectionChangeListeners = new SafeListenerManager();
        }
        this._selectionChangeListeners.addListener(listener);
    }

    public void removeSelectionChangeListener(SetChangeListener listener) {
        this._selectionChangeListeners.removeListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this._propertyChangeSupport == null) {
            this._propertyChangeSupport = new SafePropertyChangeSupport(this);
        }
        this._propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._propertyChangeSupport.removePropertyChangeListener(listener);
    }

    void __selectionCleared() {
        this._cleared = true;
    }

    static {
        $assertionsDisabled = SelectionTransaction.class.desiredAssertionStatus() ^ true;
    }

    private void _calculateRefCounts(ListIterator addIterator, ListIterator removeIterator, Map refCountMap) {
        if (!($assertionsDisabled || refCountMap != null && refCountMap.isEmpty())) {
            throw new AssertionError();
        }
        SelectionTransaction._updateRefCounts(addIterator, 1, refCountMap);
        SelectionTransaction._updateRefCounts(removeIterator, -1, refCountMap);
    }

    private void _rollbackSelectionChanges(Set selectedNodes, LinkedList addList, LinkedList removeList) {
        Map refCountMap = this._createRefCountMap(addList, removeList);
        List transactionAddedList = addList.subList(this._addStartIndex, addList.size());
        List transactionRemovedList = removeList.subList(this._removeStartIndex, removeList.size());
        this._calculateRefCounts(transactionAddedList.listIterator(), transactionRemovedList.listIterator(), refCountMap);
        transactionAddedList.clear();
        transactionRemovedList.clear();
        if (refCountMap.isEmpty()) {
            return;
        }
        for (Object changedNode : refCountMap.keySet()) {
            int refCount = ((Number)refCountMap.get(changedNode)).intValue();
            if (!($assertionsDisabled || refCount >= -1 && refCount <= 1)) {
                throw new AssertionError();
            }
            if (refCount == -1) {
                selectedNodes.add(changedNode);
                continue;
            }
            if (refCount != 1) continue;
            selectedNodes.remove(changedNode);
        }
    }

    private static void _updateRefCounts(ListIterator iterator, int refIncrement, Map currentRefCountMap) {
        if (!$assertionsDisabled && refIncrement != 1 && refIncrement != -1) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && currentRefCountMap == null) {
            throw new AssertionError();
        }
        if (!iterator.hasNext()) {
            return;
        }
        Integer refIncrementObject = IntegerUtils.getInteger((int)refIncrement);
        while (iterator.hasNext()) {
            Object currNode = iterator.next();
            Object refCountObject = currentRefCountMap.get(currNode);
            int refCount = refIncrement;
            if (refCountObject != null) {
                refCount += ((Number)refCountObject).intValue();
                refCountObject = IntegerUtils.getInteger((int)refCount);
            } else {
                refCountObject = refIncrementObject;
            }
            currentRefCountMap.put(currNode, refCountObject);
        }
    }

    private static void _calculateAddedAndRemovedSets(Map refCountMap, Set nodesAdded, Set nodesRemoved) {
        if (!($assertionsDisabled || nodesAdded != null && nodesAdded.isEmpty())) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || nodesRemoved != null && nodesRemoved.isEmpty())) {
            throw new AssertionError();
        }
        if (refCountMap != null) {
            for (Object changedNode : refCountMap.keySet()) {
                int refCount = ((Number)refCountMap.get(changedNode)).intValue();
                if (!($assertionsDisabled || refCount >= -1 && refCount <= 1)) {
                    throw new AssertionError();
                }
                if (refCount == -1) {
                    nodesRemoved.add(changedNode);
                    continue;
                }
                if (refCount != 1) continue;
                nodesAdded.add(changedNode);
            }
        }
    }

    public SelectionTransaction rollback(Selection selection, Set selectedNodes, LinkedList addList, LinkedList removeList) {
        if (this._parentTransaction == null) {
            throw new IllegalStateException("No parent transaction to rollback");
        }
        this._rollbackSelectionChanges(selectedNodes, addList, removeList);
        selection.restoreSnapshotState(this._snapshotState);
        return this._parentTransaction;
    }

    public SelectionTransaction commit(Selection selection, LinkedList addList, LinkedList removeList) {
        if (this._parentTransaction == null) {
            throw new IllegalStateException("No parent transaction to commit");
        }
        this._parentTransaction._mergeChildTransactionState(selection, addList, removeList, this);
        return this._parentTransaction;
    }

    private Map _createRefCountMap(List addList, List removeList) {
        int addCount = addList.size() - this._addStartIndex;
        int removeCount = removeList.size() - this._removeStartIndex;
        return new HashMap((int)((double)(addCount + removeCount) * 1.5));
    }

    private void _mergeChildTransactionState(Selection selection, List addList, List removeList, SelectionTransaction childTransaction) {
        this._cleared |= childTransaction._cleared;
        if (this._selectionChangeListeners != null && !this._selectionChangeListeners.isEmpty()) {
            Map refCountMap = this._createRefCountMap(addList, removeList);
            this._calculateRefCounts(addList.listIterator(childTransaction._addStartIndex), removeList.listIterator(childTransaction._removeStartIndex), refCountMap);
            int setSize = (int)((double)refCountMap.size() * 1.5);
            HashSet nodesAdded = new HashSet(setSize);
            HashSet nodesRemoved = new HashSet(setSize);
            SelectionTransaction._calculateAddedAndRemovedSets(refCountMap, nodesAdded, nodesRemoved);
            if (this._parentTransaction == null) {
                addList.clear();
                removeList.clear();
            }
            this._fireSelectionChanged(selection, nodesAdded, nodesRemoved);
        }
        this._firePropertyChanges(selection, childTransaction._snapshotState, this._cleared);
        if (this._parentTransaction == null) {
            this._cleared = false;
        }
    }

    private void _firePropertyChanges(Selection selection, Map oldState, boolean cleared) {
        if (this._propertyChangeSupport != null && this._propertyChangeSupport.hasListeners()) {
            Map currentState = selection.getSnapshotState(new HashMap(7));
            Iterator keys = oldState.keySet().iterator();
            LinkedList<PropertyChangeEvent> changeEvents = new LinkedList<PropertyChangeEvent>();
            while (keys.hasNext()) {
                Object oldValue;
                Object currKey = keys.next();
                Object currValue = currentState.get(currKey);
                if (currValue == (oldValue = oldState.get(currKey)) || currValue != null && currValue.equals(oldValue)) continue;
                PropertyChangeEvent event = new PropertyChangeEvent(selection, (String)currKey, oldValue, currValue);
                changeEvents.add(event);
            }
            if (cleared) {
                PropertyChangeEvent clearedEvent = new PropertyChangeEvent(selection, "selectionCleared", Boolean.FALSE, Boolean.TRUE);
                changeEvents.add(clearedEvent);
            }
            this._propertyChangeSupport.firePropertyChanges(changeEvents);
        }
    }

    private void _fireSelectionChanged(Selection selection, Set nodesAdded, Set nodesRemoved) {
        if (!$assertionsDisabled && (this._selectionChangeListeners == null || this._selectionChangeListeners.isEmpty())) {
            throw new AssertionError();
        }
        if (nodesAdded != null && !nodesAdded.isEmpty() || nodesRemoved != null && !nodesRemoved.isEmpty()) {
            SetChangeEvent event = new SetChangeEvent(selection, nodesAdded, nodesRemoved);
            Iterator listeners = this._selectionChangeListeners.iterator();
            while (listeners.hasNext()) {
                SetChangeListener currListener = (SetChangeListener)listeners.next();
                try {
                    currListener.setChanged(event);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    selection.getModel().getLogger().log(Level.SEVERE, "Exception during selection change event firing:", t);
                }
            }
        }
    }

    private void $init$() {
        this._cleared = false;
    }
}

