/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model;

import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import oracle.bali.share.collection.OptimisticHashMap;
import oracle.bali.share.util.BooleanUtils;
import oracle.bali.share.util.IntegerUtils;
import oracle.bali.xml.dom.DomCommitException;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.DomModelEvent;
import oracle.bali.xml.dom.DomModelHolder;
import oracle.bali.xml.dom.DomModelListener;
import oracle.bali.xml.dom.DomMutationListener;
import oracle.bali.xml.dom.DomParseProblem;
import oracle.bali.xml.dom.NodeChangeDetails;
import oracle.bali.xml.dom.NodeCustomizationDetails;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.dom.ref.NodeRef;
import oracle.bali.xml.dom.ref.NodeRefFactory;
import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.whitespace.WhitespaceHandler;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.grammar.resolver.GrammarResolverEvent;
import oracle.bali.xml.grammar.resolver.GrammarResolverListener;
import oracle.bali.xml.grammar.util.TypeUtils;
import oracle.bali.xml.metadata.DerivedXmlKey;
import oracle.bali.xml.metadata.DomNodeXmlKey;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.MetadataEvaluator;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.MetadataSchemaRegistry;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.grammar.GrammarMetadataProvider;
import oracle.bali.xml.metadata.grammar.GrammarUtils;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.ModelSelection;
import oracle.bali.xml.model.ModelValidationContext;
import oracle.bali.xml.model.PrecommitOptions;
import oracle.bali.xml.model.PrecommitResults;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.SetChangeEvent;
import oracle.bali.xml.model.SetChangeListener;
import oracle.bali.xml.model.TransactionOptions;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlDomCommitException;
import oracle.bali.xml.model.XmlInvalidOnCommitException;
import oracle.bali.xml.model.XmlMetadataEvaluator;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.XmlNoDocumentOnCommitException;
import oracle.bali.xml.model.XmlReadOnlyException;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.action.ActionManager;
import oracle.bali.xml.model.annotation.AnnotationCommitException;
import oracle.bali.xml.model.annotation.AnnotationModel;
import oracle.bali.xml.model.datatransfer.XmlTransferUtils;
import oracle.bali.xml.model.event.XmlContextLifecycleListener;
import oracle.bali.xml.model.event.XmlModelAdapter;
import oracle.bali.xml.model.grammar.InstanceGrammarListener;
import oracle.bali.xml.model.message.DomParseProblemMessage;
import oracle.bali.xml.model.message.MessageCategory;
import oracle.bali.xml.model.message.ValidationHandler;
import oracle.bali.xml.model.message.XmlModelMessage;
import oracle.bali.xml.model.message.XmlModelMessageLog;
import oracle.bali.xml.model.misc.GrammarBasedWhitespaceHandler;
import oracle.bali.xml.model.resource.PaternalResourceBundle;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.model.task.NonDomMutationTransactionTask;
import oracle.bali.xml.model.traversal.MutableTraversalData;
import oracle.bali.xml.model.traversal.TraversalData;
import oracle.bali.xml.model.traversal.TraversalHandler;
import oracle.bali.xml.model.traversal.XmlTraversalHandler;
import oracle.bali.xml.share.PropertyChange;
import oracle.bali.xml.share.SafeListenerManager;
import oracle.bali.xml.share.TransactionToken;
import oracle.bali.xml.util.CollectionUtils;
import oracle.bali.xml.util.DefaultPrefixLookup;
import oracle.bali.xml.util.DomPositionRef;
import oracle.bali.xml.util.DomPositionRefFactory;
import oracle.bali.xml.util.NamespaceUtils;
import oracle.bali.xml.util.XmlModelUtils;
import oracle.bali.xml.validator.ValidationContext;
import oracle.bali.xml.validator.Validator;
import oracle.bali.xml.validator.prospective.ProspectiveValidationContext;
import oracle.bali.xml.validator.prospective.ProspectiveValidator;
import oracle.javatools.logging.LogUtils;
import oracle.javatools.status.IssueList;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlModel
extends AbstractModel {
    public static final String DOC_CHANGE_COUNT_PROPERTY = "docChangeCount";
    public static final String DOM_DOCUMENT_VALID_PROPERTY = "documentValid";
    public static final String ISSUE_LIST = "XmlModelIssueList";
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final Object _NO_GRAMMAR_FOR_KEY;
    private volatile boolean _isValidStatusCurrent;
    private XmlCommitException _currValidationException;
    private long _timestamp;
    private Set<String> _namespacesInDoc;
    private XmlContext _context;
    private ActionManager _actionManager;
    private ResourceBundle _bundle;
    private MetadataProvider _metadataProvider;
    private ModelSelection _selection;
    private XmlMetadataResolver _metadataResolver;
    private ProspectiveValidationContext _prospectiveValidationContext;
    private TraversalData _traversalData;
    private ValidationHandler _validationHandler;
    private DefaultPrefixLookup _prefixLookup;
    private final ArrayList<TraversalHandler> _traversalHandlers;
    private static final TraversalHandler _XML_TRAVERSAL_HANDLER;
    private final ArrayList _changeSupport;
    private final HashSet _pendingAddListeners;
    private final HashSet _pendingRemoveListeners;
    private final SafeListenerManager _undoListeners;
    private final SafeListenerManager _namespaceChangeListeners;
    private final OptimisticHashMap _grammarComponents;
    private final ConcurrentHashMap<Node, XmlKey> _nodeToKeyCache;
    private final GrammarResolverListener _grammarListener;
    private final LinkedList _nestedEvents;
    private WhitespaceHandler _whitespaceHandler;
    private SelectionStateRef _preTransactionSelectionState;
    private boolean _instantiated;
    private transient XmlModelEvent _currChangeEvent;
    private transient boolean _deliveringHelloGoodbyeEvents;
    private transient boolean _deliveringInvalidateEvents;
    private transient XmlModelEvent _nestedChangeEvent;
    private transient int _nestedListenerIndex;
    private transient int _transactionDepth;
    private transient boolean _helloItrFlag;
    private transient int _lastDomChangeCount;
    private XmlModelMessageLog _messageLog;
    private DomModel _domModel;
    private volatile boolean _inUndoOrRedo;

    public XmlModel() {
        this(null);
    }

    public XmlModel(MetadataProvider provider) {
        this.$init$();
        this._metadataProvider = provider;
        this._selection = new ModelSelection(this);
        this.addTraversalHandler(_XML_TRAVERSAL_HANDLER);
    }

    public final XmlModel getBaseModel() {
        return this;
    }

    public final XmlContext getContext() {
        return this._context;
    }

    public final long getTimestamp() {
        return this._timestamp;
    }

    public void addModelListener(XmlModelListener changeListener) {
        if (changeListener == null) {
            throw new IllegalArgumentException("No adding null change listeners");
        }
        boolean throwDuplicateAdd = this._pendingAddListeners.contains(changeListener);
        if (!throwDuplicateAdd && this._changeSupport.contains(changeListener)) {
            boolean contained = this._pendingRemoveListeners.remove(changeListener);
            if (contained) {
                return;
            }
            throwDuplicateAdd = true;
        }
        if (throwDuplicateAdd) {
            throw new IllegalStateException("No adding the same listener twice");
        }
        if (this.isDeliveringEvents()) {
            boolean inRemoveListeners = this._pendingRemoveListeners.remove(changeListener);
            if (!inRemoveListeners) {
                this._pendingAddListeners.add(changeListener);
            }
        } else {
            if (this._helloItrFlag) {
                this.getLogger().log(Level.SEVERE, "Illegal updating of listener list while iteratoring", new IllegalStateException());
            }
            this._changeSupport.add(changeListener);
            if (this.isFullyInstantiated()) {
                List<XmlModelListener> addedListener = Collections.singletonList(changeListener);
                this._deliverHelloGoodbyeEvents(true, addedListener);
            }
        }
    }

    public void removeModelListener(XmlModelListener changeListener) {
        boolean removed = this._pendingAddListeners.remove(changeListener);
        if (!removed) {
            if (this.isDeliveringEvents()) {
                removed = this._changeSupport.contains(changeListener);
                if (removed) {
                    this._pendingRemoveListeners.add(changeListener);
                }
            } else {
                if (this._helloItrFlag) {
                    this.getLogger().log(Level.SEVERE, "Illegal updating of listener list while iteratoring", new IllegalStateException());
                }
                if ((removed = this._changeSupport.remove(changeListener)) && this.isFullyInstantiated()) {
                    List<XmlModelListener> removedListener = Collections.singletonList(changeListener);
                    this._deliverHelloGoodbyeEvents(false, removedListener);
                }
            }
            if (!removed) {
                throw new IllegalStateException("Listener " + changeListener + " was never registered on " + this);
            }
        }
    }

    public final boolean isFullyInstantiated() {
        return this._instantiated;
    }

    public final DomModel getDomModel() {
        if (this._domModel == null) {
            this._whitespaceHandler = this.createWhitespaceHandler();
            if (this._whitespaceHandler == null) {
                this._whitespaceHandler = new GrammarBasedWhitespaceHandler(this);
            }
            this._domModel = this._context.createDomModel(this);
        }
        return this._domModel;
    }

    public final Document getDocument() {
        return this.getDomModel().getDocument();
    }

    public final void destroyDocument() {
        this.getDomModel().destroyDocument();
    }

    public final boolean isDocumentValid() {
        this._validateDocument(true);
        return this._currValidationException == null;
    }

    public final int getDocChangeCount() {
        return this.getDomModel().getDocChangeCount();
    }

    public final boolean isInTransaction() {
        return this._transactionDepth != 0;
    }

    public final void startTransaction(TransactionOptions transOptions) {
        this.__requestStartTransaction(this, transOptions);
    }

    public final boolean commitTransaction() throws XmlCommitException {
        return this.commitTransaction(true);
    }

    public final boolean commitTransaction(boolean exceptionIfInvalid) throws XmlCommitException {
        return this.__requestCommitTransaction(this, exceptionIfInvalid);
    }

    public final void rollbackTransaction() {
        this.__requestRollbackTransaction(this);
    }

    public final XmlMetadataResolver getXmlMetadataResolver() {
        return this._metadataResolver;
    }

    public final boolean initializeNewNode(Node node, XmlKey xmlKey) {
        SimpleType simpleType;
        boolean allRequiredAttributeHaveValue = true;
        if (node.getNodeType() != 1) {
            return this.initializeNewNodeHook(node, xmlKey, allRequiredAttributeHaveValue);
        }
        XmlMetadataResolver resolver = this.getXmlMetadataResolver();
        GrammarComponent gc = resolver.getGrammarComponent(xmlKey);
        if (gc == null || !(gc instanceof ElementDef)) {
            return this.initializeNewNodeHook(node, xmlKey, allRequiredAttributeHaveValue);
        }
        XmlContext context = this.getContext();
        ElementDef grammarElement = (ElementDef)gc;
        Element domElement = (Element)node;
        if (this.getXmlMetadataResolver().isTextDisplayedAsAttribute(xmlKey) && (simpleType = TypeUtils.getSimpleTypeAncestor((Type)grammarElement.getType())) != null) {
            try {
                String domElementString = DomUtils.getTextNodeValue((Node)domElement);
                if (domElementString == null) {
                    domElementString = "";
                }
                simpleType.validateValue(domElementString);
            }
            catch (GrammarException e) {
                allRequiredAttributeHaveValue = false;
            }
        }
        Collection grammarAttributes = grammarElement.getAttributeDefs();
        for (AttributeDef attribute : grammarAttributes) {
            String attrNamespace = attribute.getTargetNamespace();
            String attrLocalName = attribute.getName();
            XmlKey attrKey = DerivedXmlKey.createAttributeKey((GrammarResolver)context.getGrammarResolver(), (XmlKey)xmlKey, (QualifiedName)attribute.getQualifiedName()).intern();
            boolean required = this.getXmlMetadataResolver().isRequired(attrKey, xmlKey);
            if ("".equals(attrNamespace)) {
                attrNamespace = null;
            }
            if (!this.shouldInsertInitialValue(node, attrKey)) continue;
            String value = this.createAttributeValue(attrKey);
            if (value == null && required) {
                if (attribute.getFixedValue() != null) {
                    value = attribute.getFixedValue();
                } else if (attribute.getDefaultValue() != null) {
                    value = attribute.getDefaultValue();
                }
            }
            if (value != null) {
                DomUtils.setAttribute((Element)domElement, (String)attrNamespace, (String)attrLocalName, (String)value);
                continue;
            }
            if (!required) continue;
            allRequiredAttributeHaveValue = false;
        }
        Collection grammarElements = grammarElement.getElementDefs();
        for (ElementDef child : grammarElements) {
            XmlKey childKey = DerivedXmlKey.createElementKey((GrammarResolver)context.getGrammarResolver(), (XmlKey)xmlKey, (QualifiedName)child.getQualifiedName()).intern();
            if (!this.getXmlMetadataResolver().isTextDisplayedAsAttribute(childKey) && !this.getXmlMetadataResolver().getVirtualAttributeKeys(xmlKey).contains(childKey)) continue;
            boolean required = this.getXmlMetadataResolver().isRequired(childKey, xmlKey);
            if (!this.shouldInsertInitialValue(node, childKey)) continue;
            String value = this.createValue(childKey);
            if (value == null && required && child.getFixedValue() != null) {
                value = child.getFixedValue();
            }
            if (value != null) {
                Element childNode = DomUtils.createElementNode((Document)node.getOwnerDocument(), (QualifiedName)child.getQualifiedName());
                DomUtils.setTextNodeValue((Node)childNode, (String)value);
                DomPosition position = this.findValidInsertionPosition(childKey, childNode, DomPositionFactory.inside((Node)node), xmlKey);
                DomUtils.insertNodeAtPosition((DomPosition)position, (Node)childNode);
                continue;
            }
            if (!required) continue;
            allRequiredAttributeHaveValue = false;
        }
        boolean ok = !allRequiredAttributeHaveValue ? false : this.allRequiredAttributesHaveValueHook(node, xmlKey);
        return this.initializeNewNodeHook(node, xmlKey, ok);
    }

    protected boolean initializeNewNodeHook(Node node, XmlKey key, boolean wasOk) {
        return wasOk;
    }

    public final int getTextOffset(DomPosition pos) {
        return this.getDomModel().getTextOffset(pos);
    }

    public Node surroundSelection(XmlKey surroundingKey) throws XmlCommitException {
        this.__verifyWriteLock();
        if (surroundingKey == null || surroundingKey.getNodeType() != 1) {
            throw new IllegalArgumentException("Invalid key passed to surround");
        }
        if (this.getSelection().isEmpty()) {
            return null;
        }
        return this.surroundSelectionImpl(surroundingKey);
    }

    public Node remapNode(List oldNodePath) {
        Document currDocument = this.getDocument();
        if (currDocument == null) {
            return null;
        }
        int pathNodeCount = oldNodePath.size();
        if (pathNodeCount == 0) {
            return null;
        }
        int lastNodeIndex = pathNodeCount - 1;
        Node lastNode = (Node)oldNodePath.get(lastNodeIndex);
        Document nodeDocument = lastNode.getOwnerDocument();
        if (nodeDocument == currDocument) {
            if (DomUtils.isInDocumentHierarchy((Node)lastNode)) {
                return lastNode;
            }
            ListIterator backwardsIterator = oldNodePath.listIterator(lastNodeIndex);
            while (backwardsIterator.hasPrevious()) {
                Node currNode = (Node)backwardsIterator.previous();
                if (!DomUtils.isInDocumentHierarchy((Node)currNode)) continue;
                return currNode;
            }
            return null;
        }
        Node lastEqualNewNode = currDocument;
        Node currNewNode = lastEqualNewNode;
        for (Node currOldNode : oldNodePath) {
            String oldLocalName;
            String newLocalName;
            int oldIndex = DomUtils.getChildIndex((Node)currOldNode);
            if ((currNewNode = currNewNode.getChildNodes().item(oldIndex)) == null) break;
            short newNodeType = currNewNode.getNodeType();
            if (currOldNode.getNodeType() != newNodeType || newNodeType == 1 && !(newLocalName = DomUtils.getLocalName((Node)currNewNode)).equals(oldLocalName = DomUtils.getLocalName((Node)currOldNode))) break;
            lastEqualNewNode = currNewNode;
        }
        return lastEqualNewNode;
    }

    public Object getService(Object selector) {
        return this.getContext().getService(selector);
    }

    static {
        $assertionsDisabled = XmlModel.class.desiredAssertionStatus() ^ true;
        _NO_GRAMMAR_FOR_KEY = new Object();
        _XML_TRAVERSAL_HANDLER = new XmlTraversalHandler();
        MetadataSchemaRegistry.getInstance().registerSchema(XmlMetadataResolver.class.getResource("metadata/XmlModelMetadata.xsd"));
    }

    public WhitespaceHandler getWhitespaceHandler() {
        if (!$assertionsDisabled && this._whitespaceHandler == null) {
            throw new AssertionError();
        }
        return this._whitespaceHandler;
    }

    public Selection getSelection() {
        return this._selection;
    }

    public String getTranslatedString(String key) {
        ResourceBundle bundle = this.getBundle();
        if (bundle != null) {
            try {
                String translatedString;
                String string = translatedString = bundle.getString(key);
                return string;
            }
            catch (MissingResourceException e) {
                this.getLogger().log(Level.SEVERE, "Could not find resource key:" + key + " in bundle:" + bundle);
            }
        }
        return "??" + key + "??";
    }

    public Action getAction(String commandString) {
        Action modelAction = this._actionManager.getAction(commandString);
        if (modelAction != null) {
            return modelAction;
        }
        return this.getContext().getAction(commandString);
    }

    public TreeWalker createTreeWalker() {
        Document modelDocument = this.getDocument();
        return DomUtils.createTreeWalker((Node)modelDocument.getDocumentElement(), (int)-1, null, null);
    }

    public TreeTraversal getTreeTraversal() {
        return DocumentTreeTraversal.INSTANCE;
    }

    public TraversalData getTraversalData() {
        this.__verifyLock();
        if (this._traversalData == null) {
            this._traversalData = this._rebuildTraversalData();
        }
        return this._traversalData;
    }

    public XmlKey getNodeXmlKey(Node node) {
        XmlKey key = this._nodeToKeyCache.get(node);
        if (key == null) {
            this.__verifyLock();
            key = DomNodeXmlKey.createImmutableXmlKey((GrammarResolver)this.getContext().getGrammarResolver(), (Node)node);
            if (this.isInModelDocumentHierarchy(node)) {
                this._nodeToKeyCache.put(node, key);
            }
        }
        return key;
    }

    public GrammarComponent getGrammarComponent(XmlKey key) {
        if (key == null) {
            return null;
        }
        Object cachedValue = this._grammarComponents.get((Object)key);
        if (_NO_GRAMMAR_FOR_KEY == cachedValue) {
            return null;
        }
        GrammarComponent grammarComp = (GrammarComponent)cachedValue;
        if (grammarComp == null) {
            if (grammarComp == null) {
                GrammarResolver resolver = this.getContext().getGrammarResolver();
                grammarComp = GrammarUtils.getGrammarComponent((GrammarResolver)resolver, (XmlKey)key);
            }
            if (key.isImmutable()) {
                Object cacheValue = grammarComp != null ? grammarComp : _NO_GRAMMAR_FOR_KEY;
                this._grammarComponents.put((Object)key, cacheValue);
            }
        }
        return grammarComp;
    }

    public final Collection deleteNodes(String transactionName, Collection nodes, boolean updateSelection) throws XmlCommitException {
        if (nodes == null) {
            throw new IllegalArgumentException("null nodes");
        }
        if (nodes.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Collection[] ret = new Collection[1];
        new 1(this, transactionName, updateSelection, nodes, ret).runThrowingXCE(this);
        return ret[0];
    }

    public final Collection deleteNodes(String transactionName, DomRange range, boolean updateSelection) throws XmlCommitException {
        if (range == null) {
            throw new IllegalArgumentException("null range");
        }
        if (range.isEmptyRange()) {
            return null;
        }
        Collection[] ret = new Collection[1];
        new 2(this, transactionName, range, ret, updateSelection).runThrowingXCE(this);
        return ret[0];
    }

    protected void deleteInsideAttributeValueImpl(DomRange range) {
        DomPosition start = range.getStart();
        Element owner = (Element)start.getTargetNode();
        Attr attr = DomUtils.getAttribute((Element)owner, (QualifiedName)start.getAttributeQName());
        int offset1 = start.getTextOffset();
        int offset2 = range.getEnd().getTextOffset();
        int len = offset2 - offset1;
        String oldValue = attr.getNodeValue();
        StringBuffer buf = new StringBuffer(oldValue.length() - len);
        buf.append(oldValue.substring(0, offset1));
        buf.append(oldValue.substring(offset2));
        attr.setValue(buf.toString());
    }

    protected Collection deleteNodesImpl(Collection nodes) {
        Document modelDoc = this.getDocument();
        TreeTraversal traversal = this.getTreeTraversal();
        ArrayList deleted = new ArrayList(nodes.size());
        for (Node node : nodes) {
            if (DomUtils.getOwnerDocument((Node)node) != modelDoc) {
                throw new IllegalArgumentException("node has wrong owner doc: " + node);
            }
            if (!DomUtils.isInDocumentHierarchy((TreeTraversal)traversal, (Node)node)) continue;
            this.deleteNodeImpl(node, deleted);
        }
        return deleted;
    }

    protected void deleteNodeImpl(Node node, Collection deleted) {
        if (this.getXmlMetadataResolver().isDeletable(node)) {
            Node parent = this.getTreeTraversal().getParentNode(node);
            parent.removeChild(node);
            deleted.add(node);
        }
    }

    public final Collection insertNodes(DomPosition location, String transactionName, Collection nodes, boolean updateSelection) throws XmlCommitException {
        if (location == null || nodes == null) {
            throw new IllegalArgumentException("nodes or location null!");
        }
        if (location.hasAttributeQName()) {
            throw new IllegalArgumentException("can't insert node into attribute!");
        }
        if (nodes.isEmpty()) {
            return null;
        }
        Collection[] ret = new Collection[1];
        new 3(this, transactionName, location, nodes, updateSelection, ret).runThrowingXCE(this);
        return ret[0];
    }

    protected boolean insertIntoAttributeValue(Collection nodes, DomPosition location) {
        Attr attr;
        if (DomUtils.isAllNodeType((Collection)nodes, (int)3) && (attr = DomUtils.getAttribute((Element)((Element)location.getTargetNode()), (QualifiedName)location.getAttributeQName())) != null) {
            String origValue = attr.getNodeValue();
            int offset = location.getTextOffset();
            StringBuffer buf = new StringBuffer(200);
            buf.append(origValue.substring(0, offset));
            for (Text text : nodes) {
                buf.append(text.getNodeValue());
            }
            buf.append(origValue.substring(offset));
            attr.setNodeValue(buf.toString());
            return true;
        }
        return false;
    }

    protected Collection insertNodesImpl(DomPosition location, Collection nodes, boolean updateSelection) throws XmlCommitException {
        DomPosition textLikeIfPossible;
        Node sourceNode;
        boolean done = false;
        LinkedList<Node> created = new LinkedList<Node>();
        if (nodes.size() == 1 && DomUtils.isText((Node)(sourceNode = (Node)nodes.iterator().next())) && (textLikeIfPossible = this.getTextPositionIfPossible(location)) != null && textLikeIfPossible.hasTextOffset()) {
            Node textTarget = textLikeIfPossible.getTargetNode();
            this.insertIntoTextNode((CharacterData)textTarget, textLikeIfPossible.getTextOffset(), sourceNode.getNodeValue());
            created.add(textTarget);
            done = true;
        }
        if (!done) {
            DomPosition nextLoc = location = this.splitAtPositionIfNeeded(location, true);
            for (Node node : nodes) {
                nextLoc = this.insertNodeImpl(nextLoc, node, created);
            }
        }
        if (updateSelection) {
            this.selectInsertedNodes(created);
        }
        return created;
    }

    protected DomPosition insertNodeImpl(DomPosition location, Node node, Collection created) throws XmlCommitException {
        DomPosition preferredPos = this.findValidInsertionPosition(null, node, location, null);
        if (preferredPos == null) {
            return location;
        }
        created.add(node);
        this.fixPrefixes(preferredPos.getContainerNode(), node);
        DomUtils.insertNodeAtPosition((DomPosition)preferredPos, (Node)node);
        if (preferredPos == location) {
            return DomPositionFactory.after((Node)node);
        }
        return location;
    }

    protected void postProcessInsertedNodes(Collection nodes) throws XmlCommitException {
    }

    public Transferable createTransferable() {
        this.acquireReadLock();
        try {
            if (!this.getXmlMetadataResolver().isSelectionTransferable()) {
                Transferable transferable = null;
                return transferable;
            }
            Selection sel = this.getSelection();
            if (sel.hasRangeSelection()) {
                DomRange range = sel.getRangeSelection();
                if (range.isEmptyRange()) {
                    Transferable transferable = null;
                    return transferable;
                }
                if (range.isInsideAttributeValue()) {
                    Transferable transferable = this.createTransferableForAttrValueRange(range);
                    return transferable;
                }
                Transferable transferable = this.createTransferableForRange(range);
                return transferable;
            }
            Transferable transferable = this.createTransferableForNodes(sel.getSelectedNodes());
            return transferable;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.releaseReadLock();
        }
    }

    protected Transferable createTransferableForAttrValueRange(DomRange range) {
        return null;
    }

    protected final Transferable createTransferableForRange(DomRange range) {
        List nodes = DomUtils.cloneRangeToList((TreeTraversal)this.getTreeTraversal(), (DomRange)range);
        return XmlTransferUtils.createDomNodesTransferable(this, nodes, range, this.getXmlMetadataResolver().isSelectionDeletable());
    }

    protected final Transferable createTransferableForNodes(Iterator nodeItor) {
        LinkedList<Node> list = new LinkedList<Node>();
        while (nodeItor.hasNext()) {
            Node node = (Node)nodeItor.next();
            if (!this.getXmlMetadataResolver().isTransferable(node)) continue;
            list.add(node);
        }
        if (list.isEmpty()) {
            return null;
        }
        return XmlTransferUtils.createDomNodesTransferable(this, list, this.getXmlMetadataResolver().isSelectionDeletable());
    }

    public boolean isReadOnly() {
        return this.getDomModel().isReadOnly();
    }

    public final NodeCustomizationDetails getCustomizationDetails(Node node) {
        return this.getDomModel().getCustomizationDetails(node);
    }

    protected final boolean isImmutable(Node node) {
        if (this.isReadOnly()) {
            return true;
        }
        if (node == null) {
            return false;
        }
        return this.getDomModel().isImmutable(node);
    }

    protected final boolean isDeletable(Node node) {
        if (node == null) {
            return false;
        }
        if (this.requiresValidModel() && node == this.getDocument().getDocumentElement()) {
            return false;
        }
        return this.getDomModel().isDeletable(node);
    }

    protected final boolean canAddChild(DomPosition position) {
        if (position == null) {
            return false;
        }
        return this.getDomModel().canAddChild(position);
    }

    protected final boolean canAddAttribute(Element parent, XmlKey attrKey) {
        if (parent == null || attrKey.getNodeType() != 2) {
            return false;
        }
        QualifiedName attrName = attrKey.getAttributeQName();
        if (attrName != null) {
            return this.getDomModel().canAddAttribute(parent, attrName.getNamespace(), attrName.getName());
        }
        return false;
    }

    protected final boolean isValueModifiable(Node node) {
        if (node == null) {
            return false;
        }
        return this.getDomModel().isValueModifiable(node);
    }

    public final void fixPrefixes(Node parent, Node subtree) {
        this.fixPrefixes(parent, subtree, this.getDefaultPrefixLookup());
    }

    public void fixPrefixes(Node parent, Node subtree, DefaultPrefixLookup defaultPrefixLookup) {
        if (defaultPrefixLookup == null) {
            defaultPrefixLookup = this.getDefaultPrefixLookup();
        }
        boolean declarePrefixesOnRoot = this.getDomModel().prefersSmallestPossibleChangeRoot() ^ true;
        NamespaceUtils.fixPrefixes(parent, subtree, defaultPrefixLookup, declarePrefixesOnRoot);
    }

    public DefaultPrefixLookup getDefaultPrefixLookup() {
        return this._prefixLookup;
    }

    public DomPosition convertInsertionPosition(DomPosition origPosition) {
        DomPosition betterPos = origPosition;
        if (betterPos != null) {
            Node target = betterPos.getTargetNode();
            if (DomUtils.isDocument((Node)target)) {
                betterPos = betterPos.getInsidePosition();
            } else if (betterPos.isInside() && !betterPos.hasAttributeQName() && !betterPos.hasTextOffset() && !this.getXmlMetadataResolver().canAddChild(betterPos)) {
                betterPos = betterPos.getAfterPosition();
            }
        }
        return betterPos;
    }

    public DomPosition findValidInsertionPosition(XmlKey keyToInsert, Node nodeToInsert, DomPosition requestedPosition, XmlKey containerKey) {
        Set validPositions = ProspectiveValidator.findValidInsertionPositions((ProspectiveValidationContext)this._prospectiveValidationContext, (XmlKey)keyToInsert, (Node)nodeToInsert, (DomPosition)requestedPosition, (XmlKey)containerKey);
        return ProspectiveValidator.chooseBestPosition((ProspectiveValidationContext)this._prospectiveValidationContext, (XmlKey)keyToInsert, (Node)nodeToInsert, (DomPosition)requestedPosition, (XmlKey)containerKey, (Set)validPositions);
    }

    public String createAttributeValue(XmlKey attrKey) {
        if (attrKey == null || attrKey.getAttributeQName() == null) {
            return null;
        }
        return this.createValue(attrKey);
    }

    public String createValue(XmlKey key) {
        XmlMetadataResolver resolver = this.getXmlMetadataResolver();
        String initialValue = resolver.getInitialValue(key);
        if (initialValue != null) {
            if (!initialValue.contains("{0}")) {
                return initialValue;
            }
            return this.getInitialValue(key, initialValue);
        }
        return null;
    }

    public final boolean isDeliveringEvents() {
        return this._deliveringInvalidateEvents || this._deliveringHelloGoodbyeEvents || this._nestedChangeEvent != null;
    }

    public XmlModelMessageLog getXmlModelInternalMessageLog() {
        this.__verifyLock();
        return this._messageLog;
    }

    public void updateMessages(MessageCategory category, List messages) {
        if (category == MessageCategory.PARSING || category == MessageCategory.GRAMMAR_VALIDITY) {
            throw new IllegalArgumentException("updateMessages can not be used to update parse or grammar messages!");
        }
        new 4(this, category, messages).run(this);
    }

    void __sendIssueListEvent(IssueList issueList) {
        new 5(this, issueList).run(this);
    }

    public void addNamespacesChangeListener(SetChangeListener listener) {
        this._namespaceChangeListeners.addListener(listener);
    }

    public void removeNamespacesChangeListener(SetChangeListener listener) {
        this._namespaceChangeListeners.removeListener(listener);
    }

    public void addTraversalHandler(TraversalHandler handler) {
        this._traversalHandlers.add(handler);
    }

    public boolean removeTraversalHandler(TraversalHandler handler) {
        return this._traversalHandlers.remove(handler);
    }

    public final void acquireReadLock() {
        this.getDomModel().acquireReadLock();
        this.getContext().getAnnotationModel().acquireReadLock();
    }

    public final void releaseReadLock() {
        this.getDomModel().releaseReadLock();
        this.getContext().getAnnotationModel().releaseReadLock();
    }

    protected List getViewExtraContextMenus(XmlView view, DomPosition viewPosition) {
        if (view == null) {
            return Collections.EMPTY_LIST;
        }
        return this.getContext().getDefaultExtraContextMenus(view, viewPosition);
    }

    protected void contextAttached() {
    }

    protected void postAttachmentHook() {
        this.initActions();
    }

    protected void postCreationHook() {
    }

    protected void initActions() {
        Action gotoDeclaration;
        XmlContext context = this.getContext();
        Action gotoSource = context.createModelAction("gotosource", this);
        if (gotoSource != null) {
            this.addAction(gotoSource);
        }
        if ((gotoDeclaration = context.createModelAction("gotodeclaration", this)) != null) {
            this.addAction(gotoDeclaration);
        }
    }

    protected void addAction(Action action) {
        this._actionManager.manageAction(action);
    }

    protected void addCurrentPropertiesToEvent(Map propertyChanges, boolean isAdding) {
        super.addCurrentPropertiesToEvent(propertyChanges, isAdding);
        boolean isValid = this.isDocumentValid();
        PropertyChange isValidChange = null;
        if (isAdding) {
            isValidChange = isValid ? new PropertyChange(DOM_DOCUMENT_VALID_PROPERTY, Boolean.FALSE, Boolean.TRUE) : new PropertyChange(DOM_DOCUMENT_VALID_PROPERTY, Boolean.TRUE, Boolean.FALSE);
        } else if (isValid) {
            isValidChange = new PropertyChange(DOM_DOCUMENT_VALID_PROPERTY, Boolean.TRUE, Boolean.FALSE);
        }
        if (isValidChange != null) {
            propertyChanges.put(DOM_DOCUMENT_VALID_PROPERTY, isValidChange);
        }
        propertyChanges.put(ISSUE_LIST, new PropertyChange(ISSUE_LIST, null, this.getXmlModelInternalMessageLog()));
    }

    protected void copiedNodeFilter(Node copiedNode, Node parentNode, Node beforeNode) {
    }

    protected final ResourceBundle getBundle() {
        return this._bundle;
    }

    protected XmlMetadataResolver createMetadataResolver(MetadataProvider provider) {
        XmlMetadataEvaluator evaluator = new XmlMetadataEvaluator(provider, this._context.getGrammarProvider(), this._context.getGrammarResolver(), this);
        return new XmlMetadataResolver((MetadataEvaluator)evaluator, this);
    }

    protected ResourceBundle createBundle() throws MissingResourceException {
        return this.getContext().getBundle();
    }

    protected ResourceBundle createBundle(String bundleName) throws MissingResourceException {
        XmlContext context = this.getContext();
        return new PaternalResourceBundle(new ResourceBundle[]{ResourceBundle.getBundle(bundleName, context.getLocale()), context.getBundle()});
    }

    protected WhitespaceHandler createWhitespaceHandler() {
        return null;
    }

    protected void handleModelInvalidateEvent(XmlModelEvent event) {
        if (this._doesEventInvalidateXmlKeyCache(event)) {
            this._nodeToKeyCache.clear();
        }
    }

    private boolean _doesEventInvalidateXmlKeyCache(XmlModelEvent event) {
        if (event.matchesFlags(6)) {
            return true;
        }
        return XmlModelUtils.fixedAttributeMightHaveChanged(event);
    }

    protected void handleModelChangeEvent(XmlModelEvent event) {
    }

    protected boolean shouldInsertInitialValue(Node ownerNode, XmlKey key) {
        if (key.getNodeType() == 2) {
            QualifiedName qn = key.getAttributeQName();
            NamedNodeMap attrs = ownerNode.getAttributes();
            Node attr = attrs.getNamedItemNS(qn.getNamespace(), qn.getName());
            return attr == null || attr.getNodeValue() == null;
        }
        if (key.getNodeType() == 1) {
            QualifiedName qn = key.getElementQName();
            Node child = DomUtils.getNamedChild((Node)ownerNode, (String)qn.getNamespace(), (String)qn.getName());
            return child == null ? true : DomUtils.getTextNodeValue((Node)child) == null;
        }
        return false;
    }

    protected Node determineValidationRoot() {
        return this.getDocument();
    }

    protected void setValidationFeatures(ValidationContext validationContext) {
    }

    protected Node surroundSelectionImpl(XmlKey surroundingKey) throws XmlCommitException {
        return XmlModelUtils.surroundSelection(this, surroundingKey);
    }

    protected void mergeTextNodesImpl(Text a, Text b) {
        AbstractModel.MapperForMergeTextNodes mapper = new AbstractModel.MapperForMergeTextNodes(a, b);
        this.getDomModel().mergeTextNodes(a, b);
        mapper.applyMappings();
    }

    protected Text splitTextNodeImpl(Text orig, int offset) {
        AbstractModel.MapperForSplitTextNode mapper = new AbstractModel.MapperForSplitTextNode(orig, offset);
        Text created = this.getDomModel().splitTextNode(orig, offset);
        mapper.setCreated(created);
        mapper.applyMappings();
        return created;
    }

    protected boolean allRequiredAttributesHaveValueHook(Node node, XmlKey key) {
        return true;
    }

    protected final void deliverInitialEvents() {
        if (this.isFullyInstantiated()) {
            this._deliverHelloGoodbyeEvents(true, this._changeSupport);
        }
    }

    final void __attachContext(XmlContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Null context passed to XmlModel");
        }
        if (this._context != null) {
            throw new IllegalStateException("Cannot attach a context twice");
        }
        this._context = context;
        this._context.addLifecycleListener(new 6());
        this._actionManager = new ActionManager(context);
        ResourceBundle bundle = null;
        try {
            bundle = this.createBundle();
        }
        catch (MissingResourceException e) {
            this.getLogger().log(Level.WARNING, "No resource bundle for model", e);
        }
        this._bundle = bundle;
        GrammarResolver grammarResolver = context.getGrammarResolver();
        if (this._metadataProvider == null) {
            this._metadataProvider = new GrammarMetadataProvider(grammarResolver);
        }
        grammarResolver.addGrammarResolverListener(this._grammarListener);
        DomModel domModel = this.getDomModel();
        this._metadataResolver = this.createMetadataResolver(this._metadataProvider);
        this.acquireReadLock();
        try {
            this._prefixLookup = new MetadataBasedPrefixLookup(this._metadataResolver);
            List initialProblems = domModel.getCurrentDomParseProblems();
            this.getLogger().log(Level.FINER, "Initial parse problems: {0}", initialProblems);
            this._updateParseMessages(initialProblems);
        }
        finally {
            this.releaseReadLock();
        }
        DomListener listener = new DomListener(null);
        domModel.addDomChangeListener(listener);
        domModel.addUndoableEditListener(listener);
        domModel.addDomMutationListener(listener);
        this.acquireReadLock();
        try {
            this._lastDomChangeCount = domModel.getDocChangeCount();
        }
        finally {
            this.releaseReadLock();
        }
        this._selection.__attachToDomModel();
        this._selection.addSelectionChangeListener(listener);
        this._selection.addPropertyChangeListener(listener);
        this._prospectiveValidationContext = new XmlModelProspectiveValidationContext();
        this.addModelListener(new NamespaceSetChecker(null));
        this.addGrammarModelListener();
    }

    protected void addGrammarModelListener() {
        this.addModelListener(new InstanceGrammarListener());
    }

    void __initializationComplete() {
        Logger log = this.getLogger();
        if (log.isLoggable(Level.FINER)) {
            LogUtils.log((Logger)log, (Level)Level.FINER, (String)"__initComplete on model {0}, context {1}, thread {2}", (Object[])new Object[]{this, this._context, Thread.currentThread()}, (Throwable)new Throwable("stack trace"));
        }
        this._validateDocument(false);
        this._instantiated = true;
        this.deliverInitialEvents();
    }

    final void __addUndoableEditListener(UndoableEditListener l) {
        this._undoListeners.addListener(l);
    }

    final void __removeUndoableEditListener(UndoableEditListener l) {
        this._undoListeners.removeListener(l);
    }

    final void __acquireWriteLock() {
        this.getDomModel().acquireWriteLock();
    }

    final void __releaseWriteLock() {
        this.getDomModel().releaseWriteLock();
    }

    final void __verifyLock() {
        this.getDomModel().verifyLock();
    }

    final void __verifyWriteLock() {
        this.getDomModel().verifyWriteLock();
    }

    final int __getTransactionDepth() {
        return this._transactionDepth;
    }

    final void __requestStartTransaction(AbstractModel requestingModel, TransactionOptions transOptions) {
        boolean didntHaveLockBefore;
        if (!$assertionsDisabled && requestingModel.getBaseModel() != this) {
            throw new AssertionError((Object)("requestingModel " + requestingModel + " doesn't belong to " + this));
        }
        boolean bl = didntHaveLockBefore = this.getDomModel().getLockStatus() == 0;
        if (didntHaveLockBefore) {
            this.__acquireWriteLock();
            try {
                this.getContext().preStartTopLevelTransactionHook(transOptions);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                LogUtils.log((Logger)this.getLogger(), (Level)Level.SEVERE, (String)"Unexpected exception calling preStartTopLevelTransactionHook for context {0}", (Object)this.getContext(), (Throwable)t);
            }
            try {
                this.getContext().__startTransaction(requestingModel, transOptions);
            }
            finally {
                this.__releaseWriteLock();
            }
        }
        this.getContext().__startTransaction(requestingModel, transOptions);
    }

    final void __startTransaction(TransactionOptions transOptions) {
        String description = transOptions.getDescription();
        this._transactionLog("start ", description);
        this.acquireReadLock();
        try {
            try {
                if (this._transactionDepth == 0) {
                    this._preTransactionSelectionState = new SelectionStateRef(this.getSelection());
                }
            }
            catch (IllegalArgumentException iae) {
                this.getLogger().log(Level.WARNING, "Exception creating pre-txn state", iae);
                this._preTransactionSelectionState = new SelectionStateRef();
            }
        }
        finally {
            this.releaseReadLock();
        }
        this.getDomModel().startTransaction(description);
        if (this._deliveringInvalidateEvents) {
            this.getDomModel().rollbackTransaction();
            throw new IllegalStateException("No starting transaction while delivering invalidate events");
        }
        ++this._transactionDepth;
        boolean ok = false;
        try {
            this.getSelection().__startTransaction();
            ok = true;
        }
        finally {
            if (!ok) {
                --this._transactionDepth;
                this.getDomModel().rollbackTransaction();
            }
        }
        if (ok) {
            ok = false;
            try {
                this.getContext().getAnnotationModel().startTransaction(description);
                ok = true;
            }
            finally {
                if (!ok) {
                    --this._transactionDepth;
                    this.getSelection().__rollbackTransaction();
                    this.getDomModel().rollbackTransaction();
                }
            }
        }
    }

    final PrecommitResults __precommitTransaction(PrecommitOptions precommitOptions) {
        DomCommitException domException;
        Node changeTarget;
        if (this._transactionDepth == 0) {
            throw new IllegalStateException("No transaction open on:" + this);
        }
        if (this._deliveringInvalidateEvents) {
            throw new IllegalStateException("No starting transaction while delivering invalidate events");
        }
        boolean validationSucceeded = true;
        DomModel domModel = this.getDomModel();
        if (domModel.isInTopLevelTransaction() && (changeTarget = domModel.getChangeTarget()) != null) {
            if (this.isReadOnly()) {
                return PrecommitResults.createFailedResult(new XmlReadOnlyException(this));
            }
            XmlCommitException validationException = this._validateDocument(true);
            if (validationException != null) {
                validationSucceeded = false;
                if (precommitOptions.requiresValidModel()) {
                    return PrecommitResults.createFailedResult(validationException);
                }
            }
        }
        if ((domException = domModel.precommitTransaction()) != null) {
            return PrecommitResults.createFailedResult(new XmlDomCommitException(this, domException));
        }
        AnnotationCommitException fatalException = this.getContext().getAnnotationModel().precommitTransaction(precommitOptions);
        if (fatalException != null) {
            return PrecommitResults.createFailedResult(fatalException);
        }
        return PrecommitResults.createSuccesfulResult(validationSucceeded);
    }

    final PrecommitResults __requestPrecommitTransaction(AbstractModel requestingModel, PrecommitOptions precommitOptions) {
        if (!$assertionsDisabled && requestingModel.getBaseModel() != this) {
            throw new AssertionError((Object)("requestingModel " + requestingModel + " doesn't belong to " + this));
        }
        return this.getContext().__precommitTransaction(requestingModel, precommitOptions);
    }

    final boolean __requestCommitTransaction(AbstractModel requestingModel, boolean exceptionIfInvalid) throws XmlCommitException {
        if (!$assertionsDisabled && requestingModel.getBaseModel() != this) {
            throw new AssertionError((Object)("requestingModel " + requestingModel + " doesn't belong to " + this));
        }
        return this.getContext().__commitTransaction(requestingModel, exceptionIfInvalid);
    }

    final void __commitTransaction() {
        TransactionToken transToken = null;
        if (this._transactionDepth == 1 && (transToken = this.getContext().getTransactionToken()) == null && (transToken = this.getContext().createTransactionToken()) != null) {
            this.getContext().setTransactionToken(transToken);
        }
        --this._transactionDepth;
        DomModel domModel = this.getDomModel();
        AnnotationModel annotationModel = this.getContext().getAnnotationModel();
        this.__acquireWriteLock();
        boolean success = false;
        try {
            try {
                annotationModel.acquireWriteLock();
                try {
                    try {
                        annotationModel.commitTransaction(transToken);
                        this.getSelection().commitTransaction();
                        domModel.commitTransaction();
                        this._deliverChangeEvents();
                        this._transactionLog("commit OK; isValid=", this._currValidationException == null);
                        success = true;
                    }
                    catch (Throwable innerE) {
                        this._transactionLog("commit threw exception", null, innerE);
                    }
                }
                finally {
                    annotationModel.releaseWriteLock();
                }
            }
            catch (Throwable e) {
                this._transactionLog("commit threw exception", null, e);
            }
        }
        finally {
            if (!success) {
                this.getContext().__setAbortFlag(this);
            }
            this.__releaseWriteLock();
        }
    }

    final void __rollbackTransaction() {
        if (this._transactionDepth == 0) {
            throw new IllegalStateException("No transaction open on:" + this);
        }
        --this._transactionDepth;
        this.getContext().getAnnotationModel().rollbackTransaction();
        this.getSelection().__rollbackTransaction();
        this._resetValidationStatus();
        if (this._transactionDepth == 0) {
            this._currChangeEvent = null;
        }
        DomModel dom = this.getDomModel();
        dom.rollbackTransaction();
        this._transactionLog("rollback");
    }

    final void __requestRollbackTransaction(AbstractModel requestingModel) {
        if (!$assertionsDisabled && requestingModel.getBaseModel() != this) {
            throw new AssertionError((Object)("requestingModel " + requestingModel + " doesn't belong to " + this));
        }
        this.getContext().__rollbackTransaction(requestingModel);
    }

    final void __deliverPendingXmlModelEventIfNeeded() {
        this.__acquireWriteLock();
        try {
            this._deliverChangeEvents();
        }
        finally {
            this.__releaseWriteLock();
        }
    }

    private void _transactionLog(Object msg) {
        this._transactionLog(msg, null);
    }

    private void _transactionLog(Object msg, Object msg2) {
        this._transactionLog(msg, msg2, null);
    }

    private void _transactionLog(Object msg, Object msg2, Throwable t) {
        Logger log = this.getLogger();
        if (log.isLoggable(Level.FINER)) {
            StringBuffer buf = new StringBuffer("XmlModel transaction: ");
            int i = 0;
            while (i < this._transactionDepth * 2) {
                buf.append(' ');
                ++i;
            }
            buf.append(msg);
            if (msg2 != null) {
                buf.append(msg2);
            }
            buf.append(" txnDepth=" + this._transactionDepth);
            buf.append(" curEvent=" + this._currChangeEvent);
            log.log(Level.FINER, buf.toString(), t);
        }
    }

    /*
     * Exception decompiling
     */
    private void _deliverHelloGoodbyeEvents(boolean isHello, List changeListenerList) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void _deliverModelChangeEvents(XmlModelEvent changeEvent, Iterator modelChangeListeners) {
        if (modelChangeListeners != null) {
            int nextEventIndex;
            if (this._nestedChangeEvent != null) {
                nextEventIndex = this._nestedListenerIndex + 1;
                this._nestedEvents.addFirst(this._nestedChangeEvent.clone());
                this._nestedEvents.addFirst(IntegerUtils.getInteger((int)this._nestedListenerIndex));
            } else {
                nextEventIndex = this._changeSupport.size();
            }
            XmlModelEvent currChangeEvent = changeEvent;
            int currListenerIndex = 0;
            this.__acquireWriteLock();
            try {
                while (modelChangeListeners.hasNext()) {
                    XmlModelListener currListener = (XmlModelListener)modelChangeListeners.next();
                    if (currListenerIndex == nextEventIndex) {
                        this._nestedEvents.removeFirst();
                        XmlModelEvent lastChangeEvent = (XmlModelEvent)this._nestedEvents.removeFirst();
                        lastChangeEvent.addModelEvent(currChangeEvent);
                        currChangeEvent = lastChangeEvent;
                        currChangeEvent.prepareForDelivery();
                        nextEventIndex = this._nestedEvents.size() > 0 ? (Integer)this._nestedEvents.getFirst() + 1 : this._changeSupport.size();
                    }
                    this._nestedChangeEvent = currChangeEvent;
                    this._nestedListenerIndex = currListenerIndex;
                    try {
                        if (this._pendingRemoveListeners.isEmpty() || !this._pendingRemoveListeners.contains(currListener)) {
                            currListener.modelChanged(currChangeEvent);
                        }
                    }
                    catch (ThreadDeath e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        this.getLogger().log(Level.WARNING, "Unexpected exception notifying model listener: " + currListener, t);
                    }
                    ++currListenerIndex;
                    if (this._nestedListenerIndex != -1) continue;
                    break;
                }
            }
            finally {
                this.__releaseWriteLock();
            }
        }
        this._nestedChangeEvent = null;
        this._nestedListenerIndex = -1;
        this._deliverPendingChangeEvents();
    }

    private void _deliverChangeEvents() {
        this.__verifyWriteLock();
        if (this._deliveringInvalidateEvents) {
            throw new IllegalStateException("No spawning XmlModelEvents during invalidation phase");
        }
        if (this._transactionDepth > 0) {
            return;
        }
        DomModel domModel = this.getDomModel();
        XmlModelEvent changeEvent = this._currChangeEvent;
        this._currChangeEvent = null;
        if (changeEvent == null || changeEvent.getChangeFlags() == 0) {
            this.deliverNoChangeEvent(this._changeSupport.iterator());
            return;
        }
        changeEvent.setInUndoOrRedo(this._inUndoOrRedo);
        if (changeEvent.isDomTreeChanged()) {
            PropertyChange pc = this._createMessageLogPropertyChange();
            changeEvent.addPropertyChanges(Collections.singletonMap(pc.getPropertyName(), pc));
        }
        this.getLogger().log(Level.FINER, "XmlModel deliver: {0}", changeEvent);
        if (domModel.isInTransaction()) {
            String desc = domModel.getTransactionDescription();
            if (desc == null) {
                desc = "[No transaction description provided]";
            }
            this.getLogger().log(Level.SEVERE, "Unexpected event:" + changeEvent + " with open DomModel transaction " + desc + "; depth=" + this._transactionDepth, new IllegalStateException());
            this._currChangeEvent = changeEvent;
            return;
        }
        this._deliveringInvalidateEvents = true;
        try {
            this.handleModelInvalidateEvent(changeEvent);
        }
        catch (Throwable e) {
            this.getLogger().log(Level.INFO, "Unexpected throwable", e);
        }
        this.deliverInvalidateEvent(changeEvent, this._changeSupport.iterator());
        this._deliveringInvalidateEvents = false;
        try {
            this.handleModelChangeEvent(changeEvent);
        }
        catch (Throwable e) {
            this.getLogger().log(Level.INFO, "Unexpected throwable", e);
        }
        this._deliverModelChangeEvents(changeEvent, this._changeSupport.iterator());
    }

    private void _deliverPendingChangeEvents() {
        if (!this.isDeliveringEvents()) {
            ArrayList addedListeners = null;
            ArrayList removedListeners = null;
            if (!this._pendingAddListeners.isEmpty()) {
                addedListeners = new ArrayList(this._pendingAddListeners);
                this._pendingAddListeners.clear();
                if (this._helloItrFlag) {
                    this.getLogger().log(Level.SEVERE, "Illegal updating of listener list while iteratoring", new IllegalStateException());
                }
                this._changeSupport.addAll(addedListeners);
            }
            if (!this._pendingRemoveListeners.isEmpty()) {
                removedListeners = new ArrayList(this._pendingRemoveListeners);
                this._pendingRemoveListeners.clear();
                if (this._helloItrFlag) {
                    this.getLogger().log(Level.SEVERE, "Illegal updating of listener list while iteratoring", new IllegalStateException());
                }
                this._changeSupport.removeAll(removedListeners);
            }
            if (removedListeners != null) {
                this._deliverHelloGoodbyeEvents(false, removedListeners);
            }
            if (addedListeners != null) {
                this._deliverHelloGoodbyeEvents(true, addedListeners);
            }
        }
    }

    private PropertyChange _createMessageLogPropertyChange() {
        return new PropertyChange(ISSUE_LIST, null, this.getXmlModelInternalMessageLog());
    }

    private TraversalData _rebuildTraversalData() {
        MutableTraversalData data = new MutableTraversalData();
        this._handleNode(this.getTreeTraversal(), this.getDocument(), data);
        return data;
    }

    private void _handleNode(TreeTraversal traversal, Node node, MutableTraversalData data) {
        this._handleStartNode(node, data);
        int childCount = traversal.getChildCount(node);
        int i = 0;
        while (i < childCount) {
            Node child = traversal.getChild(node, i);
            this._handleNode(traversal, child, data);
            ++i;
        }
        this._handleEndNode(node, data);
    }

    private void _handleStartNode(Node node, MutableTraversalData data) {
        for (TraversalHandler handler : this._traversalHandlers) {
            handler.handleStartNode(this, node, data);
        }
    }

    private void _handleEndNode(Node node, MutableTraversalData data) {
        for (TraversalHandler handler : this._traversalHandlers) {
            handler.handleEndNode(this, node, data);
        }
    }

    private XmlCommitException _validateDocument(boolean verboseMessage) {
        this.acquireReadLock();
        try {
            XmlCommitException xmlCommitException = this._validateSubtree(this.determineValidationRoot(), verboseMessage);
            return xmlCommitException;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private XmlCommitException _validateSubtree(Node validationRoot, boolean verboseMessage) {
        XmlCommitException problem;
        ValidationHandler oldHandler = this._validationHandler;
        if (this._isValidStatusCurrent) {
            problem = this._currValidationException;
        } else {
            this._validationHandler = new ValidationHandler(this, MessageCategory.GRAMMAR_VALIDITY);
            if (this.getDocument() == null) {
                problem = new XmlNoDocumentOnCommitException(this);
                try {
                    this._validationHandler.fatalError(new SAXParseException(this.getTranslatedString("XML_MODEL_INVALID.NO_ROOT_REASON"), null));
                }
                catch (SAXException saxe) {
                    throw new RuntimeException(saxe);
                }
            } else {
                boolean isValid = true;
                if (validationRoot != null) {
                    ModelValidationContext validationContext = new ModelValidationContext(this, this._nodeToKeyCache, this._validationHandler);
                    this.setValidationFeatures((ValidationContext)validationContext);
                    long validationTimePre = System.currentTimeMillis();
                    isValid = Validator.validateSubtree((ValidationContext)validationContext, (Node)validationRoot);
                    long validationTimePost = System.currentTimeMillis();
                    this.getLogger().log(Level.FINER, "XmlModel Validation Completed For: " + this.getContext() + " : " + (validationTimePost - validationTimePre) + "ms");
                }
                problem = isValid ? null : new XmlInvalidOnCommitException(this, this._validationHandler, verboseMessage);
            }
        }
        this._updateModelValidity(oldHandler, this._validationHandler, problem);
        return problem;
    }

    private void _updateCurrentChangeEvent(Node changeRoot, int changeFlags, Map propertyChanges, Set selectionsAdded, Set selectionsRemoved, List domChanges, NodeChangeDetails details) {
        XmlModelEvent newEvent;
        Logger log = this.getLogger();
        if (log.isLoggable(Level.FINER)) {
            LogUtils.log((Logger)log, (Level)Level.FINER, (String)"XmlModel event update: oldEvent={0} root={1} flags={2}", (Object[])new Object[]{this._currChangeEvent, changeRoot, new Integer(changeFlags)}, (Throwable)new RuntimeException("stack trace"));
        }
        if ((newEvent = new XmlModelEvent(this, changeRoot, changeFlags, propertyChanges, selectionsAdded, selectionsRemoved, domChanges, details)).isDomTreeChanged() || newEvent.isDomDocumentChanged()) {
            this._clearTraversalData();
        }
        if (this._currChangeEvent == null) {
            this._currChangeEvent = newEvent;
        } else {
            this._currChangeEvent.addModelEvent(newEvent);
        }
    }

    private void _addPropertyChangeToCurrentChangeEvent(PropertyChange newChange) {
        if (newChange == null) {
            return;
        }
        Logger log = this.getLogger();
        if (log.isLoggable(Level.FINER)) {
            LogUtils.log((Logger)log, (Level)Level.FINER, (String)"XmlModel event add propchange: oldEvent={0} newchange={1}", (Object[])new Object[]{this._currChangeEvent, newChange}, (Throwable)new RuntimeException("stack trace"));
        }
        Map<String, PropertyChange> newChangeMap = Collections.singletonMap(newChange.getPropertyName(), newChange);
        if (this._currChangeEvent != null) {
            this._currChangeEvent.addPropertyChanges(newChangeMap);
        } else {
            this._currChangeEvent = new XmlModelEvent(this);
            this._currChangeEvent.addPropertyChanges(newChangeMap);
        }
    }

    private void _deliverUndoableEditEvent(UndoableEditEvent undoEvent) {
        Iterator itor = this._undoListeners.iterator();
        while (itor.hasNext()) {
            try {
                ((UndoableEditListener)itor.next()).undoableEditHappened(undoEvent);
            }
            catch (Throwable e) {
                this.getLogger().log(Level.WARNING, "Unexpected exception when delivering UndoableEditEvent", e);
            }
        }
    }

    private void _updateModelValidity(ValidationHandler oldLog, ValidationHandler newLog, XmlCommitException newProblem) {
        boolean isValid;
        XmlCommitException oldProblem = this._currValidationException;
        this._currValidationException = newProblem;
        this._isValidStatusCurrent = true;
        this._messageLog = this._messageLog.getUpdatedLog(MessageCategory.GRAMMAR_VALIDITY, newLog.getMessages());
        boolean wasValid = oldProblem == null;
        boolean bl = isValid = newProblem == null;
        if (wasValid != isValid) {
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().finer("isValid: " + wasValid + " --> " + isValid + " newProblem=" + newProblem);
            }
            this._addPropertyChangeToCurrentChangeEvent(new PropertyChange(DOM_DOCUMENT_VALID_PROPERTY, BooleanUtils.getBoolean((boolean)wasValid), BooleanUtils.getBoolean((boolean)isValid)));
        }
        if (!oldLog.equals(newLog) && this.getLogger().isLoggable(Level.FINER)) {
            this.getLogger().finer("ErrorLog: " + oldLog + " --> " + newLog);
        }
    }

    private void _resetValidationStatus() {
        this._isValidStatusCurrent = false;
        Logger log = this.getLogger();
        if (log.isLoggable(Level.FINER)) {
            this.getLogger().log(Level.FINER, "XmlModel reset validation status", new RuntimeException("stack trace"));
        }
    }

    private void _clearTraversalData() {
        this._traversalData = null;
    }

    private void _updateParseMessages(List parseProbs) {
        ArrayList<XmlModelMessage> parseMessages = new ArrayList<XmlModelMessage>(parseProbs.size());
        Iterator itor = parseProbs.iterator();
        while (itor.hasNext()) {
            parseMessages.add(new DomParseProblemMessage(this, (DomParseProblem)itor.next()));
        }
        this._messageLog = this._messageLog.getUpdatedLog(MessageCategory.PARSING, parseMessages);
    }

    public String getInitialValue(XmlKey key, String initialValue) {
        String elementLocalName = key.getElementQName().getName();
        initialValue = initialValue.replaceAll("\\{localName\\}", elementLocalName);
        Integer i = XmlModelUtils.getUniqueInteger(this, key);
        initialValue = initialValue.replaceAll("\\{0\\}", i.toString());
        return initialValue;
    }

    private void $init$() {
        this._isValidStatusCurrent = false;
        this._currValidationException = new XmlNoDocumentOnCommitException(this);
        this._timestamp = System.currentTimeMillis();
        this._namespacesInDoc = Collections.emptySet();
        this._validationHandler = new ValidationHandler(this, MessageCategory.GRAMMAR_VALIDITY);
        this._traversalHandlers = new ArrayList();
        this._changeSupport = new ArrayList(10);
        this._pendingAddListeners = new HashSet(5);
        this._pendingRemoveListeners = new HashSet(5);
        this._undoListeners = new SafeListenerManager();
        this._namespaceChangeListeners = new SafeListenerManager();
        this._grammarComponents = new OptimisticHashMap();
        this._nodeToKeyCache = new ConcurrentHashMap(53, 0.75f, 4);
        this._grammarListener = new GrammarListener(null);
        this._nestedEvents = new LinkedList();
        this._preTransactionSelectionState = new SelectionStateRef();
        this._nestedListenerIndex = -1;
        this._transactionDepth = 0;
        this._helloItrFlag = false;
        this._lastDomChangeCount = 0;
        this._messageLog = new XmlModelMessageLog();
        this._domModel = null;
        this._inUndoOrRedo = false;
    }

    static void mav$_resetValidationStatus(XmlModel xmlModel) {
        xmlModel._resetValidationStatus();
    }

    static boolean ra$_inUndoOrRedo(XmlModel xmlModel) {
        return xmlModel._inUndoOrRedo;
    }

    static void mav$_deliverUndoableEditEvent(XmlModel xmlModel, UndoableEditEvent undoableEditEvent) {
        xmlModel._deliverUndoableEditEvent(undoableEditEvent);
    }

    static void mav$_updateParseMessages(XmlModel xmlModel, List list) {
        xmlModel._updateParseMessages(list);
    }

    static void wa$_timestamp(XmlModel xmlModel, long l) {
        xmlModel._timestamp = l;
    }

    static int ra$_lastDomChangeCount(XmlModel xmlModel) {
        return xmlModel._lastDomChangeCount;
    }

    static void wa$_lastDomChangeCount(XmlModel xmlModel, int n) {
        xmlModel._lastDomChangeCount = n;
    }

    static XmlCommitException mav$_validateSubtree(XmlModel xmlModel, Node node, boolean bl) {
        return xmlModel._validateSubtree(node, bl);
    }

    static void mav$_addPropertyChangeToCurrentChangeEvent(XmlModel xmlModel, PropertyChange propertyChange) {
        xmlModel._addPropertyChangeToCurrentChangeEvent(propertyChange);
    }

    static void mav$_updateCurrentChangeEvent(XmlModel xmlModel, Node node, int n, Map map, Set set, Set set2, List list, NodeChangeDetails nodeChangeDetails) {
        xmlModel._updateCurrentChangeEvent(node, n, map, set, set2, list, nodeChangeDetails);
    }

    static void mav$_deliverChangeEvents(XmlModel xmlModel) {
        xmlModel._deliverChangeEvents();
    }

    static OptimisticHashMap ra$_grammarComponents(XmlModel xmlModel) {
        return xmlModel._grammarComponents;
    }

    static void mav$_clearTraversalData(XmlModel xmlModel) {
        xmlModel._clearTraversalData();
    }

    static void wa$_inUndoOrRedo(XmlModel xmlModel, boolean bl) {
        xmlModel._inUndoOrRedo = bl;
    }

    static XmlCommitException mav$_validateDocument(XmlModel xmlModel, boolean bl) {
        return xmlModel._validateDocument(bl);
    }

    static SelectionStateRef ra$_preTransactionSelectionState(XmlModel xmlModel) {
        return xmlModel._preTransactionSelectionState;
    }

    static SafeListenerManager ra$_namespaceChangeListeners(XmlModel xmlModel) {
        return xmlModel._namespaceChangeListeners;
    }

    static Set ra$_namespacesInDoc(XmlModel xmlModel) {
        return xmlModel._namespacesInDoc;
    }

    static void wa$_namespacesInDoc(XmlModel xmlModel, Set set) {
        xmlModel._namespacesInDoc = set;
    }

    static XmlContext ra$_context(XmlModel xmlModel) {
        return xmlModel._context;
    }

    static GrammarResolverListener ra$_grammarListener(XmlModel xmlModel) {
        return xmlModel._grammarListener;
    }

    static XmlModelMessageLog ra$_messageLog(XmlModel xmlModel) {
        return xmlModel._messageLog;
    }

    static void wa$_messageLog(XmlModel xmlModel, XmlModelMessageLog xmlModelMessageLog) {
        xmlModel._messageLog = xmlModelMessageLog;
    }

    static PropertyChange mav$_createMessageLogPropertyChange(XmlModel xmlModel) {
        return xmlModel._createMessageLogPropertyChange();
    }

    final class 1
    extends FixedNameTransactionTask {
        private final /* synthetic */ boolean v$updateSelection;
        private final /* synthetic */ Collection v$nodes;
        private final /* synthetic */ Collection[] v$ret;
        final /* synthetic */ XmlModel this$0;

        protected void performTask(AbstractModel model) throws XmlCommitException {
            TreeTraversal traversal = this.this$0.getTreeTraversal();
            LinkedHashSet<DomPosition> laterSelectionCandidates = null;
            if (this.v$updateSelection) {
                laterSelectionCandidates = new LinkedHashSet<DomPosition>();
                for (Node node : this.v$nodes) {
                    Node prev = traversal.getPreviousSibling(node);
                    Node next = traversal.getNextSibling(node);
                    if (prev != null) {
                        laterSelectionCandidates.add(DomPositionFactory.after((Node)prev));
                    }
                    if (next == null) continue;
                    laterSelectionCandidates.add(DomPositionFactory.before((Node)next));
                }
            }
            ArrayList nodesToDelete = this.v$nodes;
            if (this.v$nodes.size() > 1) {
                ArrayList nodesSorted = new ArrayList(nodesToDelete);
                DomUtils.sortByDepth((TreeTraversal)this.this$0.getTreeTraversal(), nodesSorted, (boolean)true);
                nodesToDelete = nodesSorted;
            }
            this.v$ret[0] = this.this$0.deleteNodesImpl(nodesToDelete);
            if (laterSelectionCandidates != null) {
                for (DomPosition candidatePos : laterSelectionCandidates) {
                    if (!this.this$0.isInModelDocumentHierarchy(candidatePos)) continue;
                    this.this$0.getSelection().set(candidatePos.getTargetNode());
                    this.this$0.getSelection().setCursorLocation(candidatePos);
                }
            }
        }

        public 1(XmlModel xmlModel, String string, boolean bl, Collection collection, Collection[] collectionArray) {
            this.v$ret = collectionArray;
            this.v$nodes = collection;
            this.v$updateSelection = bl;
            this.this$0 = xmlModel;
            super(string);
        }
    }

    final class 2
    extends FixedNameTransactionTask {
        private final /* synthetic */ DomRange v$range;
        private final /* synthetic */ Collection[] v$ret;
        private final /* synthetic */ boolean v$updateSelection;
        final /* synthetic */ XmlModel this$0;

        protected void performTask(AbstractModel model) throws XmlCommitException {
            if (this.v$range.isInsideAttributeValue()) {
                this.this$0.deleteInsideAttributeValueImpl(this.v$range);
                this.v$ret[0] = Collections.EMPTY_LIST;
            } else {
                Collection nodes;
                DomPosition start = this.this$0.getTextPositionIfPossible(this.v$range.getStart());
                DomPosition end = this.this$0.getTextPositionIfPossible(this.v$range.getEnd());
                Node startNode = start.getTargetNode();
                if (start.hasTextOffset() && end.hasTextOffset() && startNode == end.getTargetNode()) {
                    int startOffset = start.getTextOffset();
                    int endOffset = end.getTextOffset();
                    int textLength = ((Text)startNode).getLength();
                    if (startOffset != 0 || endOffset != textLength) {
                        this.this$0.deleteFromTextNode((CharacterData)startNode, startOffset, endOffset - startOffset);
                        this.v$ret[0] = Collections.singleton(startNode);
                        return;
                    }
                }
                if ((nodes = this.this$0.getNodesForDeletion(this.v$range, this.v$updateSelection)) != null && !nodes.isEmpty()) {
                    this.v$ret[0] = this.this$0.deleteNodesImpl(nodes);
                }
            }
        }

        public 2(XmlModel xmlModel, String string, DomRange domRange, Collection[] collectionArray, boolean bl) {
            this.v$updateSelection = bl;
            this.v$ret = collectionArray;
            this.v$range = domRange;
            this.this$0 = xmlModel;
            super(string);
        }
    }

    final class 3
    extends FixedNameTransactionTask {
        private final /* synthetic */ DomPosition v$location;
        private final /* synthetic */ Collection v$nodes;
        private final /* synthetic */ boolean v$updateSelection;
        private final /* synthetic */ Collection[] v$ret;
        final /* synthetic */ XmlModel this$0;

        protected void performTask(AbstractModel model) throws XmlCommitException {
            Collection output;
            Document modelDoc = model.getDocument();
            if (!this.this$0.isInModelDocumentHierarchy(this.v$location)) {
                throw new IllegalArgumentException("import location target is of wrong owner doc or not in hierarchy!  location=" + this.v$location + " locationTargetDoc=" + DomUtils.getOwnerDocument((Node)this.v$location.getTargetNode()) + " modelDoc=" + modelDoc);
            }
            if (this.v$location.hasAttributeQName()) {
                boolean ok = this.this$0.insertIntoAttributeValue(this.v$nodes, this.v$location);
                output = ok ? Collections.EMPTY_LIST : null;
            } else {
                Collection rightDocNodes = DomUtils.getNodesForOwnerDoc((Document)modelDoc, (Collection)this.v$nodes);
                output = this.this$0.insertNodesImpl(this.v$location, rightDocNodes, this.v$updateSelection);
            }
            if (output == null) {
                this.cancelTask();
            } else {
                this.v$ret[0] = output;
                if (!output.isEmpty()) {
                    this.this$0.postProcessInsertedNodes(output);
                }
            }
        }

        public 3(XmlModel xmlModel, String string, DomPosition domPosition, Collection collection, boolean bl, Collection[] collectionArray) {
            this.v$ret = collectionArray;
            this.v$updateSelection = bl;
            this.v$nodes = collection;
            this.v$location = domPosition;
            this.this$0 = xmlModel;
            super(string);
        }
    }

    final class 4
    extends NonDomMutationTransactionTask {
        private final /* synthetic */ MessageCategory v$category;
        private final /* synthetic */ List v$messages;
        final /* synthetic */ XmlModel this$0;

        protected void performTask(AbstractModel model) {
            XmlModel.wa$_messageLog(this.this$0, XmlModel.ra$_messageLog(this.this$0).getUpdatedLog(this.v$category, this.v$messages));
            XmlModel.mav$_addPropertyChangeToCurrentChangeEvent(this.this$0, XmlModel.mav$_createMessageLogPropertyChange(this.this$0));
        }

        public 4(XmlModel xmlModel, MessageCategory messageCategory, List list) {
            this.v$messages = list;
            this.v$category = messageCategory;
            this.this$0 = xmlModel;
        }
    }

    final class 5
    extends NonDomMutationTransactionTask {
        private final /* synthetic */ IssueList v$issueList;
        final /* synthetic */ XmlModel this$0;

        protected void performTask(AbstractModel model) {
            XmlModel.mav$_addPropertyChangeToCurrentChangeEvent(this.this$0, new PropertyChange(XmlModel.ISSUE_LIST, null, this.v$issueList));
        }

        public 5(XmlModel xmlModel, IssueList issueList) {
            this.v$issueList = issueList;
            this.this$0 = xmlModel;
        }
    }

    final class 6
    extends XmlContextLifecycleListener {
        public void preContextDisposal(XmlContext context) {
            XmlModel.ra$_context(XmlModel.this).getGrammarResolver().removeGrammarResolverListener(XmlModel.ra$_grammarListener(XmlModel.this));
        }
    }

    private class DomListener
    implements DomModelListener,
    PropertyChangeListener,
    SetChangeListener,
    UndoableEditListener,
    DomMutationListener {
        private transient boolean _openBufferSelectionTransaction;

        public void setChanged(SetChangeEvent event) {
            XmlModel.mav$_updateCurrentChangeEvent(XmlModel.this, null, 0, null, event.getAddedObjects(), event.getRemovedObjects(), null, null);
        }

        public void propertyChange(PropertyChangeEvent event) {
            XmlModel.mav$_addPropertyChangeToCurrentChangeEvent(XmlModel.this, new PropertyChange(event));
        }

        public void modelChanged(DomModelEvent changeEvent) {
            PropertyChange domProblemsChange;
            boolean eventHadDomProblems;
            if (!XmlModel.this.isFullyInstantiated()) {
                return;
            }
            if (changeEvent.isTextBufferModified() && !this._openBufferSelectionTransaction) {
                XmlModel.this.getSelection().__startTransaction();
                this._openBufferSelectionTransaction = true;
            }
            boolean bl = eventHadDomProblems = (domProblemsChange = changeEvent.getPropertyChange("parseProblems")) != null;
            if (eventHadDomProblems) {
                List parseProbs = (List)domProblemsChange.getNewValue();
                XmlModel.mav$_updateParseMessages(XmlModel.this, parseProbs);
                Logger log = XmlModel.this.getLogger();
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "XmlModel WFCheck change: {0}", domProblemsChange);
                }
            }
            DomModel domModel = XmlModel.this.getDomModel();
            XmlModel.wa$_timestamp(XmlModel.this, System.currentTimeMillis());
            int oldCount = XmlModel.ra$_lastDomChangeCount(XmlModel.this);
            XmlModel.wa$_lastDomChangeCount(XmlModel.this, domModel.getDocChangeCount());
            PropertyChange documentChange = changeEvent.getPropertyChange("documentChanged");
            if (documentChange != null) {
                Document newDocument = (Document)documentChange.getNewValue();
                XmlModel.mav$_resetValidationStatus(XmlModel.this);
                XmlModel.mav$_validateSubtree(XmlModel.this, newDocument, true);
            }
            if (changeEvent.isDomTreeChanged()) {
                XmlModel.mav$_addPropertyChangeToCurrentChangeEvent(XmlModel.this, new PropertyChange(XmlModel.DOC_CHANGE_COUNT_PROPERTY, IntegerUtils.getInteger((int)oldCount), IntegerUtils.getInteger((int)XmlModel.ra$_lastDomChangeCount(XmlModel.this))));
            }
            XmlModel.mav$_updateCurrentChangeEvent(XmlModel.this, changeEvent.getChangeRoot(), changeEvent.getChangeFlags(), null, null, null, changeEvent.getDomChanges(), changeEvent.getNodeChangeDetails());
            XmlModel.mav$_addPropertyChangeToCurrentChangeEvent(XmlModel.this, changeEvent.getDocumentPropertyChange());
            if (changeEvent.getReadOnlyPropertyChange() != null) {
                XmlModel.mav$_addPropertyChangeToCurrentChangeEvent(XmlModel.this, new PropertyChange("readOnly", null, XmlModel.this.isReadOnly()));
            }
            XmlModel.this.__acquireWriteLock();
            try {
                if (!domModel.isInTransaction()) {
                    if (this._openBufferSelectionTransaction && !changeEvent.isTextBufferModified()) {
                        XmlModel.this.getSelection().commitTransaction();
                        this._openBufferSelectionTransaction = false;
                    }
                    XmlModel.mav$_deliverChangeEvents(XmlModel.this);
                }
            }
            finally {
                XmlModel.this.__releaseWriteLock();
            }
        }

        public void undoableEditHappened(UndoableEditEvent domUndoableEditEvent) {
            if (XmlModel.ra$_inUndoOrRedo(XmlModel.this)) {
                LogUtils.log((Logger)XmlModel.this.getLogger(), (Level)Level.SEVERE, (String)"Got undoable edit while in undo/redo! This can't work, see bug 3981855. Dropping second edit, but undo stack is in inconsistent state.\nnew edit={0}", (Object)domUndoableEditEvent.getEdit().getPresentationName(), (Throwable)new Throwable("stack trace where edit was sent from"));
                return;
            }
            UndoableEditEvent modelUndoableEditEvent = new UndoableEditEvent(XmlModel.this, new DomUndoableEditWrapper(XmlModel.this, domUndoableEditEvent.getEdit()));
            XmlModel.mav$_deliverUndoableEditEvent(XmlModel.this, modelUndoableEditEvent);
        }

        public void domMutated(DomModel domModel, DomChange change, MutationEvent mEvent) {
            XmlModel.mav$_resetValidationStatus(XmlModel.this);
        }

        private DomListener() {
        }

        DomListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class GrammarListener
    implements GrammarResolverListener {
        public void grammarResolverChanged(GrammarResolverEvent e) {
            XmlModel.ra$_grammarComponents(XmlModel.this).clear();
            XmlModel.mav$_clearTraversalData(XmlModel.this);
            if (!XmlModel.this.isInTransaction()) {
                XmlModel.this.getDomModel().forceReparse();
            }
        }

        private GrammarListener() {
        }

        GrammarListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class MetadataBasedPrefixLookup
    implements DefaultPrefixLookup {
        private XmlMetadataResolver _resolver;

        public MetadataBasedPrefixLookup(XmlMetadataResolver resolver) {
            this._resolver = resolver;
        }

        public String getDefaultPrefix(String namespace) {
            XmlKey nsKey = ImmutableXmlKey.createNamespaceKey((String)namespace);
            if (this._resolver.isPreferNamespaceDeclarations(nsKey)) {
                return null;
            }
            return this._resolver.getPreferredPrefix(nsKey);
        }
    }

    private static class DomUndoableEditWrapper
    implements UndoableEdit,
    DomModelHolder {
        private final UndoableEdit _domEdit;
        private final SelectionStateRef _selectionStatePostUndo;
        private SelectionStateRef _selectionStatePostRedo;
        private final boolean _isSourceModel;

        public DomUndoableEditWrapper(XmlModel model, UndoableEdit domEdit) {
            if (domEdit == null) {
                throw new IllegalArgumentException("DOM UndoableEdit required");
            }
            this._domEdit = domEdit;
            this._selectionStatePostUndo = XmlModel.ra$_preTransactionSelectionState(model);
            this._selectionStatePostRedo = new SelectionStateRef(model.getSelection());
            this._isSourceModel = model == model.getContext().getSourceModel();
        }

        public void undo() throws CannotUndoException {
            XmlModel model = this._getModel();
            if (model == null) {
                this._domEdit.undo();
            } else {
                model.__acquireWriteLock();
                try {
                    XmlModel.wa$_inUndoOrRedo(model, true);
                    Selection modelSelection = model.getSelection();
                    modelSelection.__startTransaction();
                    this._domEdit.undo();
                    this._selectionStatePostUndo.restore(modelSelection);
                    modelSelection.commitTransaction();
                    XmlModel.mav$_validateDocument(model, true);
                    XmlModel.mav$_deliverChangeEvents(model);
                }
                finally {
                    XmlModel.wa$_inUndoOrRedo(model, false);
                    model.__releaseWriteLock();
                }
            }
        }

        public boolean canUndo() {
            return this._domEdit.canUndo();
        }

        public void redo() throws CannotRedoException {
            XmlModel model = this._getModel();
            if (model == null) {
                this._domEdit.redo();
            } else {
                model.__acquireWriteLock();
                try {
                    XmlModel.wa$_inUndoOrRedo(model, true);
                    Selection modelSelection = model.getSelection();
                    modelSelection.__startTransaction();
                    this._domEdit.redo();
                    this._selectionStatePostRedo.restore(modelSelection);
                    modelSelection.commitTransaction();
                    XmlModel.mav$_validateDocument(model, true);
                    XmlModel.mav$_deliverChangeEvents(model);
                }
                finally {
                    XmlModel.wa$_inUndoOrRedo(model, false);
                    model.__releaseWriteLock();
                }
            }
        }

        public boolean canRedo() {
            return this._domEdit.canRedo();
        }

        public void die() {
            this._domEdit.die();
        }

        public boolean addEdit(UndoableEdit anEdit) {
            if (anEdit instanceof DomUndoableEditWrapper) {
                DomUndoableEditWrapper other = (DomUndoableEditWrapper)anEdit;
                if (this._domEdit.addEdit(other._domEdit)) {
                    this._selectionStatePostRedo = other._selectionStatePostRedo;
                    return true;
                }
            }
            return false;
        }

        public boolean replaceEdit(UndoableEdit anEdit) {
            return false;
        }

        public boolean isSignificant() {
            return this._domEdit.isSignificant();
        }

        public String getPresentationName() {
            return this._domEdit.getPresentationName();
        }

        public String getUndoPresentationName() {
            return this._domEdit.getUndoPresentationName();
        }

        public String getRedoPresentationName() {
            return this._domEdit.getRedoPresentationName();
        }

        public String toString() {
            return "DomEditWrapper:\n  " + this._domEdit.toString() + "\n  model=" + this._getModel();
        }

        public DomModel getDomModel() {
            if (this._domEdit instanceof DomModelHolder) {
                return ((DomModelHolder)((Object)this._domEdit)).getDomModel();
            }
            return null;
        }

        private XmlModel _getModel() {
            DomModel dom = this.getDomModel();
            if (dom != null && dom.getContext() instanceof XmlContext) {
                XmlContext context = (XmlContext)dom.getContext();
                if (this._isSourceModel) {
                    return context.getSourceModel();
                }
                return context.getModel();
            }
            return null;
        }
    }

    private class NamespaceSetChecker
    extends XmlModelAdapter {
        public void modelChanged(XmlModelEvent event) {
            if (event.matchesFlags(2) || event.getDomDocumentPropertyChange() != null || XmlModel.ra$_namespacesInDoc(XmlModel.this) == Collections.EMPTY_SET) {
                this._scanEntireDocument();
            } else if (event.matchesFlags(1)) {
                Node root = event.getChangeRoot();
                if (root != null) {
                    Set namespacesInSubtree = DomUtils.getNamespacesInSubtree((Node)root);
                    namespacesInSubtree.removeAll(XmlModel.ra$_namespacesInDoc(XmlModel.this));
                    XmlModel.ra$_namespacesInDoc(XmlModel.this).addAll(namespacesInSubtree);
                    this._fire(namespacesInSubtree, Collections.EMPTY_SET);
                } else {
                    this._scanEntireDocument();
                }
            }
        }

        public void listenerAttached(XmlModelEvent event) {
            this._scanEntireDocument();
        }

        private void _scanEntireDocument() {
            Document doc = XmlModel.this.getDocument();
            if (doc != null) {
                Set oldSet = XmlModel.ra$_namespacesInDoc(XmlModel.this);
                XmlModel.wa$_namespacesInDoc(XmlModel.this, DomUtils.getNamespacesInSubtree((Node)doc));
                HashSet added = new HashSet();
                HashSet removed = new HashSet();
                CollectionUtils.computeAddRemoveSets(oldSet, XmlModel.ra$_namespacesInDoc(XmlModel.this), added, removed);
                this._fire(added, removed);
            }
        }

        private void _fire(Set added, Set removed) {
            Iterator itor;
            Logger log = XmlModel.this.getLogger();
            if (added.isEmpty() && removed.isEmpty()) {
                return;
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "NamespaceSetChange: added={0} removed={1}", new Object[]{added, removed});
            }
            if (!(itor = XmlModel.ra$_namespaceChangeListeners(XmlModel.this).iterator()).hasNext()) {
                return;
            }
            SetChangeEvent event = new SetChangeEvent(XmlModel.this, added, removed);
            while (itor.hasNext()) {
                SetChangeListener listener = (SetChangeListener)itor.next();
                try {
                    listener.setChanged(event);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    if (!log.isLoggable(Level.SEVERE)) continue;
                    LogRecord record = new LogRecord(Level.SEVERE, "Namespace change listener {0} threw exception during  event delivery. model={1} added={2} removed={3}");
                    record.setThrown(t);
                    record.setParameters(new Object[]{listener, XmlModel.this, added, removed});
                    log.log(record);
                }
            }
        }

        private NamespaceSetChecker() {
        }

        NamespaceSetChecker(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static class SelectionStateRef {
        private final DomPositionRef _cursor;
        private final NodeRef[] _selectedNodeRefs;
        private final DomPositionRef _rangeStart;
        private final DomPositionRef _rangeEnd;

        public SelectionStateRef() {
            this._cursor = null;
            this._selectedNodeRefs = null;
            this._rangeStart = null;
            this._rangeEnd = null;
        }

        public SelectionStateRef(Selection sel) {
            this._cursor = DomPositionRefFactory.get(sel.getCursorLocation());
            if (sel.hasRangeSelection()) {
                this._selectedNodeRefs = null;
                DomRange range = sel.getRangeSelection();
                this._rangeStart = DomPositionRefFactory.get(range.getStart());
                this._rangeEnd = DomPositionRefFactory.get(range.getEnd());
            } else {
                this._selectedNodeRefs = new NodeRef[sel.size()];
                int i = 0;
                Iterator<Node> itor = sel.getSelectedNodes();
                while (itor.hasNext()) {
                    Node node = itor.next();
                    this._selectedNodeRefs[i] = NodeRefFactory.getNodeRef((Node)node);
                    ++i;
                }
                this._rangeStart = null;
                this._rangeEnd = null;
            }
        }

        public void restore(Selection sel) {
            Document doc = sel.getSelectionDocument();
            if (this._cursor != null) {
                sel.setCursorLocation(this._cursor.getCorrespondingPosition(doc));
            }
            if (this._selectedNodeRefs != null && this._selectedNodeRefs.length > 0) {
                ArrayList<Node> nodes = new ArrayList<Node>(this._selectedNodeRefs.length);
                int i = 0;
                while (i < this._selectedNodeRefs.length) {
                    nodes.add(this._selectedNodeRefs[i].getCorrespondingNode(doc));
                    ++i;
                }
                sel.set(nodes);
            }
            if (this._rangeStart != null && this._rangeEnd != null) {
                DomRange range = sel.createDomRange(this._rangeStart.getCorrespondingPosition(doc), this._rangeEnd.getCorrespondingPosition(doc));
                sel.setRangeSelection(range);
            }
        }
    }

    private class XmlModelProspectiveValidationContext
    extends ProspectiveValidationContext {
        public XmlKey getNodeXmlKey(Node node) {
            return XmlModel.this.getNodeXmlKey(node);
        }

        public GrammarComponent getGrammarComponent(XmlKey xmlKey) {
            return XmlModel.this.getGrammarComponent(xmlKey);
        }

        public Comparator getInsertionComparator(Node node) {
            return XmlModel.this.getXmlMetadataResolver().getInsertionComparator(node);
        }

        public GrammarResolver getGrammarResolver() {
            return XmlModel.this.getContext().getGrammarResolver();
        }
    }
}

