/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bali.xml.dom.NodeChangeDetails;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.share.PropertyChange;
import oracle.bali.xml.util.CollectionUtils;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlModelEvent
extends EventObject
implements Cloneable {
    public static final int NODES_ADDED_FLAG = 1;
    public static final int NODES_REMOVED_FLAG = 2;
    public static final int NODES_MOVED_FLAG = 4;
    public static final int ATTRIBUTES_CHANGED_FLAG = 8;
    public static final int CHARACTERS_CHANGED_FLAG = 16;
    public static final int PROPERTIES_CHANGED_FLAG = 32;
    public static final int SELECTIONS_ADDED_FLAG = 64;
    public static final int SELECTIONS_REMOVED_FLAG = 128;
    public static final int DOM_STRUCTURE_FLAGS = 7;
    public static final int DOM_TREE_FLAGS = 31;
    public static final int SELECTION_FLAGS = 192;
    private final AbstractModel _model;
    private Node _changeRoot;
    private int _changeFlags;
    private Map<String, PropertyChange> _propertyChanges;
    private Set<Node> _selectionsAdded;
    private Set<Node> _selectionsRemoved;
    private boolean _immutable;
    private List<DomChange> _domChanges;
    private NodeChangeDetails _details;
    private boolean _isInUndoOrRedo;

    public XmlModelEvent(AbstractModel model) {
        this(model, null, 0, null, null, null, null, null);
    }

    public XmlModelEvent(AbstractModel model, Node changeRoot, int changeFlags, Map<String, PropertyChange> propertyChanges, Set<Node> selectionsAdded, Set<Node> selectionsRemoved, List<DomChange> domChanges, NodeChangeDetails details) {
        super(model);
        this.$init$();
        if (model == null) {
            throw new IllegalArgumentException("model required");
        }
        this._model = model;
        this._details = details;
        this.setChangeRoot(changeRoot, changeFlags);
        this._setPropertyChanges(propertyChanges);
        this.setSelectionsAdded(selectionsAdded);
        this.setSelectionsRemoved(selectionsRemoved);
        this.addDomChanges(domChanges);
    }

    public AbstractModel getModel() {
        return this._model;
    }

    public void setChangeRoot(Node changeRoot, int domChangeFlags) {
        this._checkImmutable();
        int updatedFlags = domChangeFlags & 0x1F;
        if (changeRoot != null) {
            if (updatedFlags == 0) {
                throw new IllegalArgumentException("Flags must be specified when updating root");
            }
            this._changeFlags |= updatedFlags;
        } else {
            this._changeFlags |= updatedFlags;
            this._changeFlags &= 0xFFFFFFFA;
        }
        this._changeRoot = changeRoot;
    }

    public Node getChangeRoot() {
        return this._changeRoot;
    }

    public int getChangeFlags() {
        return this._changeFlags;
    }

    public final boolean matchesFlags(int mask) {
        return (this.getChangeFlags() & mask) != 0;
    }

    public final boolean isInUndoOrRedo() {
        return this._isInUndoOrRedo;
    }

    public final void setInUndoOrRedo(boolean value) {
        this._isInUndoOrRedo = value;
    }

    public final boolean isSelectionChanged() {
        return this.matchesFlags(192);
    }

    public final boolean isSelectionOrRangeSelectionChanged() {
        return this.isSelectionChanged() || this.getRangeSelectionPropertyChange() != null;
    }

    public final boolean isDomAttributeChanged() {
        return this.matchesFlags(8);
    }

    public final boolean isDomStructureChanged() {
        return this.matchesFlags(7);
    }

    public final boolean isDomTreeChanged() {
        return this.matchesFlags(31);
    }

    public final boolean isPropertyChanged() {
        return this.matchesFlags(32);
    }

    public void addPropertyChanges(Map<String, PropertyChange> propertyChanges) {
        Map<String, PropertyChange> mergedMap = PropertyChange.mergePropertyChangeMaps(this._propertyChanges, propertyChanges, this._propertyChanges instanceof HashMap ? this._propertyChanges : null);
        this._setPropertyChanges(mergedMap);
    }

    public void removePropertyChange(String changeName) {
        if (changeName == null) {
            return;
        }
        this._checkImmutable();
        if (this._propertyChanges.containsKey(changeName)) {
            if (CollectionUtils.isUnmodifiableMap(this._propertyChanges, 2)) {
                this._propertyChanges = new HashMap<String, PropertyChange>(this._propertyChanges);
            }
            try {
                this._propertyChanges.remove(changeName);
            }
            catch (UnsupportedOperationException e) {
                this._propertyChanges = new HashMap<String, PropertyChange>(this._propertyChanges);
                this._propertyChanges.remove(changeName);
            }
        }
    }

    public Map getPropertyChanges() {
        return this._propertyChanges;
    }

    public final PropertyChange getPropertyChange(String propertyName) {
        return (PropertyChange)this.getPropertyChanges().get(propertyName);
    }

    public final boolean containsPropertyChange(String propertyName) {
        return this.getPropertyChanges().containsKey(propertyName);
    }

    public final PropertyChange getDomDocumentPropertyChange() {
        return this.getPropertyChange("documentChanged");
    }

    public final boolean isDomDocumentChanged() {
        return this.getDomDocumentPropertyChange() != null;
    }

    public final PropertyChange getDropLocationPropertyChange() {
        return this.getPropertyChange("dropLocation");
    }

    public final PropertyChange getCursorLocationPropertyChange() {
        return this.getPropertyChange("cursorLocation");
    }

    public final PropertyChange getRangeSelectionPropertyChange() {
        return this.getPropertyChange("rangeSelection");
    }

    public final PropertyChange getDocChangeCountPropertyChange() {
        return this.getPropertyChange("docChangeCount");
    }

    public final PropertyChange getReadOnlyPropertyChange() {
        return this.getPropertyChange("readOnly");
    }

    public final PropertyChange getDomDocumentValidPropertyChange() {
        return this.getPropertyChange("documentValid");
    }

    public final PropertyChange getIssueListPropertyChange() {
        return this.getPropertyChange("XmlModelIssueList");
    }

    public final NodeChangeDetails getNodeChangeDetails() {
        return this._details;
    }

    public final void addNodeChangeDetails(NodeChangeDetails details) {
        if (this._details != NodeChangeDetails.NO_DETAILS_AVAILABLE) {
            this._details = details == NodeChangeDetails.NO_DETAILS_AVAILABLE ? NodeChangeDetails.NO_DETAILS_AVAILABLE : (this._details == null ? details : this._details.addDetails(details));
        }
    }

    public List getBaseModelDomChanges() {
        return this._domChanges;
    }

    public void addDomChanges(List<DomChange> moreChanges) {
        if (moreChanges == null || moreChanges.isEmpty()) {
            return;
        }
        boolean needNewList = CollectionUtils.isUnmodifiableList(this._domChanges, 0);
        if (needNewList) {
            List<DomChange> oldSaved = this._domChanges;
            this._domChanges = new ArrayList<DomChange>(oldSaved.size() + moreChanges.size());
            this._domChanges.addAll(oldSaved);
        }
        this._domChanges.addAll(moreChanges);
    }

    public final boolean isSelectionCleared() {
        PropertyChange selectionCleared = this.getPropertyChange("selectionCleared");
        return selectionCleared != null && selectionCleared.getNewBooleanValue();
    }

    public void setSelectionsAdded(Set<Node> selectionAdded) {
        this._checkImmutable();
        if (selectionAdded != null && selectionAdded.size() > 0) {
            this._selectionsAdded = selectionAdded;
            this._changeFlags |= 0x40;
        } else {
            this._selectionsAdded = Collections.emptySet();
            this._changeFlags &= 0xFFFFFFBF;
        }
    }

    public Set<Node> getSelectionsAdded() {
        return this._selectionsAdded;
    }

    public void setSelectionsRemoved(Set<Node> selectionsRemoved) {
        this._checkImmutable();
        if (selectionsRemoved != null && selectionsRemoved.size() > 0) {
            this._selectionsRemoved = selectionsRemoved;
            this._changeFlags |= 0x80;
        } else {
            this._selectionsRemoved = Collections.EMPTY_SET;
            this._changeFlags &= 0xFFFFFF7F;
        }
    }

    public Set<Node> getSelectionsRemoved() {
        return this._selectionsRemoved;
    }

    public void addModelEvent(XmlModelEvent addedEvent) {
        boolean selectionsChecked;
        if (addedEvent == null) {
            return;
        }
        this._checkImmutable();
        this._changeRoot = DomUtils.lowestCommonAncestor((Node)this._changeRoot, (Node)addedEvent._changeRoot);
        this._changeFlags = this._changeFlags & 0x1F | addedEvent._changeFlags & 0x1F;
        this.addPropertyChanges(addedEvent._propertyChanges);
        boolean hadSelectionsAdded = this._selectionsAdded.isEmpty() ^ true;
        if (!addedEvent._selectionsAdded.isEmpty()) {
            if (CollectionUtils.isUnmodifiableSet(this._selectionsRemoved, 2)) {
                this._selectionsRemoved = new HashSet<Node>(this._selectionsRemoved);
            }
            if (CollectionUtils.isUnmodifiableSet(this._selectionsAdded, 2)) {
                this._selectionsAdded = new HashSet<Node>(this._selectionsAdded);
            }
            this._selectionsAdded = CollectionUtils.mergeAddRemoveSets(this._selectionsAdded, addedEvent._selectionsAdded, this._selectionsRemoved);
            selectionsChecked = true;
        } else {
            selectionsChecked = false;
        }
        if (!addedEvent._selectionsRemoved.isEmpty()) {
            Set<Node> selectionsAdded;
            Set<Node> set = selectionsAdded = hadSelectionsAdded ? this._selectionsAdded : null;
            if (!selectionsChecked) {
                if (CollectionUtils.isUnmodifiableSet(this._selectionsRemoved, 2)) {
                    this._selectionsRemoved = new HashSet<Node>(this._selectionsRemoved);
                }
                if (selectionsAdded != null && CollectionUtils.isUnmodifiableSet(selectionsAdded, 2)) {
                    selectionsAdded = new HashSet<Node>(selectionsAdded);
                }
            }
            this._selectionsRemoved = CollectionUtils.mergeAddRemoveSets(this._selectionsRemoved, addedEvent._selectionsRemoved, selectionsAdded);
        }
        this.addDomChanges(addedEvent.getBaseModelDomChanges());
        this.addNodeChangeDetails(addedEvent.getNodeChangeDetails());
        this._updateChangeFlags();
        this._isInUndoOrRedo |= addedEvent.isInUndoOrRedo();
    }

    public XmlModelEvent getMutableEvent() {
        if (this._immutable) {
            return (XmlModelEvent)this.clone();
        }
        return this;
    }

    public void prepareForDelivery() {
        if (!this._immutable) {
            this._immutable = true;
            this._updateChangeFlags();
            this._propertyChanges = CollectionUtils.createUnmodifiableMap(this._propertyChanges);
            this._selectionsAdded = CollectionUtils.createUnmodifiableSet(this._selectionsAdded);
            this._selectionsRemoved = CollectionUtils.createUnmodifiableSet(this._selectionsRemoved);
            this._domChanges = CollectionUtils.createUnmodifiableList(this._domChanges);
        }
    }

    public Object clone() {
        XmlModelEvent newEvent = null;
        try {
            newEvent = (XmlModelEvent)super.clone();
            newEvent._propertyChanges = new HashMap<String, PropertyChange>(this._propertyChanges);
            newEvent._selectionsAdded = new HashSet<Node>(this._selectionsAdded);
            newEvent._selectionsRemoved = new HashSet<Node>(this._selectionsRemoved);
            if (newEvent._details != null) {
                newEvent._details = newEvent._details.getCopy();
            }
            newEvent._immutable = false;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return newEvent;
    }

    @Override
    public String toString() {
        int changeFlags;
        String outString = super.toString();
        if (this._changeRoot != null) {
            outString = outString + "root: " + this._changeRoot;
        }
        if ((changeFlags = this._changeFlags) != 0) {
            outString = outString + "Changes:[";
            if ((changeFlags & 1) != 0) {
                outString = outString + "Nodes+,";
            }
            if ((changeFlags & 2) != 0) {
                outString = outString + "Nodes-,";
            }
            if ((changeFlags & 4) != 0) {
                outString = outString + "Nodes Moved,";
            }
            if ((changeFlags & 8) != 0) {
                outString = outString + "Attr+-,";
            }
            if ((changeFlags & 0x10) != 0) {
                outString = outString + "Chars+-,";
            }
            if ((changeFlags & 0x40) != 0) {
                outString = outString + "Sel+,";
            }
            if ((changeFlags & 0x80) != 0) {
                outString = outString + "Sel-,";
            }
            if ((changeFlags & 0x20) != 0) {
                outString = outString + "Prop changed,";
            }
            outString = outString + "]";
        }
        if (this._isInUndoOrRedo) {
            outString = outString + " (UNDO/REDO)";
        }
        if (!this._selectionsAdded.isEmpty()) {
            outString = outString + "\nselections added: " + this._selectionsAdded;
        }
        if (!this._selectionsRemoved.isEmpty()) {
            outString = outString + "\nselections removed: " + this._selectionsRemoved;
        }
        if (!this._propertyChanges.isEmpty()) {
            outString = outString + "\nproperty changes: " + this._propertyChanges.values();
        }
        if (!this._domChanges.isEmpty()) {
            outString = outString + "\nDOM changes: " + this._domChanges;
        }
        if (this._details != null) {
            outString = outString + "\nNodeChangeDetails: " + this._details;
        }
        return outString;
    }

    private void _setPropertyChanges(Map<String, PropertyChange> propertyChanges) {
        this._checkImmutable();
        this._propertyChanges = propertyChanges != null && propertyChanges.size() > 0 ? propertyChanges : Collections.emptyMap();
        this._updatePropertyChangeFlags();
    }

    private void _checkImmutable() {
        if (this._immutable) {
            throw new IllegalStateException("No mutating event once delivered");
        }
    }

    private void _updateChangeFlags() {
        int changeFlags = this._changeFlags;
        if (this._changeRoot == null) {
            changeFlags &= 0xFFFFFFFA;
        }
        changeFlags = this._selectionsAdded.size() > 0 ? (changeFlags |= 0x40) : (changeFlags &= 0xFFFFFFBF);
        changeFlags = this._selectionsRemoved.size() > 0 ? (changeFlags |= 0x80) : (changeFlags &= 0xFFFFFF7F);
        this._changeFlags = changeFlags;
        this._updatePropertyChangeFlags();
    }

    private void _updatePropertyChangeFlags() {
        this._changeFlags = this._propertyChanges == null || this._propertyChanges.isEmpty() ? (this._changeFlags &= 0xFFFFFFDF) : (this._changeFlags |= 0x20);
    }

    private void $init$() {
        this._domChanges = Collections.emptyList();
        this._isInUndoOrRedo = false;
    }
}

