/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model;

public class XmlUsage {
    public static final XmlUsage EXPLORER = new XmlUsage("explorer");
    public static final XmlUsage PROPERTY_INSPECTOR = new XmlUsage("Property inspector");
    public static final XmlUsage STATUS_BAR = new XmlUsage("Status bar");
    public static final XmlUsage COMPONENT_PALETTE = new XmlUsage("Component palette");
    public static final XmlUsage LAYOUT_EDITOR = new XmlUsage("Layout editor");
    public static final XmlUsage NODE_CREATOR = new XmlUsage("Node Creator");
    public static final XmlUsage NODE_CUSTOMIZER = new XmlUsage("Node Customizer");
    public static final XmlUsage DATABINDING_PROPERTY_EDITOR = new XmlUsage("Databinding PropertyEditor");
    public static final XmlUsage XML_CODE_EDITOR = new XmlUsage("XML Code Editor", true);
    public static final XmlUsage XML_CODE_EXPLORER = new XmlUsage("explorer", true);
    public static final XmlUsage XML_CODE_PROPERTY_INSPECTOR = new XmlUsage("Property inspector", true);
    public static final XmlUsage CONTEXTUAL_ACTIONS = new XmlUsage("Contextual Actions");
    public static final XmlUsage GLOBAL_NODE_TYPE = new XmlUsage("Global Node Type");
    public static final XmlUsage DOM_NODE_COMPONENT = new XmlUsage("Dom Node Component");
    private final String _description;
    private final boolean _useSourceModel;

    public XmlUsage(String description) {
        this(description, false);
    }

    public XmlUsage(String description, boolean useSourceModel) {
        this._description = description.intern();
        this._useSourceModel = useSourceModel;
    }

    public boolean useSourceModel() {
        return this._useSourceModel;
    }

    public String toString() {
        String debugString = "Usage:" + this._description + " model:";
        debugString = debugString + (this._useSourceModel ? "souce" : "flattened");
        return debugString;
    }

    public int hashCode() {
        int hashCode = this.getClass().hashCode() ^ this._description.hashCode();
        if (this._useSourceModel) {
            ++hashCode;
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (o == this || o.getClass() == this.getClass()) {
            XmlUsage otherUsage = (XmlUsage)o;
            return this._useSourceModel == otherUsage._useSourceModel && this._description.equals(otherUsage._description);
        }
        return false;
    }
}

