/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model;

import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.Action;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversalTreeWalker;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.MetadataEvaluator;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.PrecommitOptions;
import oracle.bali.xml.model.PrecommitResults;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.TransactionOptions;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.event.XmlModelAdapter;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.share.PropertyChange;
import oracle.bali.xml.util.XmlNavigationActions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.TreeWalker;

public abstract class XmlView
extends AbstractModel {
    static final /* synthetic */ boolean $assertionsDisabled;
    private XmlMetadataResolver _resolver;
    private XmlNavigationActions _navActions;
    private final ArrayList _changeSupport;
    private final HashSet _pendingAddListeners;
    private final HashSet _pendingRemoveListeners;
    private int _eventDeliveryDepth;
    private List _contextActions;
    private XmlModel _model;
    private boolean _instantiated;
    private transient Document _document;
    private transient LockAssertingTreeTraversal _currentViewTraversal;
    private transient boolean _hasPendingSelectionEvent;
    private transient XmlModelEvent _transformedEvent;
    private transient XmlModelEvent _eventToTransform;
    private transient XmlModelEvent _invalidateBufferingEvent;
    private transient XmlModelEvent _changeBufferingEvent;
    private transient boolean _wasValidBeforeOuterTxn;

    public XmlView() {
        this.$init$();
        this.createSelection();
    }

    public final boolean isFullyInstantiated() {
        return this._instantiated;
    }

    public final XmlModel getBaseModel() {
        return this._model;
    }

    public final DomModel getDomModel() {
        return this.getBaseModel().getDomModel();
    }

    public final XmlContext getContext() {
        return this.getBaseModel().getContext();
    }

    public Object getService(Object selector) {
        return this.getBaseModel().getService(selector);
    }

    public Document getDocument() {
        this.__verifyLock();
        return this._document;
    }

    public final void startTransaction(TransactionOptions transOptions) {
        this.getBaseModel().__requestStartTransaction(this, transOptions);
        this.getSelection().__startTransaction();
        if (this._validatesButDoesntRequireValidModel() && this.getBaseModel().__getTransactionDepth() == 1) {
            this._wasValidBeforeOuterTxn = this.getBaseModel().isDocumentValid();
        }
    }

    public final boolean commitTransaction() throws XmlCommitException {
        boolean shouldThrow = this.requiresValidModel() ? true : (this.validatesTransactions() ? (this.getBaseModel().__getTransactionDepth() == 1 ? this._wasValidBeforeOuterTxn : true) : false);
        XmlModel baseModel = this.getBaseModel();
        PrecommitOptions options = PrecommitOptions.getInstance(shouldThrow);
        PrecommitResults precommitResults = baseModel.__requestPrecommitTransaction(this, options);
        if (!precommitResults.precommitSucceeded()) {
            XmlCommitException fatalException = precommitResults.getFatalException();
            if (fatalException.isValidationFailure()) {
                String desc = this.getDomModel().getTransactionDescription();
                String errorFormat = this.getTranslatedString("XML_MODEL_INVALID.TRANSACTION_MESSAGE_FORMAT");
                String errorMessage = FastMessageFormat.formatMessage(errorFormat, desc);
                String descFormat = this.getTranslatedString("XML_MODEL_INVALID.TRANSACTION_DESC_FORMAT");
                String descMessage = FastMessageFormat.formatMessage(descFormat, desc);
                this.getContext().showErrorMessage(errorMessage, descMessage, fatalException);
            }
            throw fatalException;
        }
        this._hasPendingSelectionEvent = this.getSelection().commitTransaction();
        boolean isValid = false;
        try {
            isValid = baseModel.__requestCommitTransaction(this, shouldThrow);
        }
        catch (XmlCommitException xce) {
            this.getLogger().log(Level.SEVERE, "XmlModel commit threw exception not thrown in precommit! view=" + this, xce);
        }
        return isValid;
    }

    public final void rollbackTransaction() {
        this.getSelection().__rollbackTransaction();
        this.getBaseModel().__requestRollbackTransaction(this);
    }

    public void addModelListener(XmlModelListener changeListener) {
        if (changeListener == null) {
            throw new IllegalArgumentException("No adding null change listeners");
        }
        boolean throwDuplicateAdd = this._pendingAddListeners.contains(changeListener);
        if (!throwDuplicateAdd && this._changeSupport.contains(changeListener)) {
            boolean contained = this._pendingRemoveListeners.remove(changeListener);
            if (contained) {
                return;
            }
            throwDuplicateAdd = true;
        }
        if (throwDuplicateAdd) {
            throw new IllegalStateException("No adding the same listener twice");
        }
        if (this.isDeliveringEvents()) {
            boolean inRemoveListeners = this._pendingRemoveListeners.remove(changeListener);
            if (!inRemoveListeners) {
                this._pendingAddListeners.add(changeListener);
            }
        } else {
            if (this.isFullyInstantiated()) {
                List<XmlModelListener> addedListener = Collections.singletonList(changeListener);
                this._deliverHelloGoodbyeEvents(true, addedListener);
            }
            this._changeSupport.add(changeListener);
        }
    }

    public void removeModelListener(XmlModelListener changeListener) {
        boolean removed = this._pendingAddListeners.remove(changeListener);
        if (!removed) {
            if (this.isDeliveringEvents()) {
                removed = this._changeSupport.contains(changeListener);
                if (removed) {
                    this._pendingRemoveListeners.add(changeListener);
                }
            } else {
                removed = this._changeSupport.remove(changeListener);
                if (removed && this.isFullyInstantiated()) {
                    List<XmlModelListener> removedListener = Collections.singletonList(changeListener);
                    this._deliverHelloGoodbyeEvents(false, removedListener);
                }
            }
            if (!removed) {
                throw new IllegalStateException("Listener " + changeListener + " was never registered on " + this);
            }
        }
    }

    public final boolean isDeliveringEvents() {
        return this._eventDeliveryDepth > 0;
    }

    public Node modelToView(Node modelNode) {
        DomPosition viewPosition;
        if (modelNode != null && (viewPosition = this.modelToView(DomPositionFactory.createInsideOrAfterPosition((Node)modelNode))) != null) {
            return viewPosition.getTargetNode();
        }
        return null;
    }

    public Node viewToModel(Node viewNode) {
        DomPosition modelPosition;
        if (viewNode != null && (modelPosition = this.viewToModel(DomPositionFactory.createInsideOrAfterPosition((Node)viewNode))) != null) {
            return modelPosition.getTargetNode();
        }
        return null;
    }

    public DomPosition convertInsertionPosition(DomPosition origPosition) {
        DomPosition origModel;
        if (origPosition != null && (origModel = this.viewToModel(origPosition)) != null) {
            DomPosition newModel = this.getBaseModel().convertInsertionPosition(origModel);
            if (origModel.equals((Object)newModel)) {
                return origPosition;
            }
            DomPosition newView = this.modelToView(newModel);
            if (newView != null) {
                return newView;
            }
        }
        return origPosition;
    }

    public abstract DomPosition modelToView(DomPosition var1);

    public abstract DomPosition viewToModel(DomPosition var1);

    public TreeWalker createTreeWalker() {
        return new ViewTreeWalker(null);
    }

    public Action getAction(String actionString) {
        if ("nextNode".equals(actionString)) {
            return this._getNavActions().getNextAction();
        }
        if ("prevNode".equals(actionString)) {
            return this._getNavActions().getPreviousAction();
        }
        return this.getBaseModel().getAction(actionString);
    }

    public final List getContextActions() {
        if (this._contextActions == null) {
            this._contextActions = this.initContextActions();
        }
        return this._contextActions;
    }

    public String getTranslatedString(String key) {
        return this.getBaseModel().getTranslatedString(key);
    }

    public Node remapNode(List oldNodePath) {
        int pathCount = oldNodePath.size();
        if (pathCount == 0) {
            return null;
        }
        Node lastNode = (Node)oldNodePath.get(pathCount - 1);
        Node modelNode = this.viewToModel(lastNode);
        if (modelNode != null) {
            int nodeDepth = DomUtils.getNodeDepth((Node)modelNode);
            if (nodeDepth == -1) {
                int i = pathCount - 2;
                while (i >= 0) {
                    Node currViewNode = (Node)oldNodePath.get(i);
                    modelNode = this.viewToModel(currViewNode);
                    if (modelNode != null && (nodeDepth = DomUtils.getNodeDepth((Node)modelNode)) != -1) break;
                    --i;
                }
            }
            if (nodeDepth == -1) {
                return null;
            }
            ArrayList<Node> modelPath = new ArrayList<Node>(nodeDepth);
            int i = 0;
            while (i < nodeDepth) {
                modelPath.add(modelNode);
                modelNode = modelNode.getParentNode();
                ++i;
            }
            Collections.reverse(modelPath);
            Node remappedModelNode = this.getBaseModel().remapNode(modelPath);
            if (remappedModelNode != null) {
                return this.modelToView(remappedModelNode);
            }
            return null;
        }
        return null;
    }

    public final XmlMetadataResolver getXmlMetadataResolver() {
        if (this._resolver == null) {
            MetadataEvaluator evaluator = this.createMetadataEvaluator();
            this._resolver = evaluator == null ? this.getBaseModel().getXmlMetadataResolver() : this.createXmlMetadataResolver(evaluator);
        }
        return this._resolver;
    }

    public XmlKey getNodeXmlKey(Node node) {
        if (node == null) {
            return null;
        }
        Node modelNode = this.viewToModel(node);
        if (modelNode == null) {
            return null;
        }
        return this.getBaseModel().getNodeXmlKey(modelNode);
    }

    public Collection deleteNodes(String transactionName, Collection nodes, boolean updateSelection) throws XmlCommitException {
        Collection[] ret = new Collection[1];
        new 1(this, transactionName, transactionName, nodes, updateSelection, ret).runThrowingXCE(this);
        return ret[0];
    }

    private void _fixUpSelectionPostDeletion() {
        DomRange range;
        DomPosition oldDrop;
        Selection sel = this.getSelection();
        Selection modelSel = this.getBaseModel().getSelection();
        Node[] selNodes = sel.getSelectedNodesArray();
        int i = 0;
        while (i < selNodes.length) {
            Node node = selNodes[i];
            if (!this.isInModelDocumentHierarchy(node)) {
                sel.remove(node);
            }
            ++i;
        }
        DomPosition oldCursor = sel.getCursorLocation();
        if (oldCursor != null && !this.isInModelDocumentHierarchy(oldCursor)) {
            sel.setCursorLocation(this.modelToView(modelSel.getCursorLocation()));
        }
        if ((oldDrop = sel.getDropLocation()) != null && !this.isInModelDocumentHierarchy(oldDrop)) {
            sel.setDropLocation(this.modelToView(modelSel.getDropLocation()));
        }
        if (sel.hasRangeSelection() && !this.isInModelDocumentHierarchy((range = sel.getRangeSelection()).getStart()) && !this.isInModelDocumentHierarchy(range.getEnd())) {
            sel.clearRangeSelectionPreservingNodes();
        }
    }

    public Collection deleteNodes(String transactionName, DomRange range, boolean updateSelection) throws XmlCommitException {
        Collection[] ret = new Collection[1];
        new 2(this, transactionName, range, ret, transactionName, updateSelection).runThrowingXCE(this);
        return ret[0];
    }

    public Collection insertNodes(DomPosition location, String transactionName, Collection nodes, boolean updateSelection) throws XmlCommitException {
        Collection[] ret = new Collection[1];
        new 3(this, transactionName, location, transactionName, nodes, updateSelection, ret).runThrowingXCE(this);
        return ret[0];
    }

    protected final List viewToModel(Collection collection) {
        if (collection.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Node> ret = new ArrayList<Node>(collection.size());
        for (Object next : collection) {
            Object modelObject = next instanceof Node ? this.viewToModel((Node)next) : (next instanceof DomPosition ? this.viewToModel((DomPosition)next) : null);
            if (modelObject == null) continue;
            ret.add((Node)modelObject);
        }
        return ret;
    }

    protected final List modelToView(Collection collection) {
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Node> ret = new ArrayList<Node>(collection.size());
        for (Object next : collection) {
            Object viewObject = next instanceof Node ? this.modelToView((Node)next) : (next instanceof DomPosition ? this.modelToView((DomPosition)next) : null);
            if (viewObject == null) continue;
            ret.add((Node)viewObject);
        }
        return ret;
    }

    protected void mergeTextNodesImpl(Text a, Text b) {
        AbstractModel.MapperForMergeTextNodes mapper = new AbstractModel.MapperForMergeTextNodes(a, b);
        Node modelA = this.viewToModel(a);
        Node modelB = this.viewToModel(b);
        if (a == modelA && b == modelB && a.getNextSibling() == b) {
            this.getBaseModel().mergeTextNodesImpl(a, b);
        } else {
            a.appendData(b.getNodeValue());
            Node parent = this.getTreeTraversal().getParentNode((Node)b);
            parent.removeChild(b);
        }
        mapper.applyMappings();
    }

    protected Text splitTextNodeImpl(Text orig, int offset) {
        AbstractModel.MapperForSplitTextNode mapper = new AbstractModel.MapperForSplitTextNode(orig, offset);
        Node modelOrig = this.viewToModel(orig);
        Text created = modelOrig == orig ? this.getBaseModel().splitTextNodeImpl(orig, offset) : orig.splitText(offset);
        mapper.setCreated(created);
        mapper.applyMappings();
        return created;
    }

    public Transferable createTransferable() {
        this.acquireReadLock();
        try {
            if (!this.getXmlMetadataResolver().isSelectionTransferable()) {
                Transferable transferable = null;
                return transferable;
            }
            Transferable transferable = this.getBaseModel().createTransferable();
            return transferable;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public List getExtraContextMenus(DomPosition position) {
        return this.getBaseModel().getViewExtraContextMenus(this, position);
    }

    public boolean isReadOnly() {
        return this.getBaseModel().isReadOnly() || this.requiresValidModel() && !this.getBaseModel().isDocumentValid();
    }

    protected final boolean isImmutable(Node node) {
        if (node == null) {
            return false;
        }
        if (this.isReadOnly()) {
            return true;
        }
        Node modelNode = this.viewToModel(node);
        if (modelNode != null) {
            return this.getBaseModel().isImmutable(modelNode);
        }
        return false;
    }

    protected final boolean isDeletable(Node node) {
        if (node == null) {
            return false;
        }
        Node modelNode = this.viewToModel(node);
        if (modelNode != null) {
            return this.getBaseModel().isDeletable(modelNode);
        }
        return true;
    }

    protected final boolean canAddChild(DomPosition position) {
        if (position == null) {
            return false;
        }
        DomPosition modelPos = this.viewToModel(position);
        if (modelPos != null) {
            return this.getBaseModel().canAddChild(modelPos);
        }
        return true;
    }

    protected final boolean canAddAttribute(Element parent, XmlKey attrKey) {
        if (parent == null) {
            return false;
        }
        Element modelParent = (Element)this.viewToModel(parent);
        if (modelParent != null) {
            return this.getBaseModel().canAddAttribute(modelParent, attrKey);
        }
        return true;
    }

    protected final boolean isValueModifiable(Node node) {
        if (node == null) {
            return false;
        }
        Node modelNode = this.viewToModel(node);
        if (modelNode != null) {
            return this.getBaseModel().isValueModifiable(modelNode);
        }
        return true;
    }

    public TreeTraversal getTreeTraversal() {
        this.__verifyLock();
        TreeTraversal ret = this.getTreeTraversalImpl();
        if (ret == null) {
            return null;
        }
        if (this._currentViewTraversal == null || ret != this._currentViewTraversal.getRealTraversal()) {
            this._currentViewTraversal = new LockAssertingTreeTraversal(ret);
        }
        return this._currentViewTraversal;
    }

    public final void acquireReadLock() {
        this.getBaseModel().acquireReadLock();
    }

    public final void releaseReadLock() {
        this.getBaseModel().releaseReadLock();
    }

    public final XmlModelEvent createHelloGoodbyeEvent(boolean isHello) {
        return this.createEvent(isHello);
    }

    final void __acquireWriteLock() {
        this.getBaseModel().__acquireWriteLock();
    }

    final void __releaseWriteLock() {
        this.getBaseModel().__releaseWriteLock();
    }

    final void __verifyLock() {
        this.getBaseModel().__verifyLock();
    }

    final void __verifyWriteLock() {
        this.getBaseModel().__verifyWriteLock();
    }

    protected TreeTraversal getTreeTraversalImpl() {
        return null;
    }

    protected void baseModelAttached() {
        XmlModel baseModel = this.getBaseModel();
        this.acquireReadLock();
        try {
            this._document = baseModel.getDocument();
        }
        finally {
            this.releaseReadLock();
        }
    }

    protected void postAttachmentHook() {
        this.getXmlMetadataResolver();
    }

    protected void postCreationHook() {
    }

    protected MetadataProvider createMetadataProvider() {
        return null;
    }

    protected MetadataEvaluator createMetadataEvaluator() {
        return null;
    }

    protected XmlMetadataResolver createXmlMetadataResolver(MetadataEvaluator evaluator) {
        XmlMetadataResolver baseResolver = this.getBaseModel().getXmlMetadataResolver();
        return baseResolver.cloneWithEvaluator(evaluator, this);
    }

    protected List initContextActions() {
        Action goDecl;
        ArrayList<Action> contextActions = new ArrayList<Action>(7);
        contextActions.add(this.getAction("cut"));
        contextActions.add(this.getAction("copy"));
        contextActions.add(this.getAction("paste"));
        contextActions.add(this.getAction("clear"));
        contextActions.add(this.getAction("customizeNode"));
        contextActions.add(this.getAction("convertNode"));
        contextActions.add(this.getAction("surroundNode"));
        contextActions.add(this.getAction("gotoproperties"));
        Action goSource = this.getAction("gotosource");
        if (goSource != null) {
            contextActions.add(goSource);
        }
        if ((goDecl = this.getAction("gotodeclaration")) != null) {
            contextActions.add(goDecl);
        }
        return Collections.unmodifiableList(contextActions);
    }

    protected XmlModelEvent transformModelEvent(XmlModelEvent modelChangeEvent) {
        return new XmlModelEvent(this, modelChangeEvent.getChangeRoot(), modelChangeEvent.getChangeFlags(), modelChangeEvent.getPropertyChanges(), modelChangeEvent.getSelectionsAdded(), modelChangeEvent.getSelectionsRemoved(), modelChangeEvent.getBaseModelDomChanges(), modelChangeEvent.getNodeChangeDetails());
    }

    public Set modelNodeIteratorToViewNodeSet(Iterator modelNodeIterator, Set mutableOutSet) {
        if (modelNodeIterator == null || !modelNodeIterator.hasNext()) {
            return Collections.EMPTY_SET;
        }
        if (mutableOutSet == null) {
            mutableOutSet = new HashSet(17);
        }
        this._modelNodeIteratorToViewNodeSet(modelNodeIterator, mutableOutSet);
        return mutableOutSet;
    }

    public Set modelNodeSetToViewNodeSet(Set modelSet, Set mutableOutSet) {
        int setSize = modelSet.size();
        if (setSize == 0) {
            return modelSet;
        }
        Set viewSet = mutableOutSet != null ? mutableOutSet : new HashSet((int)((double)setSize * 1.5));
        Iterator modelNodes = modelSet.iterator();
        boolean changed = this._modelNodeIteratorToViewNodeSet(modelNodes, viewSet);
        if (changed) {
            return viewSet;
        }
        return modelSet;
    }

    protected boolean validatesTransactions() {
        return true;
    }

    protected void createSelection() {
    }

    protected void initializeSelectionState(XmlModelEvent modelHelloEvent) {
    }

    protected void handleModelInvalidateEvent(XmlModelEvent event) {
    }

    protected void handleModelChangeEvent(XmlModelEvent event) {
    }

    protected void deliverInitialEvents() {
        if (this.isFullyInstantiated()) {
            this._deliverHelloGoodbyeEvents(true, this._changeSupport);
        }
    }

    protected void addCurrentPropertiesToEvent(Map propertyChanges, boolean isAdding) {
        super.addCurrentPropertiesToEvent(propertyChanges, isAdding);
        boolean isValid = this.getBaseModel().isDocumentValid();
        PropertyChange isValidChange = null;
        if (isAdding) {
            if (isValid) {
                isValidChange = new PropertyChange("documentValid", Boolean.FALSE, Boolean.TRUE);
            }
        } else if (isValid) {
            isValidChange = new PropertyChange("documentValid", Boolean.TRUE, Boolean.FALSE);
        }
        if (isValidChange != null) {
            propertyChanges.put("documentValid", isValidChange);
        }
        propertyChanges.put("XmlModelIssueList", new PropertyChange("XmlModelIssueList", null, this.getContext().getIssueList()));
    }

    void __attachBaseModel(XmlModel baseModel) {
        if (baseModel == null) {
            throw new IllegalArgumentException("Null XmlModel passed as the base model");
        }
        if (this._model != null) {
            throw new IllegalStateException("Cannot attach a BaseModel twice");
        }
        this._model = baseModel;
    }

    void __initializationComplete() {
        this.getBaseModel().addModelListener(new ModelChangeListener(null));
        this._instantiated = true;
        this.deliverInitialEvents();
    }

    /*
     * Exception decompiling
     */
    private void _deliverHelloGoodbyeEvents(boolean isHello, List changeListenerList) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean _modelNodeIteratorToViewNodeSet(Iterator modelNodeIterator, Set mutableOutSet) {
        boolean changed = false;
        while (modelNodeIterator.hasNext()) {
            Node viewNode;
            Node modelNode = (Node)modelNodeIterator.next();
            changed |= modelNode != (viewNode = this.modelToView(modelNode));
            if (viewNode == null) continue;
            mutableOutSet.add(viewNode);
        }
        return changed;
    }

    private XmlNavigationActions _getNavActions() {
        if (this._navActions == null) {
            this._navActions = new XmlNavigationActions(this, this.getTreeTraversal());
        }
        return this._navActions;
    }

    static {
        $assertionsDisabled = XmlView.class.desiredAssertionStatus() ^ true;
    }

    private void _handleBaseModelInvalidate(XmlModelEvent modelEvent) {
        if (!$assertionsDisabled && modelEvent.getSource() != this.getBaseModel()) {
            throw new AssertionError();
        }
        this._hasPendingSelectionEvent = false;
        XmlModelEvent viewEvent = null;
        if (this.requiresValidModel()) {
            PropertyChange validChange = modelEvent.getDomDocumentValidPropertyChange();
            if (validChange != null) {
                if (!validChange.getNewBooleanValue()) {
                    if (!$assertionsDisabled && this._invalidateBufferingEvent != null) {
                        throw new AssertionError();
                    }
                    this._invalidateBufferingEvent = (XmlModelEvent)modelEvent.clone();
                    this._invalidateBufferingEvent.removePropertyChange(validChange.getPropertyName());
                    viewEvent = new XmlModelEvent(this);
                    viewEvent.addPropertyChanges(Collections.singletonMap(validChange.getPropertyName(), validChange));
                } else if (this._invalidateBufferingEvent != null) {
                    this._invalidateBufferingEvent.addModelEvent(modelEvent);
                    modelEvent = this._invalidateBufferingEvent;
                    this._invalidateBufferingEvent = null;
                }
            } else if (this._invalidateBufferingEvent != null) {
                this._invalidateBufferingEvent.addModelEvent(modelEvent);
                if (this.getBaseModel().isDocumentValid()) {
                    modelEvent = this._invalidateBufferingEvent;
                    this._invalidateBufferingEvent = null;
                } else {
                    modelEvent = null;
                }
            }
        }
        if (modelEvent != null) {
            this._eventToTransform = modelEvent;
            PropertyChange documentChange = modelEvent.getDomDocumentPropertyChange();
            if (documentChange != null) {
                this._document = (Document)documentChange.getNewValue();
            }
            if (viewEvent == null) {
                viewEvent = this.transformModelEvent(modelEvent);
            }
            if (viewEvent != null && viewEvent.getChangeFlags() != 0) {
                this._transformedEvent = viewEvent;
                this.acquireReadLock();
                try {
                    try {
                        this.handleModelInvalidateEvent(viewEvent);
                    }
                    catch (Throwable e) {
                        this.getLogger().log(Level.WARNING, "Unexpected throwable in XmlView.handleModelInvalidateEvent", e);
                    }
                    if (this.getLogger().isLoggable(Level.FINER)) {
                        this.getLogger().finer("XmlView deliver (" + this + "): " + viewEvent);
                    }
                    this.deliverInvalidateEvent(viewEvent, this._changeSupport.iterator());
                }
                finally {
                    this.releaseReadLock();
                }
            }
            this._transformedEvent = null;
            this.deliverNoChangeEvent(this._changeSupport.iterator());
        }
    }

    private void _handleBaseModelChanged(XmlModelEvent event) {
        XmlModelEvent viewChangeEvent;
        if (this._eventToTransform == event) {
            viewChangeEvent = this._transformedEvent;
            if (this.getBaseModel().isDocumentValid()) {
                this._changeBufferingEvent = null;
                this._invalidateBufferingEvent = null;
            } else if (this._invalidateBufferingEvent != null) {
                this._changeBufferingEvent = (XmlModelEvent)this._invalidateBufferingEvent.clone();
            }
        } else if (this._changeBufferingEvent != null) {
            this._changeBufferingEvent.addModelEvent(event);
            if (this.getBaseModel().isDocumentValid()) {
                viewChangeEvent = this.transformModelEvent(this._changeBufferingEvent);
                this._changeBufferingEvent = null;
                this._invalidateBufferingEvent = null;
            } else {
                viewChangeEvent = null;
            }
        } else {
            viewChangeEvent = this.transformModelEvent(event);
        }
        this._transformedEvent = null;
        this._eventToTransform = null;
        if (viewChangeEvent != null && viewChangeEvent.getChangeFlags() != 0) {
            this.acquireReadLock();
            try {
                try {
                    this.handleModelChangeEvent(viewChangeEvent);
                }
                catch (Throwable e) {
                    this.getLogger().log(Level.WARNING, "Unexpected throwable in XmlView.handleModelChangeEvent", e);
                }
                Iterator viewChangeListeners = this._changeSupport.iterator();
                if (viewChangeListeners != null) {
                    while (viewChangeListeners.hasNext()) {
                        XmlModelListener currListener = (XmlModelListener)viewChangeListeners.next();
                        try {
                            if (!this._pendingRemoveListeners.isEmpty() && this._pendingRemoveListeners.contains(currListener)) continue;
                            currListener.modelChanged(viewChangeEvent);
                        }
                        catch (ThreadDeath e) {
                            throw e;
                        }
                        catch (Throwable t) {
                            this.getLogger().log(Level.WARNING, "Unexpected exception notifying XmlView listener: " + currListener, t);
                        }
                    }
                }
            }
            finally {
                this.releaseReadLock();
            }
        }
    }

    private boolean _validatesButDoesntRequireValidModel() {
        return this.validatesTransactions() && !this.requiresValidModel();
    }

    private void $init$() {
        this._changeSupport = new ArrayList(10);
        this._pendingAddListeners = new HashSet(5);
        this._pendingRemoveListeners = new HashSet(5);
    }

    static boolean ra$_hasPendingSelectionEvent(XmlView xmlView) {
        return xmlView._hasPendingSelectionEvent;
    }

    static void mav$_handleBaseModelInvalidate(XmlView xmlView, XmlModelEvent xmlModelEvent) {
        xmlView._handleBaseModelInvalidate(xmlModelEvent);
    }

    static void mav$_handleBaseModelChanged(XmlView xmlView, XmlModelEvent xmlModelEvent) {
        xmlView._handleBaseModelChanged(xmlModelEvent);
    }

    static void wa$_hasPendingSelectionEvent(XmlView xmlView, boolean bl) {
        xmlView._hasPendingSelectionEvent = bl;
    }

    static ArrayList ra$_changeSupport(XmlView xmlView) {
        return xmlView._changeSupport;
    }

    static int ra$_eventDeliveryDepth(XmlView xmlView) {
        return xmlView._eventDeliveryDepth;
    }

    static void wa$_eventDeliveryDepth(XmlView xmlView, int n) {
        xmlView._eventDeliveryDepth = n;
    }

    static HashSet ra$_pendingAddListeners(XmlView xmlView) {
        return xmlView._pendingAddListeners;
    }

    static HashSet ra$_pendingRemoveListeners(XmlView xmlView) {
        return xmlView._pendingRemoveListeners;
    }

    static void mav$_deliverHelloGoodbyeEvents(XmlView xmlView, boolean bl, List list) {
        xmlView._deliverHelloGoodbyeEvents(bl, list);
    }

    final class 1
    extends FixedNameTransactionTask {
        private final /* synthetic */ String v$transactionName;
        private final /* synthetic */ Collection v$nodes;
        private final /* synthetic */ boolean v$updateSelection;
        private final /* synthetic */ Collection[] v$ret;
        final /* synthetic */ XmlView this$0;

        protected void performTask(AbstractModel model) throws XmlCommitException {
            Collection modelRet = this.this$0.getBaseModel().deleteNodes(this.v$transactionName, this.this$0.viewToModel(this.v$nodes), this.v$updateSelection);
            this.v$ret[0] = this.this$0.modelToView(modelRet);
        }

        public 1(XmlView xmlView, String string, String string2, Collection collection, boolean bl, Collection[] collectionArray) {
            this.v$ret = collectionArray;
            this.v$updateSelection = bl;
            this.v$nodes = collection;
            this.v$transactionName = string2;
            this.this$0 = xmlView;
            super(string);
        }
    }

    final class 2
    extends FixedNameTransactionTask {
        private final /* synthetic */ DomRange v$range;
        private final /* synthetic */ Collection[] v$ret;
        private final /* synthetic */ String v$transactionName;
        private final /* synthetic */ boolean v$updateSelection;
        final /* synthetic */ XmlView this$0;

        protected void performTask(AbstractModel model) throws XmlCommitException {
            if (this.v$range.isInsideAttributeValue()) {
                Element owner = (Element)this.v$range.getStart().getTargetNode();
                Node modelOwner = this.this$0.viewToModel(owner);
                if (DomUtils.isElement((Node)modelOwner)) {
                    Element modelElem = (Element)modelOwner;
                    QualifiedName attrQName = this.v$range.getStart().getAttributeQName();
                    this.this$0.getBaseModel().deleteInsideAttributeValueImpl(DomRange.create((DomPosition)DomPositionFactory.createAttributePosition((Element)modelElem, (QualifiedName)attrQName, (int)this.v$range.getStart().getTextOffset()), (DomPosition)DomPositionFactory.createAttributePosition((Element)modelElem, (QualifiedName)attrQName, (int)this.v$range.getEnd().getTextOffset()), (TreeTraversal)model.getBaseModel().getTreeTraversal()));
                    this.v$ret[0] = Collections.EMPTY_LIST;
                } else {
                    this.cancelTask();
                }
            } else {
                Node modelTarget;
                Node startTarget = this.v$range.getStart().getTargetNode();
                if (startTarget == this.v$range.getEnd().getTargetNode() && (modelTarget = this.this$0.viewToModel(startTarget)) == startTarget) {
                    Collection modelRet = this.this$0.getBaseModel().deleteNodes(this.v$transactionName, this.v$range, this.v$updateSelection);
                    this.v$ret[0] = this.this$0.modelToView(modelRet);
                    return;
                }
                Collection viewNodes = this.this$0.getNodesForDeletion(this.v$range, this.v$updateSelection);
                Collection modelRet = this.this$0.getBaseModel().deleteNodes(this.v$transactionName, this.this$0.viewToModel(viewNodes), false);
                this.v$ret[0] = this.this$0.modelToView(modelRet);
            }
        }

        public 2(XmlView xmlView, String string, DomRange domRange, Collection[] collectionArray, String string2, boolean bl) {
            this.v$updateSelection = bl;
            this.v$transactionName = string2;
            this.v$ret = collectionArray;
            this.v$range = domRange;
            this.this$0 = xmlView;
            super(string);
        }
    }

    final class 3
    extends FixedNameTransactionTask {
        private final /* synthetic */ DomPosition v$location;
        private final /* synthetic */ String v$transactionName;
        private final /* synthetic */ Collection v$nodes;
        private final /* synthetic */ boolean v$updateSelection;
        private final /* synthetic */ Collection[] v$ret;
        final /* synthetic */ XmlView this$0;

        protected void performTask(AbstractModel model) throws XmlCommitException {
            DomPosition modelPos = this.this$0.viewToModel(this.v$location);
            if (modelPos != null) {
                Collection modelRet = this.this$0.getBaseModel().insertNodes(modelPos, this.v$transactionName, this.this$0.viewToModel(this.v$nodes), this.v$updateSelection);
                this.v$ret[0] = this.this$0.modelToView(modelRet);
                if (this.v$updateSelection) {
                    this.this$0.selectInsertedNodes(this.v$ret[0]);
                }
            }
        }

        public 3(XmlView xmlView, String string, DomPosition domPosition, String string2, Collection collection, boolean bl, Collection[] collectionArray) {
            this.v$ret = collectionArray;
            this.v$updateSelection = bl;
            this.v$nodes = collection;
            this.v$transactionName = string2;
            this.v$location = domPosition;
            this.this$0 = xmlView;
            super(string);
        }
    }

    private class ViewTreeWalker
    extends TreeTraversalTreeWalker {
        protected TreeTraversal getTreeTraversal() {
            return XmlView.this.getTreeTraversal();
        }

        public Node getRoot() {
            Document doc = XmlView.this.getDocument();
            if (doc != null) {
                return doc.getDocumentElement();
            }
            return null;
        }

        private ViewTreeWalker() {
        }

        ViewTreeWalker(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ModelChangeListener
    extends XmlModelAdapter {
        public void invalidate(XmlModelEvent event) {
            if (XmlView.ra$_eventDeliveryDepth(XmlView.this) == 0) {
                ArrayList listenersToAdd = null;
                ArrayList listenersToRemove = null;
                if (!XmlView.ra$_pendingAddListeners(XmlView.this).isEmpty()) {
                    listenersToAdd = new ArrayList(XmlView.ra$_pendingAddListeners(XmlView.this));
                    XmlView.ra$_pendingAddListeners(XmlView.this).clear();
                    XmlView.ra$_changeSupport(XmlView.this).addAll(listenersToAdd);
                }
                if (!XmlView.ra$_pendingRemoveListeners(XmlView.this).isEmpty()) {
                    listenersToRemove = new ArrayList(XmlView.ra$_pendingRemoveListeners(XmlView.this));
                    XmlView.ra$_pendingRemoveListeners(XmlView.this).clear();
                    XmlView.ra$_changeSupport(XmlView.this).removeAll(listenersToRemove);
                }
                if (listenersToRemove != null) {
                    XmlView.mav$_deliverHelloGoodbyeEvents(XmlView.this, false, listenersToRemove);
                }
                if (listenersToAdd != null) {
                    XmlView.mav$_deliverHelloGoodbyeEvents(XmlView.this, true, listenersToAdd);
                }
            }
            XmlView xmlView = XmlView.this;
            XmlView.wa$_eventDeliveryDepth(xmlView, XmlView.ra$_eventDeliveryDepth(xmlView) + 1);
            XmlView.mav$_handleBaseModelInvalidate(XmlView.this, event);
            XmlView xmlView2 = XmlView.this;
            XmlView.wa$_eventDeliveryDepth(xmlView2, XmlView.ra$_eventDeliveryDepth(xmlView2) - 1);
        }

        public void modelChanged(XmlModelEvent event) {
            XmlView xmlView = XmlView.this;
            XmlView.wa$_eventDeliveryDepth(xmlView, XmlView.ra$_eventDeliveryDepth(xmlView) + 1);
            XmlView.mav$_handleBaseModelChanged(XmlView.this, event);
            XmlView xmlView2 = XmlView.this;
            XmlView.wa$_eventDeliveryDepth(xmlView2, XmlView.ra$_eventDeliveryDepth(xmlView2) - 1);
        }

        public void noChange(XmlModelEvent event) {
            if (XmlView.ra$_hasPendingSelectionEvent(XmlView.this)) {
                XmlView.mav$_handleBaseModelInvalidate(XmlView.this, event);
                XmlView.mav$_handleBaseModelChanged(XmlView.this, event);
                XmlView.wa$_hasPendingSelectionEvent(XmlView.this, false);
            }
            XmlView.this.deliverNoChangeEvent(XmlView.ra$_changeSupport(XmlView.this).iterator());
        }

        public void listenerAttached(XmlModelEvent event) {
            XmlView.this.initializeSelectionState(event);
        }

        private ModelChangeListener() {
        }

        ModelChangeListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class LockAssertingTreeTraversal
    extends TreeTraversal {
        private final TreeTraversal _real;

        public LockAssertingTreeTraversal(TreeTraversal real) {
            this._real = real;
        }

        public TreeTraversal getRealTraversal() {
            return this._real;
        }

        public Node getParentNode(Node node) {
            XmlView.this.__verifyLock();
            return this._real.getParentNode(node);
        }

        public Node getFirstChild(Node node) {
            XmlView.this.__verifyLock();
            return this._real.getFirstChild(node);
        }

        public Node getLastChild(Node node) {
            XmlView.this.__verifyLock();
            return this._real.getLastChild(node);
        }

        public Node getNextSibling(Node node) {
            XmlView.this.__verifyLock();
            return this._real.getNextSibling(node);
        }

        public Node getPreviousSibling(Node node) {
            XmlView.this.__verifyLock();
            return this._real.getPreviousSibling(node);
        }

        public Node getChild(Node parentNode, int childIndex) {
            XmlView.this.__verifyLock();
            return this._real.getChild(parentNode, childIndex);
        }

        public int getChildCount(Node parentNode) {
            XmlView.this.__verifyLock();
            return this._real.getChildCount(parentNode);
        }

        public Node getPreviousNode(Node node) {
            XmlView.this.__verifyLock();
            return this._real.getPreviousNode(node);
        }

        public Node getNextNode(Node node) {
            XmlView.this.__verifyLock();
            return this._real.getNextNode(node);
        }
    }
}

