/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import javax.swing.Action;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.action.ModelAction;
import oracle.bali.xml.model.event.XmlModelAdapter;

public class ActionManager {
    static final /* synthetic */ boolean $assertionsDisabled;
    private final XmlContext _context;
    private final transient Listener _listener;
    private LinkedHashMap _actions;
    private LinkedList _pendingAddList;
    private LinkedList _activeViewActions;
    private LinkedList _modelListeners;
    private transient boolean _isTraversingActions;

    public ActionManager(XmlContext context) {
        this.$init$();
        if (context == null) {
            throw new IllegalArgumentException("No context specified");
        }
        this._context = context;
        this._listener = new Listener(null);
        context.addPropertyChangeListener(this._listener);
    }

    public Action getAction(String command) {
        return (Action)this._actions.get(command);
    }

    public void manageAction(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("No managing null actions");
        }
        String command = (String)action.getValue("ActionCommandKey");
        if (command == null) {
            throw new IllegalArgumentException("No command on action:" + action);
        }
        if (this._isTraversingActions) {
            this._pendingAddList.add(action);
        } else {
            this._actions.put(command, action);
            if (action instanceof ModelAction) {
                AbstractModel model;
                ModelAction modelAction = (ModelAction)((Object)action);
                boolean isActiveViewAction = modelAction.isActiveViewAction();
                XmlModelListener modelListener = modelAction.getModelListener();
                if (isActiveViewAction) {
                    this._activeViewActions.add(modelAction);
                    modelAction.setModel(this._context.getActiveView());
                    if (modelListener != null) {
                        this._modelListeners.add(modelListener);
                    }
                } else if (modelListener != null && (model = modelAction.getModel()) != null) {
                    model.addModelListener(modelListener);
                }
            }
        }
    }

    private void _deliverModelEvents(XmlModelEvent event, boolean isInvalidate) {
        this._isTraversingActions = true;
        for (XmlModelListener currListener : this._modelListeners) {
            if (currListener == null) continue;
            if (isInvalidate) {
                currListener.invalidate(event);
                continue;
            }
            currListener.modelChanged(event);
        }
        this._isTraversingActions = false;
        this._addPendingActions();
    }

    static {
        $assertionsDisabled = ActionManager.class.desiredAssertionStatus() ^ true;
    }

    private void _updateViewTrackingActions(AbstractModel newModel) {
        this._isTraversingActions = true;
        for (ModelAction currAction : this._activeViewActions) {
            if (!$assertionsDisabled && !currAction.isActiveViewAction()) {
                throw new AssertionError();
            }
            currAction.setModel(newModel);
        }
        this._isTraversingActions = false;
        this._addPendingActions();
    }

    private void _addPendingActions() {
        if (!this._pendingAddList.isEmpty()) {
            Iterator pendingActions = this._pendingAddList.iterator();
            while (pendingActions.hasNext()) {
                this.manageAction((Action)pendingActions.next());
            }
            this._pendingAddList.clear();
        }
    }

    private void $init$() {
        this._actions = new LinkedHashMap(17);
        this._pendingAddList = new LinkedList();
        this._activeViewActions = new LinkedList();
        this._modelListeners = new LinkedList();
    }

    static void mav$_deliverModelEvents(ActionManager actionManager, XmlModelEvent xmlModelEvent, boolean bl) {
        actionManager._deliverModelEvents(xmlModelEvent, bl);
    }

    static Listener ra$_listener(ActionManager actionManager) {
        return actionManager._listener;
    }

    static void mav$_updateViewTrackingActions(ActionManager actionManager, AbstractModel abstractModel) {
        actionManager._updateViewTrackingActions(abstractModel);
    }

    private class Listener
    extends XmlModelAdapter
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent event) {
            String changedProperty = event.getPropertyName();
            if ("XmlContext.ACTIVE_VIEW".equals(changedProperty)) {
                AbstractModel oldModel = (AbstractModel)event.getOldValue();
                AbstractModel newModel = (AbstractModel)event.getNewValue();
                if (oldModel != null) {
                    oldModel.removeModelListener(ActionManager.ra$_listener(ActionManager.this));
                }
                if (newModel != null) {
                    newModel.addModelListener(ActionManager.ra$_listener(ActionManager.this));
                }
                ActionManager.mav$_updateViewTrackingActions(ActionManager.this, newModel);
            }
        }

        public void listenerAttached(XmlModelEvent event) {
        }

        public void invalidate(XmlModelEvent event) {
            ActionManager.mav$_deliverModelEvents(ActionManager.this, event, true);
        }

        public void modelChanged(XmlModelEvent event) {
            ActionManager.mav$_deliverModelEvents(ActionManager.this, event, false);
        }

        public void listenerDetached(XmlModelEvent event) {
        }

        private Listener() {
        }

        Listener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

