/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.action.ModelAction;
import oracle.bali.xml.model.event.XmlModelAdapter;
import oracle.bali.xml.share.BaseAction;

public class BaseModelAction
extends BaseAction
implements ModelAction {
    private AbstractModel _model;
    private volatile boolean _recalcEnabled;
    private final transient XmlModelListener _modelListener;
    private final transient PropertyChangeListener _contextListener;
    private static final Logger _LOGGER = Logger.getLogger(BaseModelAction.class.getName());

    public BaseModelAction(String mnemonicAndDisplayName, KeyStroke accelerator, String actionCommand, boolean needsModelListener, boolean needsContextListener) {
        super(StringUtils.stripMnemonic((String)mnemonicAndDisplayName), StringUtils.getMnemonicKeyCode((String)mnemonicAndDisplayName), accelerator, actionCommand, null);
        if (needsModelListener || needsContextListener) {
            Listener changeListener = new Listener(null);
            this._modelListener = needsModelListener ? changeListener : null;
            this._contextListener = needsContextListener ? changeListener : null;
        } else {
            this._modelListener = null;
            this._contextListener = null;
        }
    }

    public boolean isActiveViewAction() {
        return false;
    }

    public final void setModel(AbstractModel model) {
        if (model != this._model) {
            if (this._contextListener != null) {
                XmlContext newContext;
                XmlContext oldContext = this._model != null ? this._model.getContext() : null;
                XmlContext xmlContext = newContext = model != null ? model.getContext() : null;
                if (oldContext != newContext) {
                    if (oldContext != null) {
                        oldContext.removePropertyChangeListener(this._contextListener);
                    }
                    if (newContext != null) {
                        newContext.addPropertyChangeListener(this._contextListener);
                    }
                }
            }
            this._model = model;
            this._updateEnabled();
        }
    }

    public final AbstractModel getModel() {
        return this._model;
    }

    public XmlModelListener getModelListener() {
        return this._modelListener;
    }

    protected boolean isEnabledImpl() {
        AbstractModel model = this.getModel();
        if (model == null) {
            return false;
        }
        if (!this._mutatesModel()) {
            return true;
        }
        model.acquireReadLock();
        try {
            boolean bl = model.isReadOnly() ^ true;
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            model.releaseReadLock();
        }
    }

    protected boolean needToUpdateEnabled(XmlModelEvent event) {
        return true;
    }

    protected boolean needToUpdateEnabled(PropertyChangeEvent event) {
        return true;
    }

    protected final boolean needsToRespondToReadOnlyChange(XmlModelEvent event) {
        return this._mutatesModel() && event.getPropertyChange("readOnly") != null;
    }

    private boolean _mutatesModel() {
        return Boolean.TRUE.equals(this.getValue("XmlContext.MUTATES_MODEL"));
    }

    protected final void scheduleRecalculateEnabled(int waitMs) {
        if (waitMs <= 0) {
            throw new IllegalArgumentException("non-positive wait ms");
        }
        1 r = new 1(this, waitMs);
        this._recalcEnabled = true;
        Thread thread = new Thread((Runnable)r, "recalc thread for " + this.getClass());
        thread.setPriority(1);
        thread.setDaemon(true);
        thread.start();
    }

    private void _updateEnabled() {
        AbstractModel model = this.getModel();
        if (model != null) {
            model.acquireReadLock();
        }
        try {
            boolean enabled = this.isEnabledImpl();
            this.setEnabled(enabled);
            if (_LOGGER.isLoggable(Level.FINER)) {
                _LOGGER.log(Level.FINER, "setEnabled on {0} to {1}, model={2}", new Object[]{this, enabled, model});
            }
        }
        finally {
            if (model != null) {
                model.releaseReadLock();
            }
        }
        if (this._recalcEnabled) {
            this._recalcEnabled = false;
        }
    }

    static void wa$_recalcEnabled(BaseModelAction baseModelAction, boolean bl) {
        baseModelAction._recalcEnabled = bl;
    }

    static void mav$_updateEnabled(BaseModelAction baseModelAction) {
        baseModelAction._updateEnabled();
    }

    static boolean ra$_recalcEnabled(BaseModelAction baseModelAction) {
        return baseModelAction._recalcEnabled;
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ int v$waitMs;
        final /* synthetic */ BaseModelAction this$0;

        public void run() {
            try {
                Thread.sleep(this.v$waitMs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (BaseModelAction.ra$_recalcEnabled(this.this$0)) {
                BaseModelAction.mav$_updateEnabled(this.this$0);
            }
        }

        public 1(BaseModelAction baseModelAction, int n) {
            this.v$waitMs = n;
            this.this$0 = baseModelAction;
        }
    }

    private class Listener
    extends XmlModelAdapter
    implements PropertyChangeListener {
        public void listenerAttached(XmlModelEvent event) {
            BaseModelAction.mav$_updateEnabled(BaseModelAction.this);
        }

        public void modelChanged(XmlModelEvent event) {
            if (BaseModelAction.ra$_recalcEnabled(BaseModelAction.this) || BaseModelAction.this.needToUpdateEnabled(event)) {
                BaseModelAction.mav$_updateEnabled(BaseModelAction.this);
            }
        }

        public void listenerDetached(XmlModelEvent event) {
            BaseModelAction.mav$_updateEnabled(BaseModelAction.this);
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (BaseModelAction.this.needToUpdateEnabled(event)) {
                if (BaseModelAction.this.getModel().getBaseModel().isInTransaction()) {
                    BaseModelAction.wa$_recalcEnabled(BaseModelAction.this, true);
                } else {
                    BaseModelAction.mav$_updateEnabled(BaseModelAction.this);
                }
            }
        }

        private Listener() {
        }

        Listener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

