/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.action;

import java.awt.event.ActionEvent;
import java.util.logging.Level;
import javax.swing.KeyStroke;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.action.ModelAction;
import oracle.bali.xml.model.task.SelectionBasedTransactionTask;
import oracle.bali.xml.model.task.StandardTransactionTask;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.util.XmlModelUtils;
import oracle.bali.xml.util.XmlTransferableSelectionAction;

public class ClearAction
extends XmlTransferableSelectionAction {
    private static final StandardTransactionTask _TASK = new Task(null);

    public ClearAction(String mnemonicAndDisplayName) {
        super(mnemonicAndDisplayName, KeyStroke.getKeyStroke(127, 0), "clear", false, true);
        this.putValue("XmlContext.MUTATES_MODEL", Boolean.TRUE);
    }

    public void actionPerformed(ActionEvent event) {
        try {
            ClearAction.__doClear(this);
        }
        catch (XmlCommitException e) {
            this.getModel().getLogger().log(Level.SEVERE, "Validation failed in:" + this, e);
        }
    }

    static void __doClear(ModelAction action) throws XmlCommitException {
        _TASK.runThrowingXCE(action.getModel());
    }

    private static class Task
    extends SelectionBasedTransactionTask {
        protected void performTask(AbstractModel model) throws XmlCommitException {
            XmlModelUtils.deleteSelection(model, "delete", true);
        }

        protected String computeMultipleSelectionTransactionName(AbstractModel model, int numSelected) {
            String transFormat = model.getTranslatedString("DELETE_DESCRIPTION_MULTIPLE_FORMAT");
            return FastMessageFormat.formatMessage(transFormat, String.valueOf(numSelected));
        }

        protected String computeSingleSelectionTransactionName(AbstractModel model) {
            Selection selection = this.getRelevantSelection(model);
            XmlMetadataResolver resolver = selection.getModel().getXmlMetadataResolver();
            String name = resolver.getMediumDisplayName(selection.getFirstSelectedNode());
            String transFormat = model.getTranslatedString("DELETE_DESCRIPTION_SINGULAR_FORMAT");
            return FastMessageFormat.formatMessage(transFormat, name);
        }

        protected Selection getRelevantSelection(AbstractModel model) {
            return model.getSelection();
        }

        private Task() {
        }

        Task(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

