/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.annotation;

import java.util.Iterator;
import oracle.bali.xml.model.PrecommitOptions;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.annotation.AnnotationCommitException;
import oracle.bali.xml.model.annotation.AnnotationModelEvent;
import oracle.bali.xml.model.annotation.AnnotationModelListener;
import oracle.bali.xml.model.annotation.AnnotationProvider;
import oracle.bali.xml.share.SafeListenerManager;
import oracle.bali.xml.share.TransactionToken;
import org.w3c.dom.Node;

public abstract class AnnotationModel {
    private final SafeListenerManager _listenerManager;
    private final XmlContext _instanceContext;

    public abstract AnnotationProvider getAnnotationProvider(Node var1);

    public abstract void acquireReadLock();

    public abstract void releaseReadLock();

    public abstract void acquireWriteLock();

    public abstract void releaseWriteLock();

    public abstract void startTransaction(String var1);

    public abstract AnnotationCommitException precommitTransaction(PrecommitOptions var1);

    public abstract boolean commitTransaction(TransactionToken var1);

    public abstract void rollbackTransaction();

    public boolean isReadOnly() {
        return this.getInstanceModel().isReadOnly();
    }

    public final void addModelListener(AnnotationModelListener l) {
        this._listenerManager.addListener(l);
    }

    public final void removeModelListener(AnnotationModelListener l) {
        this._listenerManager.removeListener(l);
    }

    protected AnnotationModel(XmlContext instanceContext) {
        this.$init$();
        if (instanceContext == null) {
            throw new IllegalArgumentException("AnnotationModel constructor passed null XmlModel");
        }
        this._instanceContext = instanceContext;
    }

    protected final XmlContext getInstanceContext() {
        return this._instanceContext;
    }

    protected final XmlModel getInstanceModel() {
        return this._instanceContext.getModel();
    }

    protected final void fireAnnotationModelEvent() {
        AnnotationModelEvent e = new AnnotationModelEvent(this);
        this.fireAnnotationModelEvent(e);
    }

    protected final void fireAnnotationModelDeadEvent() {
        AnnotationModelEvent e = new AnnotationModelEvent(this, 1);
        this.fireAnnotationModelEvent(e);
    }

    protected final void fireAnnotationModelEvent(AnnotationModelEvent e) {
        Iterator iter = this._listenerManager.iterator();
        while (iter.hasNext()) {
            AnnotationModelListener listener = (AnnotationModelListener)iter.next();
            listener.annotationModelChanged(e);
        }
    }

    private void $init$() {
        this._listenerManager = new SafeListenerManager();
    }
}

