/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.annotation.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.model.PrecommitOptions;
import oracle.bali.xml.model.PrecommitResults;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.annotation.AnnotationCommitException;
import oracle.bali.xml.model.annotation.AnnotationModel;
import oracle.bali.xml.share.TransactionToken;

public abstract class SideFileAnnotationModel
extends AnnotationModel {
    private static Logger _sLogger = null;
    private final XmlContext _sideFileContext;

    public SideFileAnnotationModel(XmlContext instanceContext, XmlContext sideFileContext) {
        super(instanceContext);
        if (sideFileContext == null) {
            throw new IllegalArgumentException("SideFileAnnotationModel: Passed null side file XmlModel");
        }
        this._sideFileContext = sideFileContext;
    }

    public void acquireReadLock() {
        this.getSideFileModel().acquireReadLock();
    }

    public void releaseReadLock() {
        this.getSideFileModel().releaseReadLock();
    }

    public void acquireWriteLock() {
        this.getSideFileModel().getDomModel().acquireWriteLock();
    }

    public void releaseWriteLock() {
        this.getSideFileModel().getDomModel().releaseWriteLock();
    }

    public void startTransaction(String description) {
        this.getSideFileModel().startTransaction(description);
    }

    public AnnotationCommitException precommitTransaction(PrecommitOptions options) {
        XmlModel model = this.getSideFileModel();
        PrecommitResults precommitResults = this.getSideFileContext().precommitTransaction(model, options);
        if (!precommitResults.precommitSucceeded()) {
            XmlCommitException fatalException = precommitResults.getFatalException();
            return new AnnotationCommitException(this, "SideFileAnnotationModel: Side File PrecommitTransaction Failed (See Chained XmlCommitException)", (Throwable)fatalException);
        }
        return null;
    }

    public boolean commitTransaction(TransactionToken token) {
        boolean stillValid = true;
        try {
            if (token != null) {
                this.getSideFileContext().setTransactionToken(token);
            }
            stillValid = this.getSideFileModel().commitTransaction(false);
        }
        catch (Throwable t) {
            this.getSideFileModel().rollbackTransaction();
            this.getLogger().log(Level.SEVERE, "Unexpected Throwable Caught During SideFileAnnotationModel.commitTransaction()", t);
        }
        return stillValid;
    }

    public void rollbackTransaction() {
        this.getSideFileModel().rollbackTransaction();
    }

    public boolean isReadOnly() {
        return this.getSideFileModel().isReadOnly();
    }

    public final XmlContext getSideFileContext() {
        return this._sideFileContext;
    }

    protected final XmlModel getSideFileModel() {
        return this._sideFileContext.getModel();
    }

    protected final Logger getLogger() {
        if (_sLogger == null) {
            _sLogger = Logger.getLogger(this.getClass().getCanonicalName());
        }
        return _sLogger;
    }
}

