/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.annotation.impl;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.grammar.resolver.GrammarResolverAdapter;
import oracle.bali.xml.grammar.resolver.GrammarResolverEvent;
import oracle.bali.xml.model.annotation.AnnotationGrammar;
import oracle.bali.xml.model.annotation.AnnotationPropertyDef;
import oracle.bali.xml.model.annotation.impl.XmlElementBackedAnnotationPropertyDef;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlGrammarBackedAnnotationGrammar
extends AnnotationGrammar {
    private final GrammarResolver _grammarResolver;
    private final GrammarResolverListener _grammarResolverListener;
    private Map<QualifiedName, AnnotationPropertyDef> _cachedPropertyDefMap;

    public XmlGrammarBackedAnnotationGrammar(GrammarResolver grammarResolver) {
        this._grammarResolver = grammarResolver;
        this._grammarResolverListener = new GrammarResolverListener(null);
        this._grammarResolver.addGrammarResolverListener((oracle.bali.xml.grammar.resolver.GrammarResolverListener)this._grammarResolverListener);
    }

    @Override
    public Map<QualifiedName, AnnotationPropertyDef> getAnnotationPropertyDefMap(Node node) {
        return this.getAllAnnotationPropertyDefs();
    }

    protected final Map<QualifiedName, AnnotationPropertyDef> getAllAnnotationPropertyDefs() {
        if (this._cachedPropertyDefMap == null) {
            LinkedHashMap<QualifiedName, AnnotationPropertyDef> newPropertyDefMap = new LinkedHashMap<QualifiedName, AnnotationPropertyDef>();
            Collection grammars = this._grammarResolver.getGrammars();
            for (Grammar g : grammars) {
                this.addPropertyDefsFromGrammar(newPropertyDefMap, g);
            }
            this._cachedPropertyDefMap = newPropertyDefMap;
        }
        return this._cachedPropertyDefMap;
    }

    protected final void addPropertyDefsFromGrammar(Map<QualifiedName, AnnotationPropertyDef> propertyDefMap, Grammar g) {
        Collection globalElementDefs = g.getElementDefs();
        for (ElementDef globalElementDef : globalElementDefs) {
            this.addPropertyDefForElement(propertyDefMap, globalElementDef);
        }
    }

    protected void addPropertyDefForElement(Map<QualifiedName, AnnotationPropertyDef> propertyDefMap, ElementDef globalElementDef) {
        QualifiedName name = globalElementDef.getQualifiedName();
        propertyDefMap.put(name, new XmlElementBackedAnnotationPropertyDef(globalElementDef));
    }

    protected void handleGrammarResolverInvalidate(GrammarResolverEvent e) {
        this._cachedPropertyDefMap = null;
    }

    protected void handleGrammarResolverChanged(GrammarResolverEvent e) {
    }

    private class GrammarResolverListener
    extends GrammarResolverAdapter {
        public void grammarResolverChanged(GrammarResolverEvent e) {
            XmlGrammarBackedAnnotationGrammar.this.handleGrammarResolverChanged(e);
        }

        public void invalidate(GrammarResolverEvent e) {
            XmlGrammarBackedAnnotationGrammar.this.handleGrammarResolverInvalidate(e);
        }

        private GrammarResolverListener() {
        }

        GrammarResolverListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

