/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.annotation.impl.example;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.annotation.AnnotationProperty;
import oracle.bali.xml.model.annotation.AnnotationProvider;
import oracle.bali.xml.model.annotation.InvalidAnnotationException;
import oracle.bali.xml.model.annotation.impl.example.ExampleAnnotationProperty;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleAnnotationProvider
extends AnnotationProvider {
    private Map<QualifiedName, AnnotationProperty> _annotationPropertyMap;
    private Document _document;
    private Element _annotationElement;
    private XmlModel _annotationXmlModel;
    private String _identifier;

    public ExampleAnnotationProvider(XmlModel annotationXmlModel, Document document, Element annotationElement, String identifier) {
        this.$init$();
        this._annotationXmlModel = annotationXmlModel;
        this._document = document;
        this._annotationElement = annotationElement;
        this._identifier = identifier;
    }

    @Override
    public Map<QualifiedName, AnnotationProperty> getAnnotationPropertyMap() {
        return Collections.unmodifiableMap(this._getPropertyMap());
    }

    @Override
    public AnnotationProperty addAnnotationProperty(QualifiedName name, String initialValue) throws InvalidAnnotationException {
        AnnotationProperty p;
        if (this._annotationElement.getParentNode() == null) {
            Element root = this._document.getDocumentElement();
            try {
                this._annotationXmlModel.insertNode(this._annotationElement, DomPositionFactory.inside((Node)root));
            }
            catch (XmlCommitException e) {
                throw new InvalidAnnotationException(this._identifier, name, initialValue, "Could not add annotation element to annotation document.  See root cause.", e);
            }
        }
        if ((p = this._getPropertyMap().get(name)) == null) {
            Element propertyElement = this._document.createElementNS(name.getNamespace(), name.getName());
            p = new ExampleAnnotationProperty(propertyElement);
            p.setValue(initialValue);
            try {
                this._annotationXmlModel.insertNode(propertyElement, DomPositionFactory.inside((Node)this._annotationElement));
            }
            catch (XmlCommitException e) {
                throw new InvalidAnnotationException(this._identifier, name, initialValue, "Could not add annotation property: " + name + ".  See root cause.", e);
            }
            this._getPropertyMap().put(p.getName(), p);
        } else {
            p.setValue(initialValue);
        }
        return p;
    }

    @Override
    public AnnotationProperty removeAnnotationProperty(QualifiedName name) throws InvalidAnnotationException {
        ExampleAnnotationProperty p = null;
        if (name != null && (p = (ExampleAnnotationProperty)this._getPropertyMap().remove(name)) != null) {
            Element element = p.getElement();
            String value = element.getNodeValue();
            try {
                this._annotationXmlModel.deleteNodes("Removing node: " + element.getNodeName(), Collections.singleton(element), false);
            }
            catch (XmlCommitException e) {
                throw new InvalidAnnotationException(this._identifier, name, value, "Could not remove annotation property: " + name + ".  See root cause.", e);
            }
        }
        return p;
    }

    @Override
    public boolean supportsProperty(QualifiedName name) {
        return true;
    }

    private synchronized Map<QualifiedName, AnnotationProperty> _getPropertyMap() {
        if (this._annotationPropertyMap == null) {
            LinkedHashMap<QualifiedName, AnnotationProperty> newMap = new LinkedHashMap<QualifiedName, AnnotationProperty>();
            Node child = this._annotationElement.getFirstChild();
            while (child != null) {
                if (DomUtils.isElement((Node)child)) {
                    Element propertyElement = (Element)child;
                    ExampleAnnotationProperty p = new ExampleAnnotationProperty(propertyElement);
                    newMap.put(((AnnotationProperty)p).getName(), p);
                }
                child = child.getNextSibling();
            }
            this._annotationPropertyMap = newMap;
        }
        return this._annotationPropertyMap;
    }

    private void $init$() {
        this._annotationPropertyMap = null;
        this._document = null;
        this._annotationElement = null;
        this._annotationXmlModel = null;
        this._identifier = null;
    }
}

