/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.category;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.structured.StructuredMetadataBean;
import oracle.bali.xml.model.category.CategoryDefinition;
import oracle.bali.xml.model.category.IllegalCategoryException;
import oracle.bali.xml.model.category.MutableCategoryDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryDefinitionFactory {
    private static final Logger _LOGGER = Logger.getLogger("oracle.bali.xml.model.category");
    private static final String _MD_NAMESPACE = "http://xmlns.oracle.com/bali/xml/metadata";
    private static final QualifiedName _CATEGORY_DEFINITIONS_QNAME = QualifiedName.getQualifiedName((String)"http://xmlns.oracle.com/bali/xml/metadata", (String)"categoryDefinitions");
    private static final QualifiedName _CATEGORY_QNAME = QualifiedName.getQualifiedName((String)"http://xmlns.oracle.com/bali/xml/metadata", (String)"category");
    private static final QualifiedName _ID_ATTR_QNAME = QualifiedName.getQualifiedName(null, (String)"id");
    private static final QualifiedName _DISPLAY_NAME_QNAME = QualifiedName.getQualifiedName((String)"http://xmlns.oracle.com/bali/xml/metadata", (String)"displayName");
    private static final QualifiedName _DESCRIPTION_QNAME = QualifiedName.getQualifiedName((String)"http://xmlns.oracle.com/bali/xml/metadata", (String)"description");
    private static final QualifiedName _DISPLAY_ORDER_QNAME = QualifiedName.getQualifiedName((String)"http://xmlns.oracle.com/bali/xml/metadata", (String)"displayOrder");
    private static final QualifiedName _SMALL_ICON_QNAME = QualifiedName.getQualifiedName((String)"http://xmlns.oracle.com/bali/xml/metadata", (String)"smallIcon");
    private static final QualifiedName _PREFERRED_PAGE_RANK = QualifiedName.getQualifiedName((String)"http://xmlns.oracle.com/bali/xml/metadata", (String)"preferredPageRank");
    private static final QualifiedName _OPEN_BY_DEFAULT = QualifiedName.getQualifiedName((String)"http://xmlns.oracle.com/bali/xml/metadata", (String)"openByDefault");

    public static MutableCategoryDefinition createMutableCategoryDefinition(String identifier) throws IllegalCategoryException {
        if (identifier == null) {
            throw new IllegalCategoryException("The category identifier cannot be null.");
        }
        return new MutableCategoryDefinition(identifier);
    }

    public static CategoryDefinition createCategoryDefinition(StructuredMetadataBean category) throws IllegalCategoryException {
        if (category == null || !_CATEGORY_QNAME.equals((Object)category.getName())) {
            throw new IllegalCategoryException("Unexpected StructuredMetadataBean passed to createCategoryDefinition: " + category);
        }
        String identifier = category.getProperty(_ID_ATTR_QNAME);
        MutableCategoryDefinition result = CategoryDefinitionFactory.createMutableCategoryDefinition(identifier);
        List children = category.getChildren();
        for (StructuredMetadataBean child : children) {
            QualifiedName childName = child.getName();
            if (_DISPLAY_NAME_QNAME.equals((Object)childName)) {
                String childValue = child.getValue();
                if (childValue == null) continue;
                result.setDisplayName(childValue);
                continue;
            }
            if (_PREFERRED_PAGE_RANK.equals((Object)childName)) {
                String childValue = child.getValue();
                if (childValue == null) continue;
                result.setPreferredPageRank(childValue);
                continue;
            }
            if (_OPEN_BY_DEFAULT.equals((Object)childName)) {
                String childValue = child.getValue();
                if (childValue == null) continue;
                result.setOpenByDefault(childValue);
                continue;
            }
            if (_DESCRIPTION_QNAME.equals((Object)childName)) {
                String childValue = child.getValue();
                if (childValue == null) continue;
                result.setDescription(childValue);
                continue;
            }
            if (_DISPLAY_ORDER_QNAME.equals((Object)childName) || _SMALL_ICON_QNAME.equals((Object)childName) || !_CATEGORY_QNAME.equals((Object)childName)) continue;
            try {
                CategoryDefinition subCategory = CategoryDefinitionFactory.createCategoryDefinition(child);
                if (subCategory == null) continue;
                result.addSubCategoryDefinition(subCategory);
            }
            catch (IllegalCategoryException e) {
                _LOGGER.log(Level.WARNING, "Invalid sub-category definition encountered (and ignored)", e);
            }
            catch (RuntimeException rE) {
                _LOGGER.log(Level.SEVERE, "Unexpected exception encountered while processing sub-category definitions", rE);
            }
        }
        return result;
    }

    public static List<CategoryDefinition> createCategoryDefinitions(StructuredMetadataBean categoryDefinitions) {
        if (categoryDefinitions == null || !_CATEGORY_DEFINITIONS_QNAME.equals((Object)categoryDefinitions.getName())) {
            return Collections.emptyList();
        }
        ArrayList<CategoryDefinition> resultList = new ArrayList<CategoryDefinition>();
        List categoryList = categoryDefinitions.getChildren();
        for (StructuredMetadataBean category : categoryList) {
            try {
                CategoryDefinition result = CategoryDefinitionFactory.createCategoryDefinition(category);
                resultList.add(result);
            }
            catch (IllegalCategoryException e) {
                _LOGGER.log(Level.WARNING, "Invalid category definition encountered (and ignored)", e);
            }
            catch (RuntimeException rE) {
                _LOGGER.log(Level.SEVERE, "Unexpected exception encountered while processing category definitions", rE);
            }
        }
        return resultList;
    }

    public static List<CategoryDefinition> createCategoryDefinitions(List<StructuredMetadataBean> categoryDefinitionsList) {
        ArrayList<CategoryDefinition> resultList = new ArrayList<CategoryDefinition>();
        for (StructuredMetadataBean categoryDefinitions : categoryDefinitionsList) {
            List<CategoryDefinition> partialList = CategoryDefinitionFactory.createCategoryDefinitions(categoryDefinitions);
            resultList.addAll(partialList);
        }
        return resultList;
    }

    private CategoryDefinitionFactory() {
    }
}

