/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.datatransfer;

import java.awt.datatransfer.Transferable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.datatransfer.XmlTransferUtils;
import oracle.bali.xml.share.clipboard.ClipboardManager;
import oracle.javatools.datatransfer.AugmentableTransferable;

public class AugmentingClipboardManager
extends ClipboardManager {
    private Reference _lastFromBaseRef;
    private Reference _lastAugmentedRef;
    private volatile transient boolean _inSetContents;
    private final ClipboardManager _base;
    private final XmlContext _context;
    private final BaseListener _baseListener;

    public AugmentingClipboardManager(XmlContext context, ClipboardManager base) {
        this.$init$();
        this._context = context;
        this._base = base;
    }

    public synchronized Transferable getContents() {
        Transferable fromBase = this._base.getContents();
        Transferable lastFromBase = (Transferable)this._deref(this._lastFromBaseRef);
        Transferable lastAugmented = (Transferable)this._deref(this._lastAugmentedRef);
        if (fromBase == lastFromBase && lastAugmented != null) {
            return lastAugmented;
        }
        AugmentableTransferable nowAugmented = XmlTransferUtils.performAugmentation(fromBase, this._context);
        this._lastFromBaseRef = new SoftReference<Transferable>(fromBase);
        this._lastAugmentedRef = new SoftReference<AugmentableTransferable>(nowAugmented);
        return nowAugmented;
    }

    public synchronized void setContents(Transferable newContents) throws IllegalStateException {
        if (newContents != this._deref(this._lastFromBaseRef)) {
            this._lastFromBaseRef = null;
            this._lastAugmentedRef = null;
        }
        this._inSetContents = true;
        try {
            this._base.setContents(newContents);
        }
        finally {
            this._inSetContents = false;
        }
        this.notifyFlavorListeners();
    }

    private Object _deref(Reference ref) {
        return ref == null ? null : ref.get();
    }

    protected synchronized void areFlavorListenersAttachedChanged() {
        super.areFlavorListenersAttachedChanged();
        if (this.areFlavorListenersAttached()) {
            this._base.addFlavorListener(this._baseListener);
        } else {
            this._base.removeFlavorListener(this._baseListener);
        }
    }

    private void $init$() {
        this._lastFromBaseRef = null;
        this._lastAugmentedRef = null;
        this._inSetContents = false;
        this._baseListener = new BaseListener(null);
    }

    static boolean ra$_inSetContents(AugmentingClipboardManager augmentingClipboardManager) {
        return augmentingClipboardManager._inSetContents;
    }

    static void mav$notifyFlavorListeners(AugmentingClipboardManager augmentingClipboardManager) {
        augmentingClipboardManager.notifyFlavorListeners();
    }

    private class BaseListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            if (!AugmentingClipboardManager.ra$_inSetContents(AugmentingClipboardManager.this)) {
                AugmentingClipboardManager.mav$notifyFlavorListeners(AugmentingClipboardManager.this);
            }
        }

        private BaseListener() {
        }

        BaseListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

