/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.datatransfer.operation;

import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.datatransfer.XmlTransferUtils;
import oracle.bali.xml.model.datatransfer.operation.AbstractPositionTargetingOperation;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.share.TransactionToken;
import oracle.javatools.datatransfer.FetchMode;
import oracle.javatools.datatransfer.TransferDataInfo;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.NodeList;

class CopyOperation
extends AbstractPositionTargetingOperation {
    public boolean apply(AbstractModel model, DomPosition pos, TransferDataInfo data, TransactionToken token) throws IOException, XmlCommitException {
        DocumentFragment fragment = (DocumentFragment)data.getData(FetchMode.STANDARD, false);
        if (fragment != null) {
            String txnName = this.getDisplayName(model, data);
            Collection ret = CopyOperation.__insertNodes(model, pos, fragment, txnName, token);
            return ret != null;
        }
        return false;
    }

    public String getDisplayName(AbstractModel model, TransferDataInfo info) {
        String infoDesc;
        String string = infoDesc = info == null ? null : (String)info.getMetadata(TransferDataInfo.METADATA_MEDIUM_DESCRIPTION);
        if (infoDesc == null) {
            return model.getTranslatedString("DragCopy");
        }
        return model.getTranslatedString("DragCopy_Data", infoDesc);
    }

    public float getSuitabilityRank() {
        return 0.9f;
    }

    public int getSupportedActions() {
        return 1;
    }

    protected DataFlavor getRequiredDataFlavor() {
        return XmlTransferUtils.FLAVOR_DOCUMENTFRAGMENT;
    }

    protected boolean isValidData(AbstractModel model, TransferDataInfo info, Object datum) {
        return super.isValidData(model, info, datum) && (datum == null || datum instanceof DocumentFragment) && XmlTransferUtils.hasOriginalNodesOrRange(info);
    }

    protected boolean isValidPosition(AbstractModel model, DomPosition pos, TransferDataInfo info, Object datum) {
        if (!super.isValidPosition(model, pos, info, datum)) {
            return false;
        }
        return CopyOperation.__isValidPosition(model, pos, info, datum);
    }

    protected DomPosition convertPosition(AbstractModel model, DomPosition originalPos, Object datum) {
        return model.convertInsertionPosition(originalPos);
    }

    static boolean __isValidPosition(AbstractModel model, DomPosition pos, TransferDataInfo info, Object datum) {
        if (!model.getXmlMetadataResolver().canAddChild(pos)) {
            return false;
        }
        if (datum == null) {
            List keys = (List)info.getMetadata(XmlTransferUtils.KEY_XMLKEY_LIST);
            if (keys == null) {
                return true;
            }
            return model.getXmlMetadataResolver().isValidInsertion(pos, keys);
        }
        DocumentFragment fragment = (DocumentFragment)datum;
        return model.getXmlMetadataResolver().isValidInsertion(pos, fragment.getChildNodes());
    }

    static Collection __insertNodes(AbstractModel model, DomPosition pos, DocumentFragment fragment, String txnName, TransactionToken token) throws XmlCommitException {
        Collection[] ret = new Collection[1];
        new 1(txnName, token, fragment, ret, pos).runThrowingXCE(model);
        return ret[0];
    }

    CopyOperation() {
    }

    static final class 1
    extends FixedNameTransactionTask {
        private final /* synthetic */ TransactionToken v$token;
        private final /* synthetic */ DocumentFragment v$fragment;
        private final /* synthetic */ Collection[] v$ret;
        private final /* synthetic */ DomPosition v$pos;

        protected void performTask(AbstractModel model) throws XmlCommitException {
            model.getContext().setTransactionToken(this.v$token);
            DocumentFragment imported = (DocumentFragment)model.getDocument().importNode(this.v$fragment, true);
            this.v$ret[0] = model.insertNodes(this.v$pos, "internal __insertNodes transaction", DomUtils.nodeListToList((NodeList)imported.getChildNodes()), true);
        }

        public 1(String string, TransactionToken transactionToken, DocumentFragment documentFragment, Collection[] collectionArray, DomPosition domPosition) {
            this.v$pos = domPosition;
            this.v$ret = collectionArray;
            this.v$fragment = documentFragment;
            this.v$token = transactionToken;
            super(string);
        }
    }
}

