/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.datatransfer.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.datatransfer.XmlTransferUtils;
import oracle.bali.xml.model.datatransfer.operation.CopyOperation;
import oracle.bali.xml.model.datatransfer.operation.DataAndPositions;
import oracle.bali.xml.model.datatransfer.operation.Operation;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.share.MutableBoolean;
import oracle.bali.xml.share.TransactionToken;
import oracle.javatools.datatransfer.ExtendedTransferable;
import oracle.javatools.datatransfer.FetchMode;
import oracle.javatools.datatransfer.TransferDataInfo;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

class MoveOperation
extends Operation {
    private final CopyOperation _copyOp;
    private static final Logger _LOGGER = Logger.getLogger(MoveOperation.class.getName());

    MoveOperation(CopyOperation copyOp) {
        this._copyOp = copyOp;
    }

    public List getApplicableDataAndPositions(AbstractModel model, List positions, ExtendedTransferable transferable) {
        List fromCopyOp = this._copyOp.getApplicableDataAndPositions(model, positions, transferable);
        if (fromCopyOp.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DataAndPositions> ret = new ArrayList<DataAndPositions>(fromCopyOp.size());
        for (DataAndPositions dataAndPos : fromCopyOp) {
            TransferDataInfo info = dataAndPos.getData();
            AbstractModel sourceModel = XmlTransferUtils.getSourceModel(info);
            Object targetHandledMoveHolder = info.getMetadata(XmlTransferUtils.KEY_TARGET_HANDLED_MOVE);
            if (sourceModel == null || !XmlTransferUtils.hasOriginalNodesOrRange(info) || !(targetHandledMoveHolder instanceof MutableBoolean)) continue;
            Collection originalNodes = XmlTransferUtils.getOriginalNodes(info);
            DomRange originalRange = XmlTransferUtils.getOriginalRange(info);
            List copyPositions = dataAndPos.getPositions();
            ArrayList<DomPosition> movePositions = new ArrayList<DomPosition>(copyPositions.size());
            for (DomPosition pos : copyPositions) {
                if (!this._isValidPosition(model, pos, originalNodes, originalRange)) continue;
                movePositions.add(pos);
            }
            if (movePositions.isEmpty()) continue;
            movePositions.trimToSize();
            ret.add(new DataAndPositions(info, movePositions));
        }
        if (ret.isEmpty()) {
            throw new Operation.RejectOperatingAndDontQueryLowerRankedOps();
        }
        return ret;
    }

    public boolean apply(AbstractModel model, DomPosition pos, TransferDataInfo data, TransactionToken token) throws IOException, XmlCommitException {
        DocumentFragment fragment = (DocumentFragment)data.getData(FetchMode.STANDARD, false);
        AbstractModel sourceModel = XmlTransferUtils.getSourceModel(data);
        MutableBoolean targetHandledMoveHolder = (MutableBoolean)data.getMetadata(XmlTransferUtils.KEY_TARGET_HANDLED_MOVE);
        if (fragment != null && sourceModel != null && XmlTransferUtils.hasOriginalNodesOrRange(data)) {
            boolean internal;
            String txnName = this.getDisplayName(model, data);
            boolean bl = internal = sourceModel.getBaseModel() == model.getBaseModel();
            if (_LOGGER.isLoggable(Level.FINER)) {
                _LOGGER.log(Level.FINER, "Move.apply: {0} at {1} ({2}), data={3}", new Object[]{txnName, pos, internal ? "internal" : "not internal", data});
            }
            return new 1(this, txnName, txnName, pos, fragment, data, token, targetHandledMoveHolder).run(model);
        }
        return false;
    }

    public String getDisplayName(AbstractModel model, TransferDataInfo info) {
        String infoDesc;
        String string = infoDesc = info == null ? null : (String)info.getMetadata(TransferDataInfo.METADATA_MEDIUM_DESCRIPTION);
        if (infoDesc == null) {
            return model.getTranslatedString("DragMove");
        }
        return model.getTranslatedString("DragMove_Data", infoDesc);
    }

    public float getSuitabilityRank() {
        return 0.9f;
    }

    public int getSupportedActions() {
        return 2;
    }

    private boolean _isValidPosition(AbstractModel model, DomPosition pos, Collection originalNodes, DomRange originalRange) {
        TreeTraversal traversal = model.getTreeTraversal();
        if (originalRange != null) {
            if (model.isInModelDocumentHierarchy(originalRange.getStart()) && model.isInModelDocumentHierarchy(originalRange.getEnd())) {
                return originalRange.compareTo(traversal, pos, true) != 0;
            }
        } else {
            Node targetContainer = pos.getContainerNode(traversal);
            for (Node sourceNode : originalNodes) {
                if (!DomUtils.isNodeOrDescendant((TreeTraversal)traversal, (Node)targetContainer, (Node)sourceNode)) continue;
                return false;
            }
            if (originalNodes.size() == 1) {
                Node sourceNext;
                Node sourcePrevious;
                Node sourceParent;
                Node sourceNode = (Node)originalNodes.iterator().next();
                if (pos.getTargetNode() == sourceNode) {
                    return false;
                }
                if (pos.isInside() && (sourceParent = traversal.getParentNode(sourceNode)) == targetContainer && traversal.getLastChild(sourceParent) == sourceNode) {
                    return false;
                }
                if (pos.isAfter() && (sourcePrevious = traversal.getPreviousSibling(sourceNode)) == pos.getTargetNode()) {
                    return false;
                }
                if (pos.isBefore() && (sourceNext = traversal.getNextSibling(sourceNode)) == pos.getTargetNode()) {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean _doMove(String txnName, AbstractModel targetModel, DomPosition pos, DocumentFragment fragment, TransferDataInfo data, TransactionToken token) throws XmlCommitException {
        DomPosition nowDrop;
        DomPosition baseDrop;
        XmlView view;
        DomPosition viewDrop;
        DomRange range = XmlTransferUtils.getOriginalRange(data);
        if (range != null && (pos.equals((Object)range.getStart()) || pos.equals((Object)range.getEnd()))) {
            return false;
        }
        Selection targetSel = targetModel.getSelection();
        DomPosition oldDrop = targetSel.getDropLocation();
        boolean oldDropWasPos = pos.equals((Object)oldDrop);
        targetSel.setDropLocation(pos);
        XmlTransferUtils.removeOriginalNodes(txnName, data, range, XmlTransferUtils.getOriginalNodes(data), token, true);
        if (targetModel instanceof XmlView && (viewDrop = (view = (XmlView)targetModel).modelToView(baseDrop = view.getBaseModel().getSelection().getDropLocation())) != null) {
            targetSel.setDropLocation(viewDrop);
        }
        if ((nowDrop = targetSel.getDropLocation()) == null) {
            return false;
        }
        pos = nowDrop;
        if (!oldDropWasPos && (oldDrop == null || targetModel.isInModelDocumentHierarchy(oldDrop))) {
            targetSel.setDropLocation(oldDrop);
        }
        return this._doCopy(txnName, targetModel, pos, fragment, token);
    }

    private boolean _doCopy(String txnName, AbstractModel targetModel, DomPosition pos, DocumentFragment fragment, TransactionToken token) throws XmlCommitException {
        Collection ret = CopyOperation.__insertNodes(targetModel, pos, fragment, txnName, token);
        return ret != null;
    }

    static boolean mav$_doMove(MoveOperation moveOperation, String string, AbstractModel abstractModel, DomPosition domPosition, DocumentFragment documentFragment, TransferDataInfo transferDataInfo, TransactionToken transactionToken) {
        return moveOperation._doMove(string, abstractModel, domPosition, documentFragment, transferDataInfo, transactionToken);
    }

    final class 1
    extends FixedNameTransactionTask {
        private final /* synthetic */ String v$txnName;
        private final /* synthetic */ DomPosition v$pos;
        private final /* synthetic */ DocumentFragment v$fragment;
        private final /* synthetic */ TransferDataInfo v$data;
        private final /* synthetic */ TransactionToken v$token;
        private final /* synthetic */ MutableBoolean v$targetHandledMoveHolder;
        final /* synthetic */ MoveOperation this$0;

        protected void performTask(AbstractModel model) throws XmlCommitException {
            boolean ok = MoveOperation.mav$_doMove(this.this$0, this.v$txnName, model, this.v$pos, this.v$fragment, this.v$data, this.v$token);
            this.v$targetHandledMoveHolder.set(true);
            if (!ok) {
                this.cancelTask();
            }
        }

        public 1(MoveOperation moveOperation, String string, String string2, DomPosition domPosition, DocumentFragment documentFragment, TransferDataInfo transferDataInfo, TransactionToken transactionToken, MutableBoolean mutableBoolean) {
            this.v$targetHandledMoveHolder = mutableBoolean;
            this.v$token = transactionToken;
            this.v$data = transferDataInfo;
            this.v$fragment = documentFragment;
            this.v$pos = domPosition;
            this.v$txnName = string2;
            this.this$0 = moveOperation;
            super(string);
        }
    }
}

