/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.dependency;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.whitespace.WhitespaceUtils;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.dependency.Declaration;
import oracle.bali.xml.model.dependency.DeclarationFactory;
import oracle.bali.xml.model.dependency.DeclarationFactoryBase;
import oracle.bali.xml.model.dependency.DependencyContext;
import oracle.bali.xml.model.dependency.Reference;
import oracle.bali.xml.model.dependency.ReferenceFactory;
import oracle.bali.xml.model.dependency.XmlDeclaration;
import oracle.bali.xml.model.dependency.XmlReference;
import oracle.javatools.util.ModelUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyUtils {
    private static final Logger _LOGGER = Logger.getLogger(DependencyUtils.class.getName());

    public static ReferenceFactory createWholeValueReferenceFactory(Class<? extends Reference> clazz) {
        return new 1(clazz);
    }

    public static ReferenceFactory createListReferenceFactory(Class<? extends Reference> clazz) {
        return new 2(clazz);
    }

    public static DeclarationFactory createWholeValueDeclarationFactory(Class<? extends Declaration> clazz) {
        return new 3(clazz);
    }

    public static DeclarationFactory createListDeclarationFactory(Class<? extends Declaration> clazz) {
        return new 4(clazz);
    }

    private static Object __createClass(Class clazz, XmlContext context, Node node, int start, int end) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class[] argTypes = new Class[]{XmlContext.class, Node.class, Integer.TYPE, Integer.TYPE};
        Constructor constructor = clazz.getConstructor(argTypes);
        Object[] args = new Object[]{context, node, start, end};
        return constructor.newInstance(args);
    }

    public static String createNodePathString(Node node) {
        int[] pathInts = DomUtils.getPathToNode((Node)node);
        StringBuffer buf = new StringBuffer(pathInts.length * 3);
        int i = 0;
        while (i < pathInts.length) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(String.valueOf(pathInts[i]));
            ++i;
        }
        return buf.toString();
    }

    public static Node getNodefromPath(Document document, String nodePath) {
        if (nodePath != null) {
            String[] indicesStr = nodePath.split(",");
            int[] indices = new int[indicesStr.length];
            try {
                int i = 0;
                while (i < indicesStr.length) {
                    indices[i] = Integer.parseInt(indicesStr[i]);
                    ++i;
                }
            }
            catch (NumberFormatException nfe) {
                Node node = null;
                return node;
            }
            Node node = DomUtils.getNodeFromPath((Document)document, (int[])indices);
            if (node == null) {
                return null;
            }
            return node;
        }
        return null;
    }

    public static Node getNodeFromInfo(XmlContext xmlContext, String nodePath, String attributeNS, String attribute) {
        XmlModel xmlModel = xmlContext.getModel();
        Node node = DependencyUtils.getNodefromPath(xmlModel.getDocument(), nodePath);
        if (attribute != null && !"".equals(attribute)) {
            NamedNodeMap attrs = node.getAttributes();
            node = attrs.getNamedItemNS(attributeNS, attribute);
        }
        return node;
    }

    public static boolean hasReference(XmlContext xmlContext, DomPosition pos) {
        if (pos == null) {
            return false;
        }
        Node node = pos.getTargetNode();
        if (node instanceof CharacterData && !(node instanceof Comment)) {
            node = node.getParentNode();
        } else if (pos.hasAttributeQName()) {
            node = DomUtils.getAttribute((Element)((Element)node), (QualifiedName)pos.getAttributeQName());
        }
        return !DependencyUtils.getReferences(xmlContext, node).isEmpty();
    }

    public static Collection<Reference> getReferences(XmlContext xmlContext, Node node) {
        Collection<Reference> infos;
        String text;
        XmlModel model = xmlContext.getModel();
        ReferenceFactory factory = model.getXmlMetadataResolver().getReferenceFactory(node);
        if (factory != null && ModelUtil.hasLength((String)(text = DependencyUtils.getTextContent(node))) && (infos = factory.getReferences(xmlContext, node, text)) != null) {
            return Collections.unmodifiableCollection(infos);
        }
        return Collections.emptyList();
    }

    public static Collection<Reference> getReferences(XmlContext xmlContext) {
        ArrayList<Reference> allRefs = new ArrayList<Reference>();
        XmlModel model = xmlContext.getModel();
        model.acquireReadLock();
        try {
            TreeTraversal traversal = model.getTreeTraversal();
            for (Node domNode : traversal.allNodes((Node)model.getDocument())) {
                allRefs.addAll(DependencyUtils.getReferences(xmlContext, domNode));
                NamedNodeMap attrs = domNode.getAttributes();
                if (attrs == null) continue;
                int i = 0;
                while (i < attrs.getLength()) {
                    Node attr = attrs.item(i);
                    allRefs.addAll(DependencyUtils.getReferences(xmlContext, attr));
                    ++i;
                }
            }
        }
        finally {
            model.releaseReadLock();
        }
        return allRefs;
    }

    public static Collection<Declaration> getDeclarations(XmlContext xmlContext, Node node) {
        Collection<Declaration> infos;
        String text;
        XmlModel model = xmlContext.getModel();
        DeclarationFactory factory = model.getXmlMetadataResolver().getDeclarationFactory(node);
        if (factory != null && ModelUtil.hasLength((String)(text = DependencyUtils.getTextContent(node))) && (infos = factory.getDeclarations(xmlContext, node, text)) != null) {
            return Collections.unmodifiableCollection(infos);
        }
        return Collections.emptyList();
    }

    public static XmlReference findReferenceContainingPosition(DependencyContext dc, XmlContext context, DomPosition pos) {
        Collection<Reference> infos;
        String text;
        Node node = pos.getTargetNode();
        if (node instanceof CharacterData && !(node instanceof Comment)) {
            node = node.getParentNode();
        } else if (pos.hasAttributeQName()) {
            node = DomUtils.getAttribute((Element)((Element)node), (QualifiedName)pos.getAttributeQName());
        }
        XmlModel model = context.getModel();
        ReferenceFactory factory = model.getXmlMetadataResolver().getReferenceFactory(node);
        if (factory != null && ModelUtil.hasLength((String)(text = DependencyUtils.getTextContent(node))) && (infos = factory.getReferences(context, node, text)) != null) {
            for (Reference ref : infos) {
                XmlReference xmlRef;
                if (!(ref instanceof XmlReference) || (xmlRef = (XmlReference)ref).getDomRange(dc).compareTo((TreeTraversal)DocumentTreeTraversal.INSTANCE, pos, true) != 0) continue;
                return xmlRef;
            }
        }
        return null;
    }

    public static XmlDeclaration findDeclarationContainingPosition(DependencyContext dc, XmlContext context, DomPosition pos) {
        Collection<Declaration> infos;
        String text;
        Node node = pos.getTargetNode();
        if (node instanceof CharacterData) {
            node = node.getParentNode();
        } else if (pos.hasAttributeQName()) {
            node = DomUtils.getAttribute((Element)((Element)node), (QualifiedName)pos.getAttributeQName());
        }
        XmlModel model = context.getModel();
        DeclarationFactory factory = model.getXmlMetadataResolver().getDeclarationFactory(node);
        if (factory != null && ModelUtil.hasLength((String)(text = DependencyUtils.getTextContent(node))) && (infos = factory.getDeclarations(context, node, text)) != null) {
            for (Declaration decl : infos) {
                XmlDeclaration xmlDecl;
                if (!(decl instanceof XmlDeclaration) || (xmlDecl = (XmlDeclaration)decl).getDomRange(dc).compareTo((TreeTraversal)DocumentTreeTraversal.INSTANCE, pos, true) != 0) continue;
                return xmlDecl;
            }
        }
        return null;
    }

    public static XmlDeclaration findDeclarationIncludingAttributes(XmlContext context, DomPosition pos) {
        XmlDeclaration xmlDecl = null;
        Node node = pos.getTargetNode();
        if (node instanceof CharacterData) {
            node = node.getParentNode();
        } else if (pos.hasAttributeQName()) {
            return null;
        }
        Collection<Declaration> decls = DependencyUtils.getDeclarations(context, node);
        for (Declaration decl : decls) {
            if (!(decl instanceof XmlDeclaration)) continue;
            if (xmlDecl != null) {
                return null;
            }
            xmlDecl = (XmlDeclaration)decl;
        }
        if (xmlDecl != null) {
            return xmlDecl;
        }
        if (DomUtils.isElement((Node)node)) {
            NamedNodeMap attrs = node.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                Attr a = (Attr)attrs.item(i);
                decls = DependencyUtils.getDeclarations(context, a);
                for (Declaration decl : decls) {
                    if (!(decl instanceof XmlDeclaration)) continue;
                    if (xmlDecl != null) {
                        return null;
                    }
                    xmlDecl = (XmlDeclaration)decl;
                }
                ++i;
            }
        }
        return xmlDecl;
    }

    public static String getTextContent(Node node) {
        if (DomUtils.isAttribute((Node)node)) {
            return node.getNodeValue();
        }
        if (DomUtils.isElement((Node)node)) {
            String first = null;
            StringBuilder sb = null;
            Node child = node.getFirstChild();
            while (child != null) {
                switch (child.getNodeType()) {
                    case 3: 
                    case 4: {
                        String curValue = child.getNodeValue();
                        if (sb != null) {
                            sb.append(curValue);
                            break;
                        }
                        if (first == null) {
                            first = curValue;
                            break;
                        }
                        sb = new StringBuilder(first.length() + curValue.length());
                        sb.append(first);
                        sb.append(curValue);
                        first = null;
                        break;
                    }
                }
                child = child.getNextSibling();
            }
            if (sb != null) {
                return sb.toString();
            }
            if (first != null) {
                return first;
            }
            return null;
        }
        if (node.getNodeType() == 8) {
            return ((Comment)node).getData();
        }
        return null;
    }

    static DomPosition __getDomPosition(Node node, int textContentIndex) {
        if (DomUtils.isAttribute((Node)node)) {
            return DomPositionFactory.createAttributePosition((Attr)((Attr)node), (int)textContentIndex);
        }
        if (DomUtils.isElement((Node)node)) {
            Node child = node.getFirstChild();
            while (child != null) {
                switch (child.getNodeType()) {
                    case 3: 
                    case 4: {
                        CharacterData cd = (CharacterData)child;
                        int cdLen = cd.getLength();
                        if (cdLen >= textContentIndex) {
                            return DomPositionFactory.createTextPosition((CharacterData)cd, (int)textContentIndex);
                        }
                        textContentIndex -= cdLen;
                        break;
                    }
                }
                child = child.getNextSibling();
            }
            throw new IllegalArgumentException("index " + textContentIndex + " not found in " + node);
        }
        if (node.getNodeType() == 8) {
            return DomPositionFactory.createTextPosition((CharacterData)((Comment)node), (int)textContentIndex);
        }
        throw new IllegalArgumentException("invalid node type passed to __getDomPosition: " + node);
    }

    static Object maS$__createClass(Class clazz, XmlContext xmlContext, Node node, int n, int n2) {
        return DependencyUtils.__createClass(clazz, xmlContext, node, n, n2);
    }

    static Logger ra$_LOGGER() {
        return _LOGGER;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class 1
    extends ReferenceFactory {
        private final /* synthetic */ Class v$clazz;

        @Override
        public Collection<Reference> getReferences(XmlContext context, Node node, String value) {
            Reference reference = null;
            try {
                int end = 0;
                if (value != null) {
                    end = value.length();
                }
                reference = (Reference)DependencyUtils.maS$__createClass(this.v$clazz, context, node, 0, end);
            }
            catch (Exception e) {
                DependencyUtils.ra$_LOGGER().log(Level.WARNING, "Error creating reference for " + this.v$clazz, e);
            }
            if (reference == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(reference);
        }

        public 1(Class clazz) {
            this.v$clazz = clazz;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class 2
    extends ReferenceFactory {
        private final /* synthetic */ Class v$clazz;

        @Override
        public Collection<Reference> getReferences(XmlContext context, Node node, String value) {
            if (value == null) {
                try {
                    Reference reference = (Reference)DependencyUtils.maS$__createClass(this.v$clazz, context, node, 0, 0);
                    List<Reference> list = Collections.singletonList(reference);
                    return list;
                }
                catch (Exception ex) {
                    DependencyUtils.ra$_LOGGER().log(Level.WARNING, "Error creating reference for " + this.v$clazz, ex);
                }
            }
            List<int[]> bounds = WhitespaceUtils.getTokenBoundaries(value);
            ArrayList<Reference> ret = new ArrayList<Reference>(bounds.size());
            for (int[] bound : bounds) {
                Reference reference = null;
                int s = bound[0];
                int e = bound[1];
                try {
                    reference = (Reference)DependencyUtils.maS$__createClass(this.v$clazz, context, node, s, e);
                }
                catch (Exception ex) {
                    DependencyUtils.ra$_LOGGER().log(Level.WARNING, "Error creating reference for " + this.v$clazz, ex);
                }
                if (reference == null) continue;
                ret.add(reference);
            }
            return ret;
        }

        public 2(Class clazz) {
            this.v$clazz = clazz;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class 3
    extends DeclarationFactoryBase {
        private final /* synthetic */ Class v$clazz;

        @Override
        public Collection<Declaration> getDeclarationsImpl(XmlContext context, Node node, String value) {
            Declaration declaration = null;
            try {
                declaration = (Declaration)DependencyUtils.maS$__createClass(this.v$clazz, context, node, 0, value.length());
            }
            catch (Exception e) {
                DependencyUtils.ra$_LOGGER().log(Level.WARNING, "Error creating declaration for " + this.v$clazz, e);
            }
            if (declaration == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(declaration);
        }

        public 3(Class clazz) {
            this.v$clazz = clazz;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class 4
    extends DeclarationFactoryBase {
        private final /* synthetic */ Class v$clazz;

        @Override
        public Collection<Declaration> getDeclarationsImpl(XmlContext context, Node node, String value) {
            List<int[]> bounds = WhitespaceUtils.getTokenBoundaries(value);
            ArrayList<Declaration> ret = new ArrayList<Declaration>(bounds.size());
            for (int[] bound : bounds) {
                Declaration declaration = null;
                int s = bound[0];
                int e = bound[1];
                try {
                    declaration = (Declaration)DependencyUtils.maS$__createClass(this.v$clazz, context, node, s, e);
                }
                catch (Exception ex) {
                    DependencyUtils.ra$_LOGGER().log(Level.WARNING, "Error creating declaration for " + this.v$clazz, ex);
                }
                if (declaration == null) continue;
                ret.add(declaration);
            }
            return ret;
        }

        public 4(Class clazz) {
            this.v$clazz = clazz;
        }
    }
}

