/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.dependency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import oracle.bali.xml.model.dependency.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindUsagesCallback {
    private final ArrayList<Reference> _references;
    private boolean _cancelled;
    private ArrayList<FindUsagesCancelListener> _listeners;
    private String _progressText;
    private int _progress;

    public void addReference(Reference reference) {
        this._references.add(reference);
    }

    public void addReferences(Collection<? extends Reference> references) {
        this._references.addAll(references);
    }

    public List<Reference> getReferences() {
        return Collections.unmodifiableList(this._references);
    }

    public void cancel() {
        this._cancelled = true;
        if (this._listeners != null) {
            for (FindUsagesCancelListener listener : this._listeners) {
                listener.handleCancel();
            }
        }
    }

    public boolean isCancelled() {
        return this._cancelled;
    }

    public final void addCancelListener(FindUsagesCancelListener listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(listener);
    }

    public final boolean removeCancelListener(FindUsagesCancelListener listener) {
        if (this._listeners != null) {
            return this._listeners.remove(listener);
        }
        return false;
    }

    public String getProgressText() {
        return this._progressText;
    }

    public void setProgressText(String progressText) {
        this._progressText = progressText;
    }

    public int getProgress() {
        return this._progress;
    }

    public void setProgress(int progress) {
        this._progress = progress;
    }

    private void $init$() {
        this._references = new ArrayList();
        this._cancelled = false;
        this._progressText = "";
        this._progress = 0;
    }

    public FindUsagesCallback() {
        this.$init$();
    }

    public static interface FindUsagesCancelListener
    extends EventListener {
        public void handleCancel();
    }
}

