/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.dependency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import oracle.javatools.status.Issue;
import oracle.javatools.status.IssueList;
import oracle.javatools.status.Severity;

public class ValidationResult {
    public static final ValidationResult OK = new ValidationResult();
    private ResultIssueList _issuesList;

    public ValidationResult() {
    }

    public ValidationResult(Severity severity, String message) {
        this.addIssue(severity, message);
    }

    public void addIssue(Severity severity, String message) {
        if (this._issuesList == null) {
            this._issuesList = new ResultIssueList();
        }
        this._issuesList.addIssue(new ResultIssue(severity, message));
    }

    public void addIssues(IssueList list) {
        if (this._issuesList == null) {
            this._issuesList = new ResultIssueList();
        }
        for (Issue issue : list) {
            this._issuesList.addIssue(new ResultIssue(issue.getSeverity(), issue.getMessage()));
        }
    }

    public Severity getResult() {
        return this._issuesList != null ? this._issuesList.getSeverity() : Severity.OK;
    }

    public IssueList getIssueList() {
        if (this._issuesList == null) {
            this._issuesList = new ResultIssueList();
        }
        return this._issuesList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class ResultIssue
    implements Issue {
        private Severity _severity;
        private String _message;

        public ResultIssue(Severity severity, String message) {
            this._severity = severity;
            this._message = message;
        }

        public Object getConstruct() {
            return null;
        }

        public String getMessage() {
            return this._message;
        }

        public String getHtmlMessage() {
            return this._message;
        }

        public Severity getSeverity() {
            return this._severity;
        }

        public int getOffset() {
            return 0;
        }

        public int getLength() {
            return 0;
        }

        public boolean hasTransforms() {
            return false;
        }

        public List<? extends Action> getTransforms() {
            return Collections.emptyList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class ResultIssueList
    implements IssueList {
        ArrayList<Issue> _issues;

        public void addIssue(Issue issue) {
            this._issues.add(issue);
        }

        public int size() {
            return this._issues.size();
        }

        public Issue getIssueAt(int index) {
            return this._issues.get(index);
        }

        public Severity getSeverity() {
            Severity current = Severity.OK;
            Iterator<Issue> iterator = this.iterator();
            while (iterator.hasNext()) {
                Issue i = iterator.next();
                if (!Severity.OK.equals((Object)current)) continue;
                if (Severity.WARNING.equals((Object)i.getSeverity())) {
                    current = Severity.WARNING;
                    continue;
                }
                if (!Severity.WARNING.equals((Object)current) || !Severity.ERROR.equals((Object)i.getSeverity())) continue;
                current = Severity.ERROR;
            }
            return current;
        }

        public boolean isStale() {
            return false;
        }

        public int getErrorCount() {
            int count = 0;
            Iterator<Issue> iterator = this.iterator();
            while (iterator.hasNext()) {
                Issue i = iterator.next();
                if (!Severity.ERROR.equals((Object)i.getSeverity())) continue;
                ++count;
            }
            return count;
        }

        public int getWarningCount() {
            int count = 0;
            Iterator<Issue> iterator = this.iterator();
            while (iterator.hasNext()) {
                Issue i = iterator.next();
                if (!Severity.WARNING.equals((Object)i.getSeverity())) continue;
                ++count;
            }
            return count;
        }

        public int getIncompleteCount() {
            int count = 0;
            Iterator<Issue> iterator = this.iterator();
            while (iterator.hasNext()) {
                Issue i = iterator.next();
                if (!Severity.INCOMPLETE.equals((Object)i.getSeverity())) continue;
                ++count;
            }
            return count;
        }

        public int getAdvisoryCount() {
            int count = 0;
            Iterator<Issue> iterator = this.iterator();
            while (iterator.hasNext()) {
                Issue i = iterator.next();
                if (!Severity.ADVISORY.equals((Object)i.getSeverity())) continue;
                ++count;
            }
            return count;
        }

        public Collection<Issue> getOptionalAnalyses() {
            return Collections.emptySet();
        }

        public Iterator<Issue> iterator() {
            return this._issues.iterator();
        }

        private void $init$() {
            this._issues = new ArrayList();
        }

        protected ResultIssueList() {
            this.$init$();
        }
    }
}

