/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.dependency;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.List;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.dependency.CommandResult;
import oracle.bali.xml.model.dependency.DeclarationBase;
import oracle.bali.xml.model.dependency.DependencyContext;
import oracle.bali.xml.model.dependency.DependencyUtils;
import oracle.bali.xml.model.dependency.FindUsagesCallback;
import oracle.bali.xml.model.dependency.Reference;
import oracle.bali.xml.model.dependency.ValueInfo;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.share.TransactionToken;
import oracle.javatools.status.Severity;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public abstract class XmlDeclaration
extends DeclarationBase {
    private WeakReference _weakXmlContext;
    private WeakReference _weakNode;
    private URL _fileUrl;
    private String _nodePath;
    private String _attributeNS;
    private String _attribute;
    private int _start;
    private int _end;

    public XmlDeclaration(XmlContext xmlContext, Node node, int start, int end) {
        this._weakXmlContext = new WeakReference<XmlContext>(xmlContext);
        this._fileUrl = xmlContext.getURL();
        this._weakNode = new WeakReference<Node>(node);
        if (DomUtils.isAttribute((Node)node)) {
            Attr attr = (Attr)node;
            this._attribute = DomUtils.getLocalName((Node)attr);
            String attrNS = attr.getNamespaceURI();
            if (attrNS != null) {
                this._attributeNS = attrNS;
            }
            node = attr.getOwnerElement();
        }
        this._nodePath = DependencyUtils.createNodePathString(node);
        this._start = start;
        this._end = end;
    }

    public DomRange getDomRange(DependencyContext context) {
        Node node = this.getNode(context);
        return DomRange.create((DomPosition)DependencyUtils.__getDomPosition(node, this._start), (DomPosition)DependencyUtils.__getDomPosition(node, this._end), (TreeTraversal)DocumentTreeTraversal.INSTANCE);
    }

    protected boolean supportsRename() {
        return true;
    }

    protected CommandResult renameImpl(DependencyContext context, ValueInfo value) {
        CommandResult result = CommandResult.OK;
        XmlContext xmlContext = this.getXmlContext(context);
        Object prop = context.getTransientProperty("transactionToken");
        TransactionToken token = prop != null ? (TransactionToken)prop : null;
        FindUsagesCallback callback = new FindUsagesCallback();
        this.findUsages(context, callback);
        List<Reference> refs = callback.getReferences();
        boolean didTxn = new 1(this, "Rename operation", token, xmlContext, context, value).run(xmlContext.getModel());
        boolean canUpdate = true;
        Boolean bSkipUpdate = (Boolean)context.getTransientProperty("skipUpdate");
        boolean skipUpdate = bSkipUpdate != null ? bSkipUpdate : false;
        for (Reference ref : refs) {
            CommandResult updateResult;
            if (!ref.supportsCommand("updateReferenceCommand")) {
                canUpdate = false;
                if (skipUpdate) continue;
                String format = xmlContext.getTranslatedString("REFERENCE_NO_UPDATE");
                result.addIssue(Severity.ADVISORY, FastMessageFormat.formatMessage(format, (String)ref.getMetadata(context, "displayNameMetadata")));
                continue;
            }
            if (!canUpdate || (updateResult = ref.performCommand(context, "updateReferenceCommand", value)).getResult() == Severity.OK) continue;
            result.addIssues(updateResult.getIssueList());
            token.setAbortOnCompletion();
            break;
        }
        return result;
    }

    protected boolean supportsGotoSelf() {
        return true;
    }

    protected CommandResult gotoSelfImpl(DependencyContext context) {
        context.gotoDeclRef(this.getXmlContext(context), this.getNode(context));
        return CommandResult.OK;
    }

    protected final XmlContext getXmlContext(DependencyContext context) {
        XmlContext xmlContext = (XmlContext)this._weakXmlContext.get();
        if (xmlContext == null) {
            xmlContext = context.getXmlContext(this._fileUrl);
            this._weakXmlContext = new WeakReference<XmlContext>(xmlContext);
        }
        return xmlContext;
    }

    protected final Node getNode(DependencyContext context) {
        XmlModel model = this.getXmlContext(context).getModel();
        model.acquireReadLock();
        try {
            Node node = (Node)this._weakNode.get();
            if (node == null) {
                node = DependencyUtils.getNodeFromInfo(this.getXmlContext(context), this._nodePath, this._attributeNS, this._attribute);
                this._weakNode = new WeakReference<Node>(node);
            }
            Node node2 = node;
            return node2;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            model.releaseReadLock();
        }
    }

    protected final String getValue(DependencyContext context) {
        XmlModel model = this.getXmlContext(context).getModel();
        model.acquireReadLock();
        try {
            Node node = this.getNode(context);
            String textValue = DomUtils.getTextNodeValue((Node)node);
            String string = textValue.substring(this._start, this._end);
            return string;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            model.releaseReadLock();
        }
    }

    protected final int getStartIndex() {
        return this._start;
    }

    protected final int getEndIndex() {
        return this._end;
    }

    protected final void updateValue(DependencyContext context, ValueInfo value) {
        Node node = this.getNode(context);
        String currValue = DomUtils.getTextNodeValue((Node)node);
        StringBuilder builder = new StringBuilder(currValue);
        builder.replace(this._start, this._end, value.getNewValue());
        if (node instanceof Attr) {
            node.setNodeValue(builder.toString());
        } else {
            DomUtils.setTextNodeValue((Node)node, (String)builder.toString());
        }
        this._end = this._start + value.getNewValue().length();
    }

    final class 1
    extends FixedNameTransactionTask {
        private final /* synthetic */ TransactionToken v$token;
        private final /* synthetic */ XmlContext v$xmlContext;
        private final /* synthetic */ DependencyContext v$context;
        private final /* synthetic */ ValueInfo v$value;
        final /* synthetic */ XmlDeclaration this$0;

        protected void performTask(AbstractModel model) throws XmlCommitException {
            if (this.v$token != null) {
                this.v$xmlContext.setTransactionToken(this.v$token);
            }
            this.this$0.updateValue(this.v$context, this.v$value);
        }

        public 1(XmlDeclaration xmlDeclaration, String string, TransactionToken transactionToken, XmlContext xmlContext, DependencyContext dependencyContext, ValueInfo valueInfo) {
            this.v$value = valueInfo;
            this.v$context = dependencyContext;
            this.v$xmlContext = xmlContext;
            this.v$token = transactionToken;
            this.this$0 = xmlDeclaration;
            super(string);
        }
    }
}

