/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.dependency;

import java.lang.ref.WeakReference;
import java.net.URL;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.dependency.CommandResult;
import oracle.bali.xml.model.dependency.Declaration;
import oracle.bali.xml.model.dependency.DependencyContext;
import oracle.bali.xml.model.dependency.DependencyUtils;
import oracle.bali.xml.model.dependency.ReferenceBase;
import oracle.bali.xml.model.dependency.ValidationResult;
import oracle.bali.xml.model.dependency.ValueInfo;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.share.TransactionToken;
import oracle.javatools.status.Severity;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Node;

public abstract class XmlReference
extends ReferenceBase {
    private WeakReference _weakXmlContext;
    private WeakReference _weakNode;
    private URL _fileUrl;
    private String _nodePath;
    private String _attributeNS;
    private String _attribute;
    private int _start;
    private int _end;

    public XmlReference(XmlContext xmlContext, Node node, int start, int end) {
        this._weakXmlContext = new WeakReference<XmlContext>(xmlContext);
        this._fileUrl = xmlContext.getURL();
        this._weakNode = new WeakReference<Node>(node);
        if (DomUtils.isAttribute((Node)node)) {
            Attr attr = (Attr)node;
            this._attribute = DomUtils.getLocalName((Node)attr);
            String attrNS = attr.getNamespaceURI();
            if (attrNS != null) {
                this._attributeNS = attrNS;
            }
            node = attr.getOwnerElement();
        }
        this._nodePath = DependencyUtils.createNodePathString(node);
        this._start = start;
        this._end = end;
    }

    public ValidationResult validateDeclaration(DependencyContext context, Declaration declaration) {
        if (declaration != null) {
            return ValidationResult.OK;
        }
        String value = this.getValue(context);
        String msg = value != null && !"".equals(value) ? String.format("Reference %s not found", value) : "Reference not found";
        return new ValidationResult(Severity.WARNING, msg);
    }

    public DomRange getDomRange(DependencyContext context) {
        Node node = this.getNode(context);
        return DomRange.create((DomPosition)DependencyUtils.__getDomPosition(node, this._start), (DomPosition)DependencyUtils.__getDomPosition(node, this._end), (TreeTraversal)DocumentTreeTraversal.INSTANCE);
    }

    protected boolean supportsUpdateReference() {
        return true;
    }

    protected CommandResult updateReferenceImpl(DependencyContext context, ValueInfo value) {
        boolean didTxn = new 1(this, "Update reference", context, value).run(this.getXmlContext(context).getModel());
        return CommandResult.OK;
    }

    protected boolean supportsGotoSelf() {
        return true;
    }

    protected CommandResult gotoSelfImpl(DependencyContext context) {
        context.gotoDeclRef(this.getXmlContext(context), this.getNode(context));
        return CommandResult.OK;
    }

    protected final XmlContext getXmlContext(DependencyContext context) {
        XmlContext xmlContext = (XmlContext)this._weakXmlContext.get();
        if (xmlContext == null) {
            xmlContext = context.getXmlContext(this._fileUrl);
            this._weakXmlContext = new WeakReference<XmlContext>(xmlContext);
        }
        return xmlContext;
    }

    protected final Node getNode(DependencyContext context) {
        XmlModel model = this.getXmlContext(context).getModel();
        model.acquireReadLock();
        try {
            Node node = (Node)this._weakNode.get();
            if (node == null) {
                node = DependencyUtils.getNodeFromInfo(this.getXmlContext(context), this._nodePath, this._attributeNS, this._attribute);
                this._weakNode = new WeakReference<Node>(node);
            }
            Node node2 = node;
            return node2;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            model.releaseReadLock();
        }
    }

    protected final String getValue(DependencyContext context) {
        XmlModel model = this.getXmlContext(context).getModel();
        model.acquireReadLock();
        try {
            Node node = this.getNode(context);
            String textValue = node.getNodeType() == 8 ? ((Comment)node).getData() : DomUtils.getTextNodeValue((Node)node);
            String string = textValue.substring(this._start, this._end);
            return string;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            model.releaseReadLock();
        }
    }

    protected final int getStartIndex() {
        return this._start;
    }

    protected final int getEndIndex() {
        return this._end;
    }

    protected final URL getFileURL() {
        return this._fileUrl;
    }

    protected void updateValue(DependencyContext context, ValueInfo value) {
        Node node = this.getNode(context);
        String currValue = node.getNodeType() == 8 ? ((Comment)node).getData() : DomUtils.getTextNodeValue((Node)node);
        StringBuilder builder = new StringBuilder(currValue);
        builder.replace(this._start, this._end, value.getNewValue());
        if (node instanceof Attr) {
            node.setNodeValue(builder.toString());
        } else if (node.getNodeType() == 8) {
            ((Comment)node).setData(builder.toString());
        } else {
            DomUtils.setTextNodeValue((Node)node, (String)builder.toString());
        }
        this._end = this._start + value.getNewValue().length();
    }

    final class 1
    extends FixedNameTransactionTask {
        private final /* synthetic */ DependencyContext v$context;
        private final /* synthetic */ ValueInfo v$value;
        final /* synthetic */ XmlReference this$0;

        protected void performTask(AbstractModel model) throws XmlCommitException {
            Object prop = this.v$context.getTransientProperty("transactionToken");
            if (prop != null) {
                model.getContext().setTransactionToken((TransactionToken)prop);
            }
            this.this$0.updateValue(this.v$context, this.v$value);
        }

        public 1(XmlReference xmlReference, String string, DependencyContext dependencyContext, ValueInfo valueInfo) {
            this.v$value = valueInfo;
            this.v$context = dependencyContext;
            this.this$0 = xmlReference;
            super(string);
        }
    }
}

