/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.message;

import java.util.Comparator;
import oracle.bali.xml.model.message.XmlModelMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagePositionComparator
implements Comparator {
    public static final Comparator INSTANCE = new MessagePositionComparator();

    public int compare(Object o1, Object o2) {
        this._check(o1);
        this._check(o2);
        XmlModelMessage m1 = (XmlModelMessage)o1;
        XmlModelMessage m2 = (XmlModelMessage)o2;
        int start1 = m1.getTextStartOffset();
        int start2 = m2.getTextStartOffset();
        if (start1 == -1) {
            if (start2 == -1) {
                return 0;
            }
            return 1;
        }
        if (start2 == -1) {
            return -1;
        }
        if (start1 > start2) {
            return -1;
        }
        if (start2 > start1) {
            return 1;
        }
        int end1 = m1.getTextEndOffset();
        int end2 = m2.getTextEndOffset();
        if (end1 < 0) {
            end1 = start1;
        }
        if (end2 < 0) {
            end2 = start2;
        }
        return end1 - end2;
    }

    private void _check(Object o) {
        if (!(o instanceof XmlModelMessage)) {
            throw new IllegalArgumentException(o + " is not an XmlModelMessage!");
        }
    }

    private MessagePositionComparator() {
    }
}

