/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.message.MessageCategory;
import oracle.bali.xml.model.message.SimpleMessage;
import oracle.bali.xml.model.message.ValidationExceptionMessage;
import oracle.bali.xml.model.message.XmlModelMessage;
import oracle.bali.xml.validator.ValidationException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationHandler
implements ErrorHandler {
    private Level _highestLevel;
    private final List<XmlModelMessage> _messages;
    private final MessageCategory _category;
    private final XmlModel _model;
    private final List<XmlModelMessage> _immutableMessages;

    public ValidationHandler(XmlModel model, MessageCategory category) {
        this.$init$();
        this._model = model;
        this._category = category;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        Level level = XmlModelMessage.WARNING;
        if (this._isWarningActuallyInfo(exception)) {
            level = XmlModelMessage.INFO;
        }
        this._create(exception, level);
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this._create(exception, XmlModelMessage.ERROR);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this._create(exception, XmlModelMessage.ERROR);
    }

    public Level getHighestLevel() {
        return this._highestLevel;
    }

    public List<XmlModelMessage> getMessages() {
        return this._immutableMessages;
    }

    public boolean isEmpty() {
        return this._messages.isEmpty();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (XmlModelMessage obj : this._messages) {
            if (obj == null) continue;
            buf.append(obj);
            buf.append("\n");
        }
        return buf.toString();
    }

    private boolean _isWarningActuallyInfo(SAXParseException exception) {
        ValidationException valEx;
        int exType;
        return exception instanceof ValidationException && (exType = (valEx = (ValidationException)exception).getType()) == 11;
    }

    private void _create(SAXParseException exception, Level level) {
        XmlModelMessage msg = exception instanceof ValidationException ? new ValidationExceptionMessage(this._model, (ValidationException)exception, level) : new SimpleMessage(this._model, this._category, level, exception.getLocalizedMessage(), exception);
        this._messages.add(msg);
        if (level.intValue() > this._highestLevel.intValue()) {
            this._highestLevel = level;
        }
    }

    private void $init$() {
        this._highestLevel = Level.FINEST;
        this._messages = new ArrayList<XmlModelMessage>();
        this._immutableMessages = Collections.unmodifiableList(this._messages);
    }
}

