/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.bali.xml.model.message.MessageCategory;
import oracle.bali.xml.model.message.XmlModelMessage;
import oracle.bali.xml.share.CollectionCollectionIterator;
import oracle.javatools.status.Issue;
import oracle.javatools.status.IssueList;
import oracle.javatools.status.Severity;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlModelMessageLog
implements IssueList {
    private final Map<MessageCategory, List<XmlModelMessage>> _messages;
    private List<XmlModelMessage> _flattenedMessages;
    private int _errorCount;
    private int _warningCount;

    public XmlModelMessageLog(List<XmlModelMessage> parseMessages, List<XmlModelMessage> validationMessages) {
        HashMap<MessageCategory, List<XmlModelMessage>> mutable = new HashMap<MessageCategory, List<XmlModelMessage>>(7);
        this._addMessages(mutable, MessageCategory.PARSING, parseMessages);
        this._addMessages(mutable, MessageCategory.GRAMMAR_VALIDITY, validationMessages);
        this._messages = Collections.unmodifiableMap(mutable);
    }

    public XmlModelMessageLog(Map<MessageCategory, List<XmlModelMessage>> messages) {
        HashMap<MessageCategory, List<XmlModelMessage>> mutable = new HashMap<MessageCategory, List<XmlModelMessage>>(messages.size());
        for (Map.Entry<MessageCategory, List<XmlModelMessage>> mEntry : messages.entrySet()) {
            MessageCategory category = mEntry.getKey();
            List<XmlModelMessage> messageList = mEntry.getValue();
            this._addMessages(mutable, category, messageList);
        }
        this._messages = Collections.unmodifiableMap(mutable);
    }

    public XmlModelMessageLog() {
        this._messages = Collections.emptyMap();
    }

    public List<XmlModelMessage> getMessages(MessageCategory category) {
        List<XmlModelMessage> ret = this._messages.get(category);
        if (ret != null) {
            return ret;
        }
        return Collections.emptyList();
    }

    public Map<MessageCategory, List<XmlModelMessage>> getMessagesMap() {
        return this._messages;
    }

    public int size() {
        return this._flattenedMessages != null ? this._flattenedMessages.size() : 0;
    }

    public Issue getIssueAt(int index) {
        return this._flattenedMessages != null ? this._flattenedMessages.get(index) : null;
    }

    public Severity getSeverity() {
        if (this.getErrorCount() > 0) {
            return Severity.ERROR;
        }
        if (this.getWarningCount() > 0) {
            return Severity.WARNING;
        }
        return Severity.OK;
    }

    public boolean isStale() {
        return false;
    }

    public int getErrorCount() {
        return this._errorCount;
    }

    public int getWarningCount() {
        return this._warningCount;
    }

    public int getIncompleteCount() {
        return 0;
    }

    public int getAdvisoryCount() {
        return 0;
    }

    public List<Issue> getOptionalAnalyses() {
        return Collections.emptyList();
    }

    public Iterator<Issue> iterator() {
        return new CollectionCollectionIterator<Issue>(this._messages.values());
    }

    public List<XmlModelMessage> getNodeMessageList(Node node) {
        List<XmlModelMessage> nodeMessages = Collections.emptyList();
        if (node == null) {
            return nodeMessages;
        }
        for (List<XmlModelMessage> l : this.getMessagesMap().values()) {
            for (XmlModelMessage message : l) {
                if (message.getRelatedNode() != node) continue;
                if (nodeMessages.isEmpty()) {
                    nodeMessages = new ArrayList<XmlModelMessage>();
                }
                nodeMessages.add(message);
            }
        }
        return nodeMessages;
    }

    public XmlModelMessageLog getUpdatedLog(MessageCategory category, List<XmlModelMessage> list) {
        HashMap<MessageCategory, List<XmlModelMessage>> map = new HashMap<MessageCategory, List<XmlModelMessage>>(this._messages);
        if (list == null || list.isEmpty()) {
            map.remove(category);
        } else {
            map.put(category, list);
        }
        return new XmlModelMessageLog(map);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (List<XmlModelMessage> xmlModelMessages : this._messages.values()) {
            this._toString(buf, xmlModelMessages);
        }
        return buf.toString();
    }

    private void _toString(StringBuffer buf, List<XmlModelMessage> messages) {
        for (XmlModelMessage aL : messages) {
            buf.append(aL);
            buf.append("\n");
        }
    }

    private void _addMessages(Map<MessageCategory, List<XmlModelMessage>> map, MessageCategory cat, List<XmlModelMessage> list) {
        if (list != null && !list.isEmpty()) {
            map.put(cat, list);
        }
        if (this._flattenedMessages == null) {
            this._flattenedMessages = new ArrayList<XmlModelMessage>();
        }
        this._flattenedMessages.addAll(list);
        this._countMessages(list);
    }

    private void _countMessages(List<XmlModelMessage> messages) {
        for (XmlModelMessage message : messages) {
            if (message.isError()) {
                ++this._errorCount;
                continue;
            }
            if (!message.isWarning()) continue;
            ++this._warningCount;
        }
    }
}

