/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.metadata.refinfo.java;

import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.metadata.refinfo.RefInfo;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.validator.ValidationException;
import org.w3c.dom.Node;

public abstract class JavaInfo
extends RefInfo {
    public static final int VALIDATION_ERROR_CLASS_EMPTY = 130;
    public static final int VALIDATION_WARNING_CLASS_EMPTY = 131;
    public static final int VALIDATION_ERROR_CLASS_NOT_FOUND = 132;
    public static final int VALIDATION_WARNING_CLASS_NOT_FOUND = 133;
    public static final int VALIDATION_ERROR_CLASS_NO_MATCH = 134;
    public static final int VALIDATION_WARNING_CLASS_NO_MATCH = 135;
    public static final int VALIDATION_ERROR_METHOD_EMPTY = 136;
    public static final int VALIDATION_WARNING_METHOD_EMPTY = 137;
    public static final int VALIDATION_ERROR_METHOD_NOT_FOUND = 138;
    public static final int VALIDATION_WARNING_METHOD_NOT_FOUND = 139;
    public static final int VALIDATION_ERROR_PROPERTY_EMPTY = 140;
    public static final int VALIDATION_WARNING_PROPERTY_EMPTY = 141;
    public static final int VALIDATION_ERROR_PROPERTY_NOT_FOUND = 142;
    public static final int VALIDATION_WARNING_PROPERTY_NOT_FOUND = 143;
    private static final String _ARRAY_IDENTIFIER = "[]";

    public void goToDeclaration(XmlContext context, Node node) {
        context.getRefInfoResolver().goToDeclaration(context, node, this);
    }

    protected boolean isArray(String className) {
        return className != null && className.endsWith(_ARRAY_IDENTIFIER);
    }

    protected boolean isBuiltInType(String className) {
        if (this.isArray(className)) {
            className = this._getArrayType(className);
        }
        return "int".equals(className) || "float".equals(className) || "double".equals(className) || "byte".equals(className) || "boolean".equals(className) || "short".equals(className) || "long".equals(className) || "char".equals(className);
    }

    protected void validateClassName(XmlContext context, Node n, String className, int errorLevel) throws ValidationException {
        boolean found;
        if (className == null || "".equals(className)) {
            String format = context.getTranslatedString("CLASS_EMPTY");
            int type = errorLevel == 0 ? 130 : 131;
            ValidationException ve = new ValidationException(type, format, n);
            ve.setRelatedObject((Object)this);
            throw ve;
        }
        if (!this.isDatabound(context, n) && !(found = context.getRefInfoResolver().classExists(context, className))) {
            String format = context.getTranslatedString("CLASS_NOT_FOUND");
            int type = errorLevel == 0 ? 132 : 133;
            ValidationException ve = new ValidationException(type, FastMessageFormat.formatMessage(format, className), n);
            ve.setRelatedObject((Object)this);
            throw ve;
        }
    }

    protected void validateClassName(XmlContext context, Node n, String className, String baseType, int errorLevel) throws ValidationException {
        this.validateClassName(context, n, className, errorLevel);
        if (!this.isDatabound(context, n) && !context.getRefInfoResolver().classMatchesType(context, className, baseType)) {
            String format = context.getTranslatedString("CLASS_NO_MATCH");
            int type = errorLevel == 0 ? 134 : 135;
            ValidationException ve = new ValidationException(type, FastMessageFormat.formatMessage(format, className, baseType), n);
            ve.setRelatedObject((Object)this);
            throw ve;
        }
    }

    private String _getArrayType(String className) {
        if (className != null && className.endsWith(_ARRAY_IDENTIFIER)) {
            return className.substring(0, className.length() - _ARRAY_IDENTIFIER.length());
        }
        return className;
    }
}

