/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.metadata.refinfo.java;

import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.metadata.refinfo.java.SingleClassJavaInfo;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.validator.ValidationException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MultipleBaseTypeJavaInfo
extends SingleClassJavaInfo {
    private String[] _classTypes;
    private int _errorLevel;

    public MultipleBaseTypeJavaInfo() {
        this(null, 2);
    }

    public MultipleBaseTypeJavaInfo(String[] baseTypes) {
        this(baseTypes, 2);
    }

    public MultipleBaseTypeJavaInfo(String[] baseTypes, int errorLevel) {
        this._classTypes = baseTypes;
        this._errorLevel = errorLevel;
    }

    public String[] getBaseTypes() {
        return this._classTypes;
    }

    public int getErrorLevel() {
        return this._errorLevel;
    }

    public String getFullyQualifiedClassName(Node node) {
        if (node.getNodeType() == 2) {
            return node.getNodeValue();
        }
        if (node.getNodeType() == 1) {
            return DomUtils.getTextNodeValue((Node)node);
        }
        throw new IllegalArgumentException("MultipleBaseTypeJavaInfo is being used with something other than element or attribute");
    }

    public void setFullyQualifiedClassName(Node node, String oldName, String newName) {
        if (node.getNodeType() == 2) {
            node.setNodeValue(newName);
        } else if (node.getNodeType() == 1) {
            NodeList children = node.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                String value;
                Node child = children.item(i);
                if (child.getNodeType() == 3 && (value = child.getNodeValue()).indexOf(oldName) != -1) {
                    value = value.replaceAll(oldName, newName);
                    child.setNodeValue(value);
                }
                ++i;
            }
        }
        throw new IllegalArgumentException("SimpleClassJavaInfo is being used with something other than element or attribute");
    }

    public void validate(XmlContext context, Node n) throws ValidationException {
        if (this.getErrorLevel() == 2) {
            return;
        }
        String className = this.getFullyQualifiedClassName(n);
        String[] baseTypes = this.getBaseTypes();
        this._validateClassName(context, n, className, baseTypes, this.getErrorLevel());
    }

    public boolean canGoToDeclaration(XmlContext context, Node node) {
        String name = this.getFullyQualifiedClassName(node);
        if (this.isBuiltInType(name)) {
            return false;
        }
        return context.getRefInfoResolver().classExists(context, name);
    }

    public void validate(XmlContext context, Node n, Object newValue) throws ValidationException {
        if (this.getErrorLevel() == 0) {
            this._validateClassName(context, n, (String)newValue, this.getBaseTypes(), this.getErrorLevel());
        }
    }

    private void _validateClassName(XmlContext context, Node n, String className, String[] baseTypes, int level) throws ValidationException {
        if (baseTypes != null && baseTypes.length != 0) {
            this.validateClassName(context, n, className, level);
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < baseTypes.length) {
                if (context.getRefInfoResolver().classMatchesType(context, className, baseTypes[i])) {
                    return;
                }
                sb.append(baseTypes[i]);
                ++i;
            }
            String format = context.getTranslatedString("MULTIPLE_BASE_CLASS_NO_MATCH");
            int type = level == 0 ? 134 : 135;
            ValidationException ve = new ValidationException(type, FastMessageFormat.formatMessage(format, className, sb.toString()), n);
            ve.setRelatedObject((Object)this);
            throw ve;
        }
        this.validateClassName(context, n, className, null, level);
    }
}

