/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.metadata.refinfo.java;

import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.metadata.refinfo.java.JavaInfo;
import oracle.bali.xml.validator.ValidationException;
import org.w3c.dom.Node;

public abstract class MultipleClassJavaInfo
extends JavaInfo {
    private String _classType;
    private int _errorLevel;

    protected abstract String[] getFullyQualifiedClassNames(String var1);

    public abstract void setFullyQualifiedClassName(Node var1, String var2, String var3);

    public MultipleClassJavaInfo() {
        this(null, 2);
    }

    public MultipleClassJavaInfo(String baseType) {
        this(baseType, 2);
    }

    public MultipleClassJavaInfo(String baseType, int errorLevel) {
        this._classType = baseType;
        this._errorLevel = errorLevel;
    }

    public String getBaseType() {
        return this._classType;
    }

    public int getErrorLevel() {
        return this._errorLevel;
    }

    public void validate(XmlContext context, Node n) throws ValidationException {
        if (this.getErrorLevel() == 2) {
            return;
        }
        String s = this._getNodeValue(n);
        if (s == null) {
            return;
        }
        String[] names = this.getFullyQualifiedClassNames(s);
        this._validateNames(context, n, names, this.getBaseType());
    }

    public boolean canGoToDeclaration(XmlContext context, Node node) {
        return false;
    }

    public void validate(XmlContext context, Node n, Object newValue) throws ValidationException {
        if (this.getErrorLevel() == 0) {
            this._validateNames(context, n, this.getFullyQualifiedClassNames((String)newValue), this.getBaseType());
        }
    }

    public final String[] getFullyQualifiedClassNames(Node node) {
        String s = this._getNodeValue(node);
        if (s == null) {
            return null;
        }
        return this.getFullyQualifiedClassNames(s);
    }

    private void _validateNames(XmlContext context, Node n, String[] classNames, String baseType) throws ValidationException {
        if (classNames == null || classNames.length == 0) {
            String format = context.getTranslatedString("MULTIPLE_CLASS_EMPTY");
            int type = this.getErrorLevel() == 0 ? 130 : 131;
            ValidationException ve = new ValidationException(type, format, n);
            ve.setRelatedObject((Object)this);
            throw ve;
        }
        int i = 0;
        while (i < classNames.length) {
            this.validateClassName(context, n, classNames[i], baseType, this.getErrorLevel());
            ++i;
        }
    }

    private String _getNodeValue(Node node) {
        if (node.getNodeType() == 2) {
            return node.getNodeValue();
        }
        if (node.getNodeType() == 1) {
            return DomUtils.getTextNodeValue((Node)node);
        }
        return null;
    }
}

