/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.metadata.refinfo.java;

import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.metadata.refinfo.RefInfoResolver;
import oracle.bali.xml.model.metadata.refinfo.java.SingleClassJavaInfo;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.validator.ValidationException;
import org.w3c.dom.Node;

public abstract class PropertyJavaInfo
extends SingleClassJavaInfo {
    public abstract String getPropertyName(Node var1);

    public abstract String getPropertyType(XmlContext var1, Node var2);

    public boolean canGoToDeclaration(XmlContext context, Node node) {
        return context.getRefInfoResolver().propertyExists(context, this.getFullyQualifiedClassName(node), this.getPropertyName(node), this.getPropertyType(context, node));
    }

    public void validate(XmlContext context, Node n) throws ValidationException {
        String propertyName = this.getPropertyName(n);
        this.validatePropertyName(context, n, propertyName, this.getErrorLevel());
    }

    public void validate(XmlContext context, Node node, Object newValue) throws ValidationException {
        this.validatePropertyName(context, node, (String)newValue, this.getErrorLevel());
    }

    protected void validatePropertyName(XmlContext context, Node n, String propertyName, int errorLevel) throws ValidationException {
        if (errorLevel == 2) {
            return;
        }
        RefInfoResolver rir = context.getRefInfoResolver();
        String className = this.getFullyQualifiedClassName(n);
        this.validateClassName(context, n, className, errorLevel);
        if (propertyName == null || "".equals(propertyName)) {
            String format = context.getTranslatedString("PROPERTY_EMPTY");
            int type = errorLevel == 0 ? 140 : 141;
            ValidationException ve = new ValidationException(type, format, n);
            ve.setRelatedObject((Object)this);
            throw ve;
        }
        if (!this.isDatabound(context, n) && !rir.propertyExists(context, className, propertyName, this.getPropertyType(context, n))) {
            String format = context.getTranslatedString("PROPERTY_NOT_FOUND");
            int type = errorLevel == 0 ? 142 : 143;
            ValidationException ve = new ValidationException(type, FastMessageFormat.formatMessage(format, propertyName, className), n);
            ve.setRelatedObject((Object)this);
            throw ve;
        }
    }
}

