/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.metadata.refinfo.java;

import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.metadata.refinfo.java.SingleClassJavaInfo;
import oracle.bali.xml.validator.ValidationException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimpleClassJavaInfo
extends SingleClassJavaInfo {
    private String _classType;
    private int _errorLevel;

    public SimpleClassJavaInfo() {
        this(null, 2);
    }

    public SimpleClassJavaInfo(String baseType) {
        this(baseType, 2);
    }

    public SimpleClassJavaInfo(String baseType, int errorLevel) {
        this._classType = baseType;
        this._errorLevel = errorLevel;
    }

    public String getBaseType() {
        return this._classType;
    }

    public int getErrorLevel() {
        return this._errorLevel;
    }

    public String getFullyQualifiedClassName(Node node) {
        if (node.getNodeType() == 2) {
            return node.getNodeValue();
        }
        if (node.getNodeType() == 1) {
            return DomUtils.getTextNodeValue((Node)node);
        }
        throw new IllegalArgumentException("SimpleClassJavaInfo is being used with something other than element or attribute");
    }

    public void setFullyQualifiedClassName(Node node, String oldName, String newName) {
        if (node.getNodeType() == 2) {
            node.setNodeValue(newName);
        } else if (node.getNodeType() == 1) {
            NodeList children = node.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                String value;
                Node child = children.item(i);
                if (child.getNodeType() == 3 && (value = child.getNodeValue()).indexOf(oldName) != -1) {
                    value = value.replaceAll(oldName, newName);
                    child.setNodeValue(value);
                }
                ++i;
            }
        } else {
            throw new IllegalArgumentException("SimpleClassJavaInfo is being used with something other than element or attribute");
        }
    }

    public void validate(XmlContext context, Node n) throws ValidationException {
        if (this.getErrorLevel() == 2) {
            return;
        }
        String className = this.getFullyQualifiedClassName(n);
        this.validateClassName(context, n, className, this.getBaseType(), this.getErrorLevel());
    }

    public boolean canGoToDeclaration(XmlContext context, Node node) {
        String name = this.getFullyQualifiedClassName(node);
        if (this.isBuiltInType(name)) {
            return false;
        }
        return context.getRefInfoResolver().classExists(context, name);
    }

    public void validate(XmlContext context, Node n, Object newValue) throws ValidationException {
        if (this.getErrorLevel() == 0) {
            this.validateClassName(context, n, (String)newValue, this.getBaseType(), this.getErrorLevel());
        }
    }
}

