/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.metadata.refinfo.uri;

import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.metadata.refinfo.uri.RootRelativeURIInfo;
import oracle.bali.xml.model.metadata.refinfo.uri.URIInfo;
import oracle.bali.xml.validator.ValidationException;
import org.w3c.dom.Node;

public abstract class MultiplexingURIInfo
extends URIInfo {
    protected MultiplexingURIInfo(int errorLevel) {
        super(errorLevel);
    }

    public void validate(XmlContext context, Node node) throws ValidationException {
        this._validate(context, node, MultiplexingURIInfo.__getValue(node));
    }

    public void validate(XmlContext context, Node node, Object newValue) throws ValidationException {
        this._validate(context, node, this.__convertToString(newValue));
    }

    public boolean canGoToDeclaration(XmlContext context, Node node) {
        URIInfo[] list = this.getURIInfos();
        int i = 0;
        while (i < list.length) {
            if (list[i].canGoToDeclaration(context, node)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void goToDeclaration(XmlContext context, Node node) {
        URIInfo[] list = this.getURIInfos();
        int i = 0;
        while (i < list.length) {
            if (list[i].canGoToDeclaration(context, node)) {
                list[i].goToDeclaration(context, node);
                return;
            }
            ++i;
        }
    }

    protected abstract URIInfo[] getURIInfos();

    private void _validate(XmlContext context, Node node, String uri) throws ValidationException {
        if (uri == null || "".equals(uri)) {
            String message = context.getTranslatedString("URI_EMPTY");
            throw new ValidationException(200, message, node);
        }
        if (!this.isDatabound(context, node)) {
            URIInfo[] infos = this.getURIInfos();
            ValidationException error = null;
            int i = 0;
            while (i < infos.length) {
                try {
                    if (infos[i] instanceof RootRelativeURIInfo) {
                        RootRelativeURIInfo rri = (RootRelativeURIInfo)infos[i];
                        rri.__validate(context, node, rri.getRootURL(context), uri);
                    } else {
                        infos[i].validate(context, node, uri);
                    }
                    error = null;
                    break;
                }
                catch (ValidationException ve) {
                    if (error == null) {
                        error = ve;
                    }
                    ++i;
                }
            }
            if (error != null) {
                throw error;
            }
        }
    }
}

