/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.metadata.refinfo2.url;

import java.net.URL;
import java.util.Collection;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.metadata.refinfo2.Severity;
import oracle.bali.xml.model.metadata.refinfo2.url.UrlRefInfo2;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleUrlRefInfo2
extends UrlRefInfo2 {
    private final Object _baseTypeKey;
    private final Severity _severity;

    public SimpleUrlRefInfo2(Object baseTypeKey, Severity severity) {
        this._baseTypeKey = baseTypeKey;
        if (severity == null) {
            severity = Severity.WARNING;
        }
        this._severity = severity;
    }

    @Override
    protected URL getUrlForValue(XmlModel model, Node node, String value) {
        URL base;
        XmlContext context = model.getContext();
        if (this._baseTypeKey != null && value.charAt(0) == '/' && (base = context.getBaseUrl(this._baseTypeKey, node)) != null) {
            return URLFactory.newURL((URL)base, (String)value);
        }
        return context.getURLForRelativePath(value);
    }

    @Override
    protected void getValidValuesForUrl(XmlModel model, Node node, URL url, Collection<CharSequence> out) {
        String relativeToBase;
        URL baseUrl;
        XmlContext context = model.getContext();
        out.add(context.getRelativePathForURL(url));
        if (this._baseTypeKey != null && (baseUrl = context.getBaseUrl(this._baseTypeKey, node)) != null && (relativeToBase = URLFileSystem.toRelativeSpec((URL)url, (URL)baseUrl, (boolean)true)) != null) {
            out.add("/" + relativeToBase);
        }
    }

    @Override
    public final Severity getBrokenReferenceSeverity() {
        return this._severity;
    }

    protected final Object getBaseTypeKey() {
        return this._baseTypeKey;
    }
}

