/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.metadata.refinfo2.url;

import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.PriorityQueue;
import oracle.bali.xml.daf.DafUtils;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.metadata.refinfo2.RefInfo2;
import oracle.bali.xml.model.metadata.refinfo2.Severity;
import oracle.bali.xml.model.metadata.refinfo2.url.SimpleUrlRefInfo2;
import oracle.ide.net.URLFactory;
import oracle.javatools.daf.model.DafUrlNode;
import oracle.javatools.daf.query.NodeCriteria;
import oracle.javatools.daf.util.FString;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UrlRefInfo2
extends RefInfo2 {
    private static final Comparator<CharSequence> _LENGTH_COMPARATOR = new 1();

    public static RefInfo2 createUrlRefInfo2(Object baseTypeKey, Severity severity) {
        return new SimpleUrlRefInfo2(baseTypeKey, severity);
    }

    @Override
    public final NodeCriteria getTargetCriteria(XmlModel model, Node node) {
        URL absolute = this.getUrlForValue(model, node, this.getValue().toString());
        if (absolute != null) {
            return DafUtils.createUrlNodeCriteria(absolute);
        }
        return null;
    }

    @Override
    public final CharSequence updateReference(XmlModel model, Node node, NodeCriteria updateInfo) {
        URL renamedURL;
        FString urlSeq = updateInfo.get(DafUrlNode.KEY_URL);
        if (urlSeq != null && (renamedURL = URLFactory.newURL((String)urlSeq.toString())) != null) {
            PriorityQueue<CharSequence> queue = new PriorityQueue<CharSequence>(3, _LENGTH_COMPARATOR);
            this.getValidValuesForUrl(model, node, renamedURL, queue);
            return queue.peek();
        }
        return null;
    }

    protected abstract URL getUrlForValue(XmlModel var1, Node var2, String var3);

    protected abstract void getValidValuesForUrl(XmlModel var1, Node var2, URL var3, Collection<CharSequence> var4);

    static final class 1
    implements Comparator {
        public int compare(CharSequence o1, CharSequence o2) {
            int first = o1.length();
            int second = o2.length();
            return first - second;
        }
    }
}

