/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.resource;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.bali.share.collection.CompoundEnumeration;
import oracle.bali.xml.share.NoDuplicatesEnumeration;

public final class PaternalResourceBundle
extends ResourceBundle {
    private static final int _AVERAGE_RESOURCE_SIZE = 101;
    private static final ResourceBundle[] _EMPTY_ARRAY = new ResourceBundle[0];
    private String[] _bundleNames;
    private Locale _locale;
    private transient Enumeration _keys;
    private transient ResourceBundle[] _bundles;
    private transient HashMap _valueCache;

    public PaternalResourceBundle(String[] bundleNames) {
        this(bundleNames, null);
    }

    public PaternalResourceBundle(ResourceBundle[] bundles) {
        if (bundles == null || bundles.length == 0) {
            throw new IllegalArgumentException();
        }
        this._bundles = this._flattenBundles(bundles);
    }

    public PaternalResourceBundle(String[] bundleNames, Locale locale) {
        int bundleCount = bundleNames.length;
        if (bundleNames == null || bundleCount == 0) {
            throw new IllegalArgumentException();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String[] tempBundleNames = new String[bundleCount];
        System.arraycopy(bundleNames, 0, tempBundleNames, 0, bundleCount);
        this._bundleNames = bundleNames;
        this._locale = locale;
    }

    public Enumeration getKeys() {
        int bundleCount;
        if (this._bundles == null) {
            this._createBundles();
        }
        if ((bundleCount = this._bundles.length) > 1) {
            CompoundEnumeration currEnumeration = new CompoundEnumeration(this._bundles[0].getKeys(), this._bundles[1].getKeys());
            int currIndex = 2;
            while (currIndex < bundleCount) {
                currEnumeration = new CompoundEnumeration((Enumeration)currEnumeration, this._bundles[currIndex].getKeys());
                ++currIndex;
            }
            return new NoDuplicatesEnumeration((Enumeration)currEnumeration);
        }
        if (bundleCount == 1) {
            return this._bundles[0].getKeys();
        }
        return null;
    }

    public String toString() {
        if (this._bundles == null) {
            this._createBundles();
        }
        StringBuffer buf = new StringBuffer();
        buf.append("Paternal-bundle(");
        int i = 0;
        while (i < this._bundles.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this._bundles[i]);
            ++i;
        }
        buf.append(")");
        return buf.toString();
    }

    protected Object handleGetObject(String key) throws MissingResourceException {
        int bundleCount;
        if (this._bundles == null) {
            this._createBundles();
        }
        if ((bundleCount = this._bundles.length) > 1) {
            Object result;
            if (this._valueCache == null) {
                this._createValueCache(bundleCount);
            }
            if ((result = this._valueCache.get(key)) == null) {
                int i = 0;
                while (true) {
                    try {
                        result = this._bundles[i].getObject(key);
                        this._valueCache.put(key, result);
                    }
                    catch (MissingResourceException e) {
                        if (++i != bundleCount) continue;
                        throw e;
                    }
                    break;
                }
            }
            return result;
        }
        if (bundleCount == 1) {
            return this._bundles[0].getObject(key);
        }
        return null;
    }

    private ResourceBundle[] _flattenBundles(ResourceBundle[] bundles) {
        int bundleCount = bundles.length;
        LinkedHashSet flattenedBundles = new LinkedHashSet(2 * bundleCount);
        this._flattenBundles(bundles, flattenedBundles);
        return flattenedBundles.toArray(_EMPTY_ARRAY);
    }

    private void _flattenBundles(ResourceBundle[] bundles, LinkedHashSet flattenedBundles) {
        int bundleCount = bundles.length;
        int i = 0;
        while (i < bundleCount) {
            ResourceBundle currBundle = bundles[i];
            if (currBundle != null) {
                if (currBundle instanceof PaternalResourceBundle) {
                    PaternalResourceBundle paternalBundle = (PaternalResourceBundle)currBundle;
                    this._flattenBundles(paternalBundle._bundles, flattenedBundles);
                } else {
                    flattenedBundles.add(currBundle);
                }
            }
            ++i;
        }
    }

    private void _createBundles() {
        int bundleCount = this._bundleNames.length;
        ResourceBundle[] bundles = new ResourceBundle[bundleCount];
        int i = 0;
        while (i < bundleCount) {
            try {
                bundles[i] = PaternalResourceBundle.getBundle(this._bundleNames[i], this._locale);
            }
            catch (MissingResourceException e) {
                bundles[i] = null;
            }
            ++i;
        }
        this._bundles = this._flattenBundles(bundles);
    }

    private void _createValueCache(int bundleCount) {
        if (bundleCount < 2) {
            throw new IllegalArgumentException();
        }
        this._valueCache = new HashMap(101 * bundleCount);
    }
}

