/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.view;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.ref.NodeRef;
import oracle.bali.xml.dom.ref.NonAttrNodeRef;
import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.view.standalone.ProxyingNode;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.grammar.resolver.GrammarResolverListener;
import oracle.bali.xml.metadata.DerivedXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.datatransfer.operation.Operation;
import oracle.bali.xml.model.datatransfer.operation.PerformOperationAction;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.model.view.FilteredView;
import oracle.bali.xml.model.view.FilteredViewTreeTraversal;
import oracle.bali.xml.model.view.SlotsFolderViewTraversal;
import oracle.bali.xml.share.PropertyChange;
import oracle.bali.xml.share.TransactionToken;
import oracle.bali.xml.util.XmlModelUtils;
import oracle.javatools.datatransfer.TransferDataInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class AbstractSlotsFolderView
extends FilteredView {
    private final SlotsFolderViewTraversal _folderTraversal;
    private final TreeTraversal _combinedTraversal;
    private final HashMap _fakeSlotKeys;
    private final HashMap _fakeIcons;
    private final HashMap _dimmedIcons;
    private static final URL _SLOTS_FOLDER_ICON_URL = AbstractSlotsFolderView.class.getResource("slot.gif");
    public static final String SLOTS_FOLDER_ICON_LOCATION = _SLOTS_FOLDER_ICON_URL == null ? null : _SLOTS_FOLDER_ICON_URL.toExternalForm();

    public AbstractSlotsFolderView() {
        this.$init$();
        this._folderTraversal = new SlotsFolderViewTraversal(this);
    }

    public DomPosition viewToModel(DomPosition viewPosition) {
        if (viewPosition == null) {
            return null;
        }
        Node targetNode = viewPosition.getTargetNode();
        Node modelNode = this.viewToModel(targetNode);
        if (modelNode == null) {
            return null;
        }
        if (modelNode == targetNode) {
            return viewPosition;
        }
        return viewPosition.getRetargetedPosition(modelNode, true);
    }

    public Node viewToModel(Node viewNode) {
        if (viewNode == null) {
            return null;
        }
        if (this._folderTraversal.isSlotsFolderNode(viewNode)) {
            return null;
        }
        if (this._folderTraversal.isNamedChildSlotProxy(viewNode)) {
            if (viewNode instanceof ProxyingNode) {
                return ((ProxyingNode)((Object)viewNode)).getProxiedNode();
            }
            return null;
        }
        return viewNode;
    }

    public Node modelToView(Node modelNode) {
        Node viewNode = super.modelToView(modelNode);
        if (viewNode != null) {
            if (this.isSlot(viewNode)) {
                viewNode = this._folderTraversal.__getNamedChildSlotProxy(viewNode);
            }
            return viewNode;
        }
        if (this.isNodeInView(modelNode)) {
            return modelNode;
        }
        return null;
    }

    public boolean isNodeInView(Node modelNode) {
        if (modelNode == null) {
            return false;
        }
        if (this.isSlot(modelNode)) {
            return this.isNodeInView(modelNode.getParentNode());
        }
        return super.isNodeInView(modelNode);
    }

    public Node remapNode(List oldNodePath) {
        int pathCount = oldNodePath.size();
        if (pathCount == 0) {
            return null;
        }
        Node lastNode = (Node)oldNodePath.get(pathCount - 1);
        if (this._folderTraversal.isSlotsFolderNode(lastNode)) {
            List oldNodeParentPath;
            Node newParentNode;
            if (pathCount > 1 && (newParentNode = super.remapNode(oldNodeParentPath = oldNodePath.subList(0, pathCount - 1))) != null) {
                return this._folderTraversal.getChildSlotsNode(newParentNode);
            }
            return null;
        }
        return super.remapNode(oldNodePath);
    }

    public XmlKey getNodeXmlKey(Node node) {
        if (this._folderTraversal.isSlotsFolderNode(node)) {
            return this._folderTraversal.getSlotsFolderKey();
        }
        XmlKey modelKey = super.getNodeXmlKey(node);
        if (modelKey != null) {
            return modelKey;
        }
        return this._getFakeSlotKey(node);
    }

    protected TreeTraversal getTreeTraversalImpl() {
        return this._combinedTraversal;
    }

    public DomPosition convertInsertionPosition(DomPosition origPosition) {
        Node targetNode;
        if (origPosition != null && (targetNode = origPosition.getTargetNode()) != null) {
            if (this._folderTraversal.isNamedChildSlotProxy(targetNode) && !origPosition.isInside()) {
                return origPosition.getInsidePosition();
            }
            if (this._folderTraversal.isSlotsFolderNode(targetNode)) {
                return null;
            }
        }
        return super.convertInsertionPosition(origPosition);
    }

    public Collection insertNodes(DomPosition location, String transactionName, Collection nodes, boolean updateSelection) throws XmlCommitException {
        boolean targetsFakeSlot;
        Node targetNode = location.getTargetNode();
        this.acquireReadLock();
        try {
            targetsFakeSlot = this._folderTraversal.isFakeNamedChildSlotProxy(targetNode);
        }
        finally {
            this.releaseReadLock();
        }
        if (targetsFakeSlot) {
            Collection[] retHolder = new Collection[1];
            new 1(this, transactionName, targetNode, transactionName, nodes, updateSelection, retHolder).runThrowingXCE(this);
            return retHolder[0];
        }
        return super.insertNodes(location, transactionName, nodes, updateSelection);
    }

    public void performOperationAction(ActionEvent event, PerformOperationAction performOperationAction, AbstractModel model, DomPosition position, Operation operation, TransferDataInfo transferDataInfo) {
        AbstractModel transformDropModel = this.getTransformedDropModel(position);
        TransactionToken token = transformDropModel.getContext().createTransactionToken();
        token.setOwnerIfUnset(performOperationAction);
        boolean success = false;
        try {
            try {
                DomPosition transformDropPosition = this.getTransformedDropPosition(position);
                success = operation.apply(transformDropModel, transformDropPosition, transferDataInfo, token);
            }
            catch (IOException e) {
                e.printStackTrace();
                success = false;
            }
            catch (XmlCommitException e) {
                e.printStackTrace();
                success = false;
            }
        }
        finally {
            TransactionToken.dispatch(token, performOperationAction, success);
        }
    }

    public boolean transformModelAndDomPosition() {
        return true;
    }

    public AbstractModel transformModel() {
        return this.getBaseModel();
    }

    public DomPosition transformDomPosition(DomPosition domPosition) {
        return this.viewToModel(domPosition);
    }

    public Node insertRealSlot(DomPosition location, String transactionName) throws XmlCommitException {
        boolean targetsFakeSlot;
        Node targetNode = location.getTargetNode();
        this.acquireReadLock();
        try {
            targetsFakeSlot = this._folderTraversal.isFakeNamedChildSlotProxy(targetNode);
        }
        finally {
            this.releaseReadLock();
        }
        if (targetsFakeSlot) {
            Node[] retHolder = new Node[1];
            new 2(this, transactionName, targetNode, retHolder).runThrowingXCE(this);
            return retHolder[0];
        }
        return null;
    }

    private AbstractModel getTransformedDropModel(DomPosition domPosition) {
        Node targetNode = domPosition.getTargetNode();
        if (this._folderTraversal.isNamedChildSlotProxy(targetNode) || this._folderTraversal.isFakeNamedChildSlotProxy(targetNode)) {
            return this.getBaseModel();
        }
        return this;
    }

    private DomPosition getTransformedDropPosition(DomPosition domPosition) {
        DomPosition[] retHolder = new DomPosition[1];
        Node targetNode = domPosition.getTargetNode();
        if (!this._folderTraversal.isNamedChildSlotProxy(targetNode) && !this._folderTraversal.isFakeNamedChildSlotProxy(targetNode)) {
            return domPosition;
        }
        try {
            new 3(this, "Insert Real Slot", domPosition, retHolder).runThrowingXCE(this);
        }
        catch (XmlCommitException e) {
            e.printStackTrace();
        }
        return retHolder[0];
    }

    protected abstract boolean isSlot(XmlKey var1);

    protected abstract boolean isSlotParent(XmlKey var1);

    protected XmlKey getFakeSlotKey(XmlKey parentKey, Node slotNode) {
        return DerivedXmlKey.createElementKey((GrammarResolver)this.getContext().getGrammarResolver(), (XmlKey)parentKey, (QualifiedName)QualifiedName.getQualifiedName((String)slotNode.getNamespaceURI(), (String)DomUtils.getLocalName((Node)slotNode)));
    }

    protected final boolean isSlot(Node node) {
        return this.isSlot(this.getNodeXmlKey(node));
    }

    protected final boolean isSlotParent(Node node) {
        return this.isSlotParent(this.getNodeXmlKey(node));
    }

    protected void postAttachmentHook() {
        super.postAttachmentHook();
        this.getContext().getGrammarResolver().addGrammarResolverListener((GrammarResolverListener)this._folderTraversal);
    }

    protected Node transformChangeRoot(Node modelChangeRoot) {
        Node nodeProxy = this._folderTraversal.__getNamedChildSlotProxy(modelChangeRoot);
        Node viewChangeRoot = nodeProxy != null ? nodeProxy : modelChangeRoot;
        return super.transformChangeRoot(viewChangeRoot);
    }

    protected Object savePrivateSelectionState(XmlModelEvent modelChangeEvent) {
        Selection selection;
        int selectionCount;
        Object superclassState = super.savePrivateSelectionState(modelChangeEvent);
        PropertyChange documentChange = modelChangeEvent.getDomDocumentPropertyChange();
        if (documentChange != null && (selectionCount = (selection = this.getSelection()).getSelectedNodesCount()) > 0) {
            Node cursorTarget;
            Iterator<Node> selectedNodes = selection.getSelectedNodes();
            LinkedList<TraversalNodeRef> privateNodeRefs = null;
            LinkedList<Node> nodesRemoved = null;
            TreeTraversal traversal = this.getTreeTraversal();
            while (selectedNodes.hasNext()) {
                Node currSelectedNode = selectedNodes.next();
                if (!this._isViewPrivateNode(currSelectedNode)) continue;
                TraversalNodeRef currNodeRef = new TraversalNodeRef(traversal, currSelectedNode);
                if (privateNodeRefs == null) {
                    privateNodeRefs = new LinkedList<TraversalNodeRef>();
                    nodesRemoved = new LinkedList<Node>();
                }
                privateNodeRefs.add(currNodeRef);
                nodesRemoved.add(currSelectedNode);
            }
            TraversalNodeRef cursorNodeRef = null;
            DomPosition oldCursorLocation = null;
            DomPosition cursorLocation = selection.getCursorLocation();
            if (cursorLocation != null && this._isViewPrivateNode(cursorTarget = cursorLocation.getTargetNode())) {
                oldCursorLocation = cursorLocation;
                cursorNodeRef = new TraversalNodeRef(traversal, cursorTarget);
            }
            if (privateNodeRefs != null || oldCursorLocation != null) {
                SelectionState privateSelection = new SelectionState(null);
                privateSelection.privateNodeRefs = privateNodeRefs;
                privateSelection.nodesRemoved = nodesRemoved;
                privateSelection.superclassState = superclassState;
                privateSelection.oldCursor = oldCursorLocation;
                privateSelection.newCursorTarget = cursorNodeRef;
                return privateSelection;
            }
        }
        return superclassState;
    }

    private boolean _isViewPrivateNode(Node checkedNode) {
        return this._folderTraversal.isSlotsFolderNode(checkedNode) || this._folderTraversal.isFakeNamedChildSlotProxy(checkedNode);
    }

    protected XmlModelEvent restorePrivateSelectionState(Object state, XmlModelEvent selectionTransformedEvent) {
        SelectionState ourState = null;
        Object superclassState = state;
        if (state instanceof SelectionState) {
            ourState = (SelectionState)state;
            superclassState = ourState.superclassState;
        }
        XmlModelEvent outEvent = super.restorePrivateSelectionState(superclassState, selectionTransformedEvent);
        if (ourState != null) {
            List privateNodeRefs = ourState.privateNodeRefs;
            int privateNodeRefCount = privateNodeRefs.size();
            LinkedList<Node> nodesAdded = null;
            Document viewDocument = this.getDocument();
            if (privateNodeRefCount > 0) {
                for (NodeRef currAddNodeRef : privateNodeRefs) {
                    Node newViewNode = currAddNodeRef.getCorrespondingNode(viewDocument);
                    if (newViewNode == null) continue;
                    if (nodesAdded == null) {
                        nodesAdded = new LinkedList<Node>();
                    }
                    nodesAdded.add(newViewNode);
                }
            }
            Map<String, PropertyChange> propertyChanges = null;
            if (ourState.oldCursor != null) {
                PropertyChange cursorPropertyChange;
                Node newCursorTarget;
                DomPosition newCursorPosition = null;
                if (ourState.newCursorTarget != null && (newCursorTarget = ourState.newCursorTarget.getCorrespondingNode(viewDocument)) != null) {
                    newCursorPosition = DomPositionFactory.createDomPosition((Node)newCursorTarget, (int)ourState.oldCursor.getRelativePosition());
                }
                if ((cursorPropertyChange = PropertyChange.getPropertyChange("cursorLocation", ourState.oldCursor, newCursorPosition)) != null) {
                    propertyChanges = Collections.singletonMap("cursorLocation", cursorPropertyChange);
                }
            }
            XmlModelEvent selectionChanges = new XmlModelEvent(this, null, 0, propertyChanges, new HashSet<Node>(nodesAdded), new HashSet<Node>(ourState.nodesRemoved), null, null);
            if (outEvent.getModel() == this) {
                outEvent = outEvent.getMutableEvent();
                outEvent.addModelEvent(selectionChanges);
            } else {
                outEvent = selectionChanges;
            }
        }
        return outEvent;
    }

    protected XmlModelEvent transformModelEventHook(XmlModelEvent modelChangeEvent) {
        Node oldModelChangeRoot;
        Node newModelChangeRoot = oldModelChangeRoot = modelChangeEvent.getChangeRoot();
        if (modelChangeEvent.isDomDocumentChanged()) {
            this._folderTraversal.updateCache(oldModelChangeRoot);
            this._fakeSlotKeys.clear();
        } else {
            Node clearCacheRoot = oldModelChangeRoot;
            boolean fixedAttrChange = XmlModelUtils.fixedAttributeMightHaveChanged(modelChangeEvent);
            if (oldModelChangeRoot != null && (modelChangeEvent.isDomStructureChanged() || fixedAttrChange)) {
                Node nodeProxy = this._folderTraversal.__getNamedChildSlotProxy(oldModelChangeRoot);
                if (nodeProxy != null) {
                    clearCacheRoot = nodeProxy;
                    if (fixedAttrChange) {
                        clearCacheRoot = clearCacheRoot.getParentNode().getParentNode();
                    }
                    XmlKey nodeKey = this.getNodeXmlKey(oldModelChangeRoot);
                    if (fixedAttrChange || this.getXmlMetadataResolver().isDeprecated(nodeKey)) {
                        newModelChangeRoot = oldModelChangeRoot.getParentNode();
                    }
                }
                this._folderTraversal.updateCache(clearCacheRoot);
                this._fakeSlotKeys.clear();
                modelChangeEvent = modelChangeEvent.getMutableEvent();
                modelChangeEvent.setChangeRoot(newModelChangeRoot, modelChangeEvent.getChangeFlags() | 1 | 2);
            }
        }
        return super.transformModelEventHook(modelChangeEvent);
    }

    protected final Node getSlotsFolderNode(Node parent) {
        return this._folderTraversal.getChildSlotsNode(parent);
    }

    protected final boolean isSlotsFolderNode(Node node) {
        return this._folderTraversal.isSlotsFolderNode(node);
    }

    protected final boolean isSlotsFolderKey(XmlKey key) {
        return this._folderTraversal.isSlotsFolderKey(key);
    }

    protected final boolean isFakeNamedChildSlotProxy(Node node) {
        return this._folderTraversal.isFakeNamedChildSlotProxy(node);
    }

    protected final Icon processIconForSlots(Node node, XmlKey nodeKey, Icon smallIcon) {
        boolean isFake;
        if (smallIcon != null && node != null && (isFake = this._folderTraversal.isFakeNamedChildSlotProxy(node)) && smallIcon instanceof ImageIcon) {
            Object fakeSmallIcon = this._fakeIcons.get(nodeKey);
            if (fakeSmallIcon == null && (fakeSmallIcon = this._dimmedIcons.get(smallIcon)) == null) {
                Image iconImage = ((ImageIcon)smallIcon).getImage();
                Image fakeImage = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(iconImage.getSource(), new DimFilter()));
                fakeSmallIcon = new ImageIcon(fakeImage);
                this._fakeIcons.put(nodeKey, fakeSmallIcon);
                this._dimmedIcons.put(smallIcon, fakeSmallIcon);
            }
            smallIcon = (Icon)fakeSmallIcon;
        }
        return smallIcon;
    }

    private XmlKey _getFakeSlotKey(Node slotNode) {
        XmlKey slotKey = (XmlKey)this._fakeSlotKeys.get(slotNode);
        if (slotKey == null) {
            Node realParentNode = slotNode.getParentNode().getParentNode();
            XmlKey realParentKey = super.getNodeXmlKey(realParentNode);
            if (realParentKey == null) {
                return null;
            }
            slotKey = this.getFakeSlotKey(realParentKey, slotNode);
            this._fakeSlotKeys.put(slotNode, slotKey.intern());
        }
        return slotKey;
    }

    private void $init$() {
        this._combinedTraversal = new CombinedTraversal();
        this._fakeSlotKeys = new HashMap();
        this._fakeIcons = new HashMap();
        this._dimmedIcons = new HashMap();
    }

    static SlotsFolderViewTraversal ra$_folderTraversal(AbstractSlotsFolderView abstractSlotsFolderView) {
        return abstractSlotsFolderView._folderTraversal;
    }

    final class 1
    extends FixedNameTransactionTask {
        private final /* synthetic */ Node v$targetNode;
        private final /* synthetic */ String v$transactionName;
        private final /* synthetic */ Collection v$nodes;
        private final /* synthetic */ boolean v$updateSelection;
        private final /* synthetic */ Collection[] v$retHolder;
        final /* synthetic */ AbstractSlotsFolderView this$0;

        protected void performTask(AbstractModel model) throws XmlCommitException {
            Collection sRet;
            TreeTraversal trav = this.this$0.getTreeTraversal();
            Node uinodeParent = trav.getParentNode(trav.getParentNode(this.v$targetNode));
            XmlKey slotKey = this.this$0.getNodeXmlKey(this.v$targetNode);
            Node realSlot = this.this$0.getBaseModel().insertXmlKey(slotKey, DomPositionFactory.inside((Node)uinodeParent));
            if (realSlot == null) {
                this.cancelTask();
            }
            if ((sRet = this.this$0.getBaseModel().insertNodes(DomPositionFactory.inside((Node)realSlot), this.v$transactionName, this.v$nodes, this.v$updateSelection)) == null) {
                this.cancelTask();
            }
            ArrayList<Node> ret = new ArrayList<Node>(1 + sRet.size());
            ret.add(realSlot);
            ret.addAll(sRet);
            this.v$retHolder[0] = ret;
        }

        public 1(AbstractSlotsFolderView abstractSlotsFolderView, String string, Node node, String string2, Collection collection, boolean bl, Collection[] collectionArray) {
            this.v$retHolder = collectionArray;
            this.v$updateSelection = bl;
            this.v$nodes = collection;
            this.v$transactionName = string2;
            this.v$targetNode = node;
            this.this$0 = abstractSlotsFolderView;
            super(string);
        }
    }

    final class 2
    extends FixedNameTransactionTask {
        private final /* synthetic */ Node v$targetNode;
        private final /* synthetic */ Node[] v$retHolder;
        final /* synthetic */ AbstractSlotsFolderView this$0;

        protected void performTask(AbstractModel model) throws XmlCommitException {
            TreeTraversal trav = this.this$0.getTreeTraversal();
            Node uinodeParent = trav.getParentNode(trav.getParentNode(this.v$targetNode));
            XmlKey slotKey = this.this$0.getNodeXmlKey(this.v$targetNode);
            Node realSlot = this.this$0.getBaseModel().insertXmlKey(slotKey, DomPositionFactory.inside((Node)uinodeParent));
            if (realSlot == null) {
                this.cancelTask();
            }
            this.v$retHolder[0] = realSlot;
        }

        public 2(AbstractSlotsFolderView abstractSlotsFolderView, String string, Node node, Node[] nodeArray) {
            this.v$retHolder = nodeArray;
            this.v$targetNode = node;
            this.this$0 = abstractSlotsFolderView;
            super(string);
        }
    }

    final class 3
    extends FixedNameTransactionTask {
        private final /* synthetic */ DomPosition v$domPosition;
        private final /* synthetic */ DomPosition[] v$retHolder;
        final /* synthetic */ AbstractSlotsFolderView this$0;

        protected void performTask(AbstractModel model) throws XmlCommitException {
            Node realSlot = this.this$0.insertRealSlot(this.v$domPosition, this.getTransactionNameWithoutModelAccess());
            DomPosition position = realSlot != null ? DomPositionFactory.inside((Node)realSlot) : this.this$0.viewToModel(this.v$domPosition);
            this.v$retHolder[0] = position;
        }

        public 3(AbstractSlotsFolderView abstractSlotsFolderView, String string, DomPosition domPosition, DomPosition[] domPositionArray) {
            this.v$retHolder = domPositionArray;
            this.v$domPosition = domPosition;
            this.this$0 = abstractSlotsFolderView;
            super(string);
        }
    }

    private class CombinedTraversal
    extends FilteredViewTreeTraversal {
        public CombinedTraversal() {
            super(AbstractSlotsFolderView.this);
        }

        protected TreeTraversal getBeforeTraversal() {
            return AbstractSlotsFolderView.ra$_folderTraversal(AbstractSlotsFolderView.this);
        }
    }

    private static class DimFilter
    extends RGBImageFilter {
        public DimFilter() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int x, int y, int rgb) {
            int alpha = rgb & 0xFF000000;
            int red = rgb & 0xFF0000;
            int green = rgb & 0xFF00;
            int blue = rgb & 0xFF;
            red >>= 1;
            red += 0x400000;
            green >>= 1;
            green += 16384;
            blue >>= 1;
            blue += 64;
            return alpha | (red &= 0xFF0000) | (green &= 0xFF00) | (blue &= 0xFF);
        }
    }

    private static class SelectionState {
        public List privateNodeRefs;
        public List nodesRemoved;
        public Object superclassState;
        public DomPosition oldCursor;
        public NodeRef newCursorTarget;

        private SelectionState() {
        }

        SelectionState(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class TraversalNodeRef
    extends NonAttrNodeRef {
        private final TreeTraversal _traversal;
        private final int[] _parentNodePath;
        private final int _indexInParent;

        TraversalNodeRef(Node node) {
            this((TreeTraversal)DocumentTreeTraversal.INSTANCE, node);
        }

        TraversalNodeRef(TreeTraversal traversal, Node node) {
            this(traversal, DomUtils.getPathToNode((TreeTraversal)traversal, (Node)traversal.getParentNode(node)), DomUtils.getChildIndex((TreeTraversal)traversal, (Node)node));
        }

        private TraversalNodeRef(TreeTraversal traversal, int[] parentPath, int indexInParent) {
            this._traversal = traversal;
            this._parentNodePath = parentPath;
            this._indexInParent = indexInParent;
        }

        public void putCorrespondingNode(Document doc, Node newNode) {
            throw new IllegalStateException();
        }

        public Node getCorrespondingNode(Document doc) {
            return DomUtils.getChildAtIndex((TreeTraversal)this._traversal, (Node)this._getParentNode(doc), (int)this._indexInParent);
        }

        public NodeRef getChildNodeRef(Node node) {
            throw new IllegalStateException();
        }

        public int[] getNodePath() {
            int[] path = new int[this._parentNodePath.length + 1];
            System.arraycopy(this._parentNodePath, 0, path, 0, this._parentNodePath.length);
            path[path.length - 1] = this._indexInParent;
            return path;
        }

        public String getJavaExpression(String docExpr) {
            throw new IllegalStateException();
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("[");
            this._appendPathAsString(buf);
            buf.append("]");
            return buf.toString();
        }

        private void _appendPathAsString(StringBuffer buf) {
            int i = 0;
            while (i < this._parentNodePath.length) {
                buf.append(this._parentNodePath[i]);
                buf.append(", ");
                ++i;
            }
            buf.append(this._indexInParent);
        }

        private Node _getParentNode(Document doc) {
            return DomUtils.getNodeFromPath((TreeTraversal)this._traversal, (Document)doc, (int[])this._parentNodePath);
        }
    }
}

