/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.share.util.IntegerUtils;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.view.standalone.StandaloneElement;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.MetadataEvaluator;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.structured.StructuredMetadataBean;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.view.FilteredViewTreeTraversal;
import oracle.bali.xml.model.view.SimpleTypeElementFilteredView;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.share.PropertyChange;
import oracle.bali.xml.util.XmlCreationAction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class CategorizedView
extends SimpleTypeElementFilteredView {
    private static final String _FAKE_NAMESPACE = "http://xmlns.oracle.com/jdev/bali/xml/model/view/categorized";
    private static final QualifiedName _SHORT_DISPLAY_NAME = QualifiedName.getQualifiedName((String)"http://xmlns.oracle.com/bali/xml/metadata", (String)"shortDisplayName");
    private static final QualifiedName _MEDIUM_DISPLAY_NAME = QualifiedName.getQualifiedName((String)"http://xmlns.oracle.com/bali/xml/metadata", (String)"mediumDisplayName");
    private static final QualifiedName _LONG_DISPLAY_NAME = QualifiedName.getQualifiedName((String)"http://xmlns.oracle.com/bali/xml/metadata", (String)"longDisplayName");
    private static final QualifiedName _SMALL_ICON_NAME = QualifiedName.getQualifiedName((String)"http://xmlns.oracle.com/bali/xml/metadata", (String)"smallIcon");
    private BeforeTraversal _before = new BeforeTraversal(this);

    public XmlKey getNodeXmlKey(Node node) {
        if (this.isCategoryNode(node)) {
            return this._before.getKey(node);
        }
        return super.getNodeXmlKey(node);
    }

    public DomPosition viewToModel(DomPosition viewPosition) {
        if (viewPosition == null) {
            return null;
        }
        Node targetNode = viewPosition.getTargetNode();
        Node modelNode = this.viewToModel(targetNode);
        if (modelNode == null) {
            return null;
        }
        if (modelNode == targetNode) {
            return viewPosition;
        }
        return DomPositionFactory.createDomPosition((Node)modelNode, (int)viewPosition.getRelativePosition());
    }

    public Node viewToModel(Node viewNode) {
        if (viewNode == null) {
            return null;
        }
        if (this.isCategoryNode(viewNode)) {
            return null;
        }
        return viewNode;
    }

    public Collection insertNodes(DomPosition location, String transactionName, Collection nodes, boolean updateSelection) throws XmlCommitException {
        Node containerNode = location.getContainerNode();
        if (this.isCategoryNode(containerNode)) {
            Element root = containerNode.getOwnerDocument().getDocumentElement();
            location = DomPositionFactory.inside((Node)root);
        }
        return super.insertNodes(location, transactionName, nodes, updateSelection);
    }

    public DomPosition convertInsertionPosition(DomPosition origPosition) {
        Node targetNode;
        if (origPosition != null && (targetNode = origPosition.getTargetNode()) != null && this.isCategoryNode(targetNode)) {
            if (origPosition.isInside()) {
                Node lastChild = BeforeTraversal.mav$_getLastChild(this._before, targetNode);
                if (lastChild != null) {
                    return DomPositionFactory.after((Node)lastChild);
                }
            } else if (origPosition.isBefore()) {
                Node firstChild = BeforeTraversal.mav$_getFirstChild(this._before, targetNode);
                if (firstChild != null) {
                    return DomPositionFactory.before((Node)firstChild);
                }
                Node previousFake = BeforeTraversal.mav$_getPreviousFakeChild(this._before, targetNode);
                if (previousFake != null) {
                    return this.convertInsertionPosition(DomPositionFactory.inside((Node)previousFake));
                }
            } else if (origPosition.isBefore()) {
                Node lastChild = BeforeTraversal.mav$_getLastChild(this._before, targetNode);
                if (lastChild != null) {
                    return DomPositionFactory.after((Node)lastChild);
                }
                Node nextFake = BeforeTraversal.mav$_getNextFakeChild(this._before, targetNode);
                if (nextFake != null) {
                    return this.convertInsertionPosition(DomPositionFactory.inside((Node)nextFake));
                }
            }
            return DomPositionFactory.inside((Node)targetNode.getOwnerDocument().getDocumentElement());
        }
        return super.convertInsertionPosition(origPosition);
    }

    public List getExtraContextMenus(DomPosition position) {
        this.acquireReadLock();
        try {
            Selection selection = this.getSelection();
            if (selection.size() != 1) {
                List list = super.getExtraContextMenus(position);
                return list;
            }
            Node targetNode = selection.getFirstSelectedNode();
            if (this.isCategoryNode(targetNode)) {
                List creationKeys = this._before.getCreationKeys(targetNode);
                if (creationKeys == null) {
                    List list = Collections.EMPTY_LIST;
                    return list;
                }
                if (creationKeys.size() > 0) {
                    XmlKey creationKey = (XmlKey)creationKeys.get(0);
                    XmlCreationAction onlyOne = new XmlCreationAction((AbstractModel)this, position, creationKey);
                    String menuTitleFormat = this.getTranslatedString("INSERT_MENU_FORMAT");
                    String menuTitle = FastMessageFormat.formatMessage(menuTitleFormat, creationKey.getLocalName());
                    int mnemonic = StringUtils.getMnemonicKeyCode((String)menuTitle);
                    menuTitle = StringUtils.stripMnemonic((String)menuTitle);
                    String overflowFormat = this.getTranslatedString("INSERT_MENU.OVERFLOW_FORMAT");
                    String overflowString = FastMessageFormat.formatMessage(overflowFormat, menuTitle);
                    XmlCreationAction action = onlyOne;
                    action.putValue("Name", overflowString);
                    action.putValue("MnemonicKey", new Integer(mnemonic));
                    List<XmlCreationAction> list = Collections.singletonList(action);
                    return list;
                }
            }
            List list = super.getExtraContextMenus(position);
            return list;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.releaseReadLock();
        }
    }

    protected abstract List getCategories();

    protected abstract String getCategory(Node var1);

    protected abstract List getCreationKeys(String var1);

    protected abstract boolean isRootNode(XmlKey var1, Node var2);

    protected Object getCategoryMetadataItem(QualifiedName metadataItem, String category) {
        if (_SHORT_DISPLAY_NAME.equals((Object)metadataItem)) {
            return this.getCategoryShortDisplayName(category);
        }
        if (_MEDIUM_DISPLAY_NAME.equals((Object)metadataItem)) {
            return this.getCategoryMediumDisplayName(category);
        }
        if (_LONG_DISPLAY_NAME.equals((Object)metadataItem)) {
            return this.getCategoryMediumDisplayName(category);
        }
        if (_SMALL_ICON_NAME.equals((Object)metadataItem)) {
            return this.getCategorySmallIcon(category);
        }
        return null;
    }

    protected String getCategoryShortDisplayName(String category) {
        return category;
    }

    protected String getCategoryMediumDisplayName(String category) {
        return category;
    }

    protected String getCategoryLongDisplayName(String category) {
        return category;
    }

    protected String getCategorySmallIcon(String category) {
        return null;
    }

    protected final boolean isCategoryNode(Node node) {
        return this._before.isFake(node);
    }

    protected final boolean isCategoryNodeKey(XmlKey key) {
        return this._before.isFake(key);
    }

    protected XmlMetadataResolver createXmlMetadataResolver(MetadataEvaluator evaluator) {
        return new CategorizedMetadataResolver(evaluator, this);
    }

    protected final MetadataEvaluator createMetadataEvaluator() {
        return new CategorizedMetadataEvaluator(null);
    }

    protected final TreeTraversal createTreeTraversal() {
        return new Traversal(this, this._before);
    }

    protected final short acceptNode(Node modelNode) {
        if (this.isCategoryNode(modelNode)) {
            return 1;
        }
        switch (modelNode.getNodeType()) {
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: {
                return 2;
            }
        }
        if (this.getXmlMetadataResolver().isHidden(modelNode)) {
            return 2;
        }
        Node realParent = modelNode.getParentNode();
        if (realParent != null && DomUtils.isDocument((Node)realParent.getParentNode()) && this._before.isNodeWithoutCategory(modelNode)) {
            return 2;
        }
        return super.acceptNode(modelNode);
    }

    protected final XmlModelEvent transformModelEventHook(XmlModelEvent modelChangeEvent) {
        Node changeRoot = modelChangeEvent.getChangeRoot();
        PropertyChange documentChange = modelChangeEvent.getDomDocumentPropertyChange();
        if (documentChange != null) {
            this._before.updateCache(changeRoot, true);
        } else if (changeRoot != null && modelChangeEvent.isDomStructureChanged()) {
            this._before.updateCache(changeRoot, false);
        }
        return super.transformModelEventHook(modelChangeEvent);
    }

    final boolean __isRootNode(Node node) {
        return this.isRootNode(this.getNodeXmlKey(node), node);
    }

    private static final class Traversal
    extends FilteredViewTreeTraversal {
        private TreeTraversal _before;

        public Traversal(CategorizedView view, TreeTraversal before) {
            super(view);
            this._before = before;
        }

        protected TreeTraversal getBeforeTraversal() {
            return this._before;
        }
    }

    private static final class BeforeTraversal
    extends TreeTraversal {
        private List _categories;
        private List _children;
        private HashMap _keys;
        private HashMap _creationKeys;
        private HashMap _childNameToIndex;
        private HashMap _childIsCategorized;
        private HashMap _childToFakeParent;
        private HashMap _fakeChildToFakeChildChildren;
        private CategorizedView _view;

        public BeforeTraversal(XmlView view) {
            this.$init$();
            this._view = (CategorizedView)view;
        }

        public void dispose() {
            this._view = null;
        }

        public boolean isFake(Node node) {
            return node == null ? false : CategorizedView._FAKE_NAMESPACE.equals(node.getNamespaceURI());
        }

        public boolean isFake(XmlKey key) {
            return key == null ? false : CategorizedView._FAKE_NAMESPACE.equals(key.getNamespace());
        }

        public XmlKey getKey(Node node) {
            this._createFakeChildren(node);
            return (XmlKey)this._keys.get(node);
        }

        public List getCreationKeys(Node node) {
            List keys;
            this._createFakeChildren(node);
            if (this._creationKeys == null) {
                this._creationKeys = new HashMap(this._categories.size());
            }
            if ((keys = (List)this._creationKeys.get(node)) == null) {
                keys = this._view.getCreationKeys(DomUtils.getLocalName((Node)node));
                this._creationKeys.put(node, keys);
            }
            return keys == Collections.EMPTY_LIST ? null : keys;
        }

        public boolean isNodeWithoutCategory(Node node) {
            this._createFakeChildren(node);
            return this._getNodeCategoryIndex(node) == -1;
        }

        public Node getParentNode(Node node) {
            if (this.isFake(node)) {
                return node.getOwnerDocument().getDocumentElement();
            }
            if (DomUtils.asElement((Node)node) != null && node.getParentNode() == node.getOwnerDocument().getDocumentElement()) {
                return this._findParent(node);
            }
            return node.getParentNode();
        }

        public Node getFirstChild(Node node) {
            if (this.isFake(node)) {
                return this._getFirstChild(node);
            }
            if (this._view.__isRootNode(node)) {
                return this._getFirstFakeChild(node);
            }
            return node.getFirstChild();
        }

        public Node getLastChild(Node node) {
            if (this.isFake(node)) {
                return this._getLastChild(node);
            }
            if (this._view.__isRootNode(node)) {
                return this._getLastFakeChild(node);
            }
            return node.getLastChild();
        }

        public Node getNextSibling(Node node) {
            if (this.isFake(node)) {
                return this._getNextFakeChild(node);
            }
            if (node.getParentNode() == node.getOwnerDocument().getDocumentElement()) {
                return this._getNextChild(node);
            }
            return node.getNextSibling();
        }

        public Node getPreviousSibling(Node node) {
            if (this.isFake(node)) {
                return this._getPreviousFakeChild(node);
            }
            if (node.getParentNode() == node.getOwnerDocument().getDocumentElement()) {
                return this._getPreviousChild(node);
            }
            return node.getPreviousSibling();
        }

        public void updateCache(Node subtreeNode, boolean docChange) {
            this._fakeChildToFakeChildChildren.clear();
            this._childToFakeParent.clear();
            this._childIsCategorized.clear();
            if (docChange) {
                if (this._children != null) {
                    this._children.clear();
                    this._keys.clear();
                    this._childNameToIndex.clear();
                }
                this._children = null;
            }
        }

        private void _createFakeChildren(Node node) {
            if (this._children == null) {
                this._fakeChildToFakeChildChildren.clear();
                List categories = this._view.getCategories();
                if (categories == null) {
                    throw new IllegalArgumentException("No categories!");
                }
                this._categories = Collections.unmodifiableList(categories);
                int count = this._categories.size();
                this._children = new ArrayList(count);
                this._keys = new HashMap(count);
                Document document = DomUtils.getOwnerDocument((Node)node);
                int i = 0;
                for (String category : this._categories) {
                    StandaloneElement n = new StandaloneElement(document, CategorizedView._FAKE_NAMESPACE, null, category);
                    this._children.add(n);
                    this._keys.put(n, ImmutableXmlKey.createElementKey((String)CategorizedView._FAKE_NAMESPACE, (String)category).intern());
                    this._childNameToIndex.put(category, IntegerUtils.getInteger((int)i++));
                }
            }
        }

        private Node _getFirstFakeChild(Node node) {
            this._createFakeChildren(node);
            return (Node)this._children.get(0);
        }

        private Node _getLastFakeChild(Node node) {
            this._createFakeChildren(node);
            return (Node)this._children.get(this._children.size() - 1);
        }

        private Node _getNextFakeChild(Node node) {
            this._createFakeChildren(node);
            Integer i = (Integer)this._childNameToIndex.get(DomUtils.getLocalName((Node)node));
            int index = i;
            return index == this._children.size() - 1 ? null : (Node)this._children.get(index + 1);
        }

        private Node _getPreviousFakeChild(Node node) {
            this._createFakeChildren(node);
            Integer i = (Integer)this._childNameToIndex.get(DomUtils.getLocalName((Node)node));
            int index = i;
            return index == 0 ? null : (Node)this._children.get(index - 1);
        }

        private Node _findParent(Node node) {
            this._createFakeChildren(node);
            Object parent = this._childToFakeParent.get(node);
            if (parent == null) {
                int index = this._getNodeCategoryIndex(node);
                parent = index == -1 ? node.getParentNode() : this._children.get(index);
                this._childToFakeParent.put(node, parent);
            }
            return (Node)parent;
        }

        private int _getNodeCategoryIndex(Node node) {
            String category = this._view.getCategory(node);
            int index = category == null ? -1 : this._categories.indexOf(category);
            return index;
        }

        private Node _getFirstChild(Node node) {
            List list = this._getChildren(node);
            return list.size() > 0 ? (Node)list.get(0) : null;
        }

        private Node _getLastChild(Node node) {
            List list = this._getChildren(node);
            return list.size() > 0 ? (Node)list.get(list.size() - 1) : null;
        }

        private Node _getNextChild(Node node) {
            Node fakeParent = this._findParent(node);
            if (this.isFake(fakeParent)) {
                List list = this._getChildren(fakeParent);
                int index = list.indexOf(node);
                return index == list.size() - 1 ? null : (Node)list.get(index + 1);
            }
            return node.getNextSibling();
        }

        private Node _getPreviousChild(Node node) {
            Node fakeParent = this._findParent(node);
            if (this.isFake(fakeParent)) {
                List list = this._getChildren(fakeParent);
                int index = list.indexOf(node);
                return index == 0 ? null : (Node)list.get(index - 1);
            }
            return node.getPreviousSibling();
        }

        private List _getChildren(Node node) {
            List children = (List)this._fakeChildToFakeChildChildren.get(node);
            if (children == null) {
                Element root = node.getOwnerDocument().getDocumentElement();
                children = this._findChildren(root, DomUtils.getLocalName((Node)node));
                this._fakeChildToFakeChildChildren.put(node, children);
            }
            return children;
        }

        private List _findChildren(Element root, String name) {
            NodeList children = root.getChildNodes();
            if (children.getLength() == 0) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<Node> list = Collections.EMPTY_LIST;
            int i = 0;
            while (i < children.getLength()) {
                String category;
                Node n = children.item(i);
                if (this._childIsCategorized.get(n) == null && name.equals(category = this._view.getCategory(n))) {
                    this._childIsCategorized.put(n, Boolean.TRUE);
                    if (list == Collections.EMPTY_LIST) {
                        list = new ArrayList<Node>();
                    }
                    list.add(n);
                }
                ++i;
            }
            return list;
        }

        private void $init$() {
            this._childNameToIndex = new HashMap();
            this._childIsCategorized = new HashMap();
            this._childToFakeParent = new HashMap();
            this._fakeChildToFakeChildChildren = new HashMap();
        }

        static Node mav$_getLastChild(BeforeTraversal beforeTraversal, Node node) {
            return beforeTraversal._getLastChild(node);
        }

        static Node mav$_getFirstChild(BeforeTraversal beforeTraversal, Node node) {
            return beforeTraversal._getFirstChild(node);
        }

        static Node mav$_getPreviousFakeChild(BeforeTraversal beforeTraversal, Node node) {
            return beforeTraversal._getPreviousFakeChild(node);
        }

        static Node mav$_getNextFakeChild(BeforeTraversal beforeTraversal, Node node) {
            return beforeTraversal._getNextFakeChild(node);
        }
    }

    private class CategorizedMetadataResolver
    extends XmlMetadataResolver {
        public CategorizedMetadataResolver(MetadataEvaluator evaluator, XmlView view) {
            super(evaluator, view);
        }

        protected boolean isTransferableImpl(XmlKey key, Node node) {
            return this._isRootOrCategory(key, node) ? false : super.isTransferableImpl(key, node);
        }

        protected boolean isDeletableImpl(XmlKey key, Node node) {
            return this._isRootOrCategory(key, node) ? false : super.isDeletableImpl(key, node);
        }

        protected boolean isImmutableImpl(XmlKey key, Node node) {
            return CategorizedView.this.isCategoryNodeKey(key) ? true : super.isImmutableImpl(key, node);
        }

        public boolean isSurroundable(Node[] nodes) {
            if (nodes == null || nodes.length == 0) {
                return false;
            }
            int i = 0;
            while (i < nodes.length) {
                XmlKey key = this.getNodeXmlKey(nodes[i]);
                if (this._isRootOrCategory(key, nodes[i])) {
                    return false;
                }
                ++i;
            }
            return super.isSurroundable(nodes);
        }

        public boolean isConvertible(Node n) {
            if (n == null) {
                return false;
            }
            return this._isRootOrCategory(this.getNodeXmlKey(n), n) ? false : super.isConvertible(n);
        }

        private boolean _isRootOrCategory(XmlKey key, Node node) {
            return CategorizedView.this.isRootNode(key, node) || CategorizedView.this.isCategoryNodeKey(key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CategorizedMetadataEvaluator
    implements MetadataEvaluator {
        public Object getMetadataItem(Object key, Object itemKey, Node node) {
            XmlKey xmlKey = (XmlKey)key;
            if (CategorizedView.this.isCategoryNodeKey(xmlKey)) {
                return CategorizedView.this.getCategoryMetadataItem((QualifiedName)itemKey, xmlKey.getLocalName());
            }
            return CategorizedView.this.getBaseModel().getXmlMetadataResolver().getMetadataEvaluator().getMetadataItem(key, itemKey, node);
        }

        public List<StructuredMetadataBean> getGlobalMetadata(QualifiedName globalItemName) {
            return CategorizedView.this.getBaseModel().getXmlMetadataResolver().getMetadataEvaluator().getGlobalMetadata(globalItemName);
        }

        public Collection getPseudoXmlKeys(Object baseKey) {
            return CategorizedView.this.getBaseModel().getXmlMetadataResolver().getMetadataEvaluator().getPseudoXmlKeys(baseKey);
        }

        private CategorizedMetadataEvaluator() {
        }

        CategorizedMetadataEvaluator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

