/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.view;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.SetChangeEvent;
import oracle.bali.xml.model.SetChangeListener;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.share.PropertyChange;
import org.w3c.dom.Node;

class ViewSelection
extends Selection {
    private transient Set _selectionsAdded;
    private transient Set _selectionsRemoved;
    private transient DomPosition _oldCursorLocation;
    private transient boolean _propagateCursor;
    private transient DomPosition _oldDropLocation;
    private transient boolean _propagateDrop;
    private transient boolean _propagatingToModel;

    public ViewSelection(XmlView view) {
        super(view);
        SelectionChangeListener changeListener = new SelectionChangeListener(null);
        this.addSelectionChangeListener(changeListener);
        this.addPropertyChangeListener(changeListener);
    }

    public XmlView getView() {
        return (XmlView)this.getModel();
    }

    public XmlModelEvent updateSelection(XmlModelEvent changeEvent) {
        XmlModelEvent outEvent = changeEvent;
        boolean propertyChanged = changeEvent.isPropertyChanged();
        boolean selectionChanged = changeEvent.isSelectionChanged();
        if (this._propagatingToModel || propertyChanged || selectionChanged) {
            XmlView view = this.getView();
            boolean needsTransformToView = changeEvent.getModel() != view;
            DomPosition newViewCursor = null;
            DomPosition oldViewCursor = null;
            DomPosition newViewDrop = null;
            DomPosition oldViewDrop = null;
            boolean cursorChanged = false;
            boolean dropChanged = false;
            if (propertyChanged || this._propagateCursor || this._propagateDrop) {
                DomPosition modelDrop;
                DomPosition eventCursor;
                PropertyChange cursorChange = changeEvent.getCursorLocationPropertyChange();
                DomPosition domPosition = eventCursor = cursorChange != null ? (DomPosition)cursorChange.getNewValue() : null;
                if (this._propagateCursor) {
                    newViewCursor = this.getCursorLocation();
                    oldViewCursor = this._oldCursorLocation;
                } else if (cursorChange != null) {
                    if (eventCursor != null) {
                        if (needsTransformToView) {
                            newViewCursor = view.modelToView(eventCursor);
                            oldViewCursor = this.getCursorLocation();
                        } else {
                            newViewCursor = eventCursor;
                            oldViewCursor = (DomPosition)cursorChange.getOldValue();
                        }
                    }
                    this.setCursorLocationImpl(newViewCursor);
                }
                cursorChanged = ViewSelection._isEqual(newViewCursor, eventCursor) ^ true;
                PropertyChange dropChange = changeEvent.getDropLocationPropertyChange();
                DomPosition domPosition2 = modelDrop = dropChange != null ? (DomPosition)dropChange.getNewValue() : null;
                if (this._propagateDrop) {
                    newViewDrop = this.getDropLocation();
                    oldViewDrop = this._oldDropLocation;
                } else if (dropChange != null) {
                    if (modelDrop != null) {
                        newViewDrop = view.modelToView(modelDrop);
                        oldViewDrop = this.getDropLocation();
                    }
                    this.setDropLocationImpl(newViewDrop);
                }
                dropChanged = ViewSelection._isEqual(newViewDrop, modelDrop) ^ true;
            }
            Set viewSelectionsAdded = null;
            Set<Node> viewSelectionsRemoved = null;
            boolean selectionsAddedChanged = false;
            boolean selectionsRemovedChanged = false;
            boolean selectionCleared = changeEvent.isSelectionCleared();
            if (selectionChanged || selectionCleared || this._selectionsAdded != null || this._selectionsRemoved != null) {
                Set<Node> eventSelectionsAdded = changeEvent.getSelectionsAdded();
                Set<Node> eventSelectionsRemoved = changeEvent.getSelectionsRemoved();
                viewSelectionsAdded = this._selectionsAdded;
                viewSelectionsRemoved = this._selectionsRemoved;
                Set<Node> viewPrivateNodesToAdd = null;
                if (needsTransformToView) {
                    if (viewSelectionsAdded == null) {
                        viewSelectionsAdded = view.modelNodeSetToViewNodeSet(eventSelectionsAdded, null);
                    }
                    if (viewSelectionsRemoved == null) {
                        viewSelectionsRemoved = selectionCleared || changeEvent.getDomDocumentPropertyChange() != null ? new HashSet<Node>(this.getSelectedNodeSet()) : view.modelNodeSetToViewNodeSet(eventSelectionsRemoved, null);
                    }
                    selectionsAddedChanged = eventSelectionsAdded != viewSelectionsAdded;
                    selectionsRemovedChanged = eventSelectionsRemoved != viewSelectionsRemoved;
                } else if (eventSelectionsAdded != null && !eventSelectionsAdded.isEmpty()) {
                    viewPrivateNodesToAdd = eventSelectionsAdded;
                }
                if (viewPrivateNodesToAdd != null || this._selectionsAdded == null || this._selectionsRemoved == null) {
                    LinkedHashSet storage = this.getSelectedNodeStorage();
                    storage.clear();
                    view.modelNodeIteratorToViewNodeSet(view.getBaseModel().getSelection().getSelectedNodes(), storage);
                }
                if (viewPrivateNodesToAdd != null) {
                    LinkedHashSet storage = this.getSelectedNodeStorage();
                    storage.addAll(viewPrivateNodesToAdd);
                }
            }
            if (cursorChanged || dropChanged || selectionsAddedChanged || selectionsRemovedChanged) {
                HashMap<String, PropertyChange> propertyChanges = changeEvent.getPropertyChanges();
                if (cursorChanged || dropChanged) {
                    propertyChanges = new HashMap<String, PropertyChange>(propertyChanges);
                    if (cursorChanged) {
                        String propertyName = "cursorLocation";
                        PropertyChange cursorChange = PropertyChange.getPropertyChange(propertyName, oldViewCursor, newViewCursor);
                        if (cursorChange != null) {
                            propertyChanges.put(propertyName, cursorChange);
                        } else {
                            propertyChanges.remove(propertyName);
                        }
                    }
                    if (dropChanged) {
                        String propertyName = "dropLocation";
                        PropertyChange dropChange = PropertyChange.getPropertyChange(propertyName, oldViewDrop, newViewDrop);
                        if (dropChange != null) {
                            propertyChanges.put(propertyName, dropChange);
                        } else {
                            propertyChanges.remove(propertyName);
                        }
                    }
                }
                XmlModelEvent selectionChanges = new XmlModelEvent(view, null, 0, propertyChanges, viewSelectionsAdded, viewSelectionsRemoved, null, null);
                if (needsTransformToView) {
                    outEvent = selectionChanges;
                } else {
                    outEvent = outEvent.getMutableEvent();
                    outEvent.addModelEvent(selectionChanges);
                }
            }
            this._selectionsAdded = null;
            this._selectionsRemoved = null;
            this._oldCursorLocation = null;
            this._propagateCursor = false;
            this._oldDropLocation = null;
            this._propagateDrop = false;
            this._propagatingToModel = false;
        }
        return outEvent;
    }

    public DomPosition setCursorLocation(DomPosition newCursorLocation) {
        DomPosition viewPosition = super.setCursorLocation(newCursorLocation);
        XmlView view = this.getView();
        DomPosition modelPosition = view.viewToModel(viewPosition);
        view.getBaseModel().getSelection().setCursorLocation(modelPosition);
        return viewPosition;
    }

    public DomPosition setDropLocation(DomPosition newDropLocation) {
        DomPosition viewPosition = super.setDropLocation(newDropLocation);
        XmlView view = this.getView();
        DomPosition modelPosition = view.viewToModel(viewPosition);
        view.getBaseModel().getSelection().setDropLocation(modelPosition);
        return viewPosition;
    }

    public boolean clear() {
        this.getModel().getBaseModel().getSelection().clear();
        return super.clear();
    }

    protected boolean removeImpl(Node viewNode) {
        XmlView view = this.getView();
        Node modelNode = view.viewToModel(viewNode);
        if (modelNode != null) {
            ViewSelection.removeNodeDirectly(view.getBaseModel().getSelection(), modelNode);
        }
        return ViewSelection.removeNodeDirectly(this, viewNode);
    }

    protected boolean addImpl(Node viewNode) {
        XmlView view = this.getView();
        Node modelNode = view.viewToModel(viewNode);
        if (modelNode != null) {
            ViewSelection.addNodeDirectly(view.getBaseModel().getSelection(), modelNode);
        }
        return ViewSelection.addNodeDirectly(this, viewNode);
    }

    private static boolean _isEqual(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    static void wa$_selectionsAdded(ViewSelection viewSelection, Set set) {
        viewSelection._selectionsAdded = set;
    }

    static void wa$_selectionsRemoved(ViewSelection viewSelection, Set set) {
        viewSelection._selectionsRemoved = set;
    }

    static void wa$_propagatingToModel(ViewSelection viewSelection, boolean bl) {
        viewSelection._propagatingToModel = bl;
    }

    static void wa$_oldDropLocation(ViewSelection viewSelection, DomPosition domPosition) {
        viewSelection._oldDropLocation = domPosition;
    }

    static void wa$_propagateDrop(ViewSelection viewSelection, boolean bl) {
        viewSelection._propagateDrop = bl;
    }

    static void wa$_oldCursorLocation(ViewSelection viewSelection, DomPosition domPosition) {
        viewSelection._oldCursorLocation = domPosition;
    }

    static void wa$_propagateCursor(ViewSelection viewSelection, boolean bl) {
        viewSelection._propagateCursor = bl;
    }

    private class SelectionChangeListener
    implements SetChangeListener,
    PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent event) {
            String propertyName = event.getPropertyName();
            if ("dropLocation".equals(propertyName)) {
                ViewSelection.wa$_oldDropLocation(ViewSelection.this, (DomPosition)event.getOldValue());
                ViewSelection.wa$_propagateDrop(ViewSelection.this, true);
                ViewSelection.wa$_propagatingToModel(ViewSelection.this, true);
            } else if ("cursorLocation".equals(propertyName)) {
                ViewSelection.wa$_oldCursorLocation(ViewSelection.this, (DomPosition)event.getOldValue());
                ViewSelection.wa$_propagateCursor(ViewSelection.this, true);
                ViewSelection.wa$_propagatingToModel(ViewSelection.this, true);
            }
        }

        public void setChanged(SetChangeEvent event) {
            ViewSelection.wa$_selectionsAdded(ViewSelection.this, event.getAddedObjects());
            ViewSelection.wa$_selectionsRemoved(ViewSelection.this, event.getRemovedObjects());
            ViewSelection.wa$_propagatingToModel(ViewSelection.this, true);
        }

        private SelectionChangeListener() {
        }

        SelectionChangeListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

