/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionCollectionIterator<T>
implements Iterator<T> {
    private Iterator<? extends T> _innerIterator;
    private final Iterator<? extends Collection<? extends T>> _outerIterator;

    public CollectionCollectionIterator(Collection<? extends Collection<? extends T>> realCollection) {
        this.$init$();
        if (realCollection == null) {
            throw new IllegalArgumentException("null collection");
        }
        this._outerIterator = realCollection.iterator();
        this._advanceToNextInner();
    }

    @Override
    public boolean hasNext() {
        if (this._innerIterator == null) {
            this._advanceToNextInner();
        }
        if (this._innerIterator == null) {
            return false;
        }
        return this._innerIterator.hasNext();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T next = this._innerIterator.next();
        if (!this._innerIterator.hasNext()) {
            this._innerIterator = null;
            this._advanceToNextInner();
        }
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not allowed");
    }

    private void _advanceToNextInner() {
        while (this._outerIterator.hasNext()) {
            Collection<T> collection = this._outerIterator.next();
            if (collection == null || collection.isEmpty()) continue;
            this._innerIterator = collection.iterator();
            break;
        }
    }

    private void $init$() {
        this._innerIterator = null;
    }
}

