/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import oracle.bali.xml.share.ReverseListIterator;

public class MultiUndoableEdit
implements UndoableEdit {
    private final UndoableEdit _first;
    private final List _edits;

    public static UndoableEdit createEdit(List edits) {
        if (edits == null || edits.isEmpty()) {
            return null;
        }
        if (edits.size() == 1) {
            return (UndoableEdit)edits.get(0);
        }
        return new MultiUndoableEdit(new ArrayList(edits));
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        this._do(true);
    }

    public boolean canUndo() {
        return this._can(true);
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotUndoException();
        }
        this._do(false);
    }

    public boolean canRedo() {
        return this._can(false);
    }

    public void die() {
        for (UndoableEdit edit : this._edits) {
            edit.die();
        }
    }

    public boolean addEdit(UndoableEdit anEdit) {
        return false;
    }

    public boolean replaceEdit(UndoableEdit anEdit) {
        return false;
    }

    public boolean isSignificant() {
        for (UndoableEdit edit : this._edits) {
            if (!edit.isSignificant()) continue;
            return true;
        }
        return false;
    }

    public String getPresentationName() {
        return this._first.getPresentationName();
    }

    public String getUndoPresentationName() {
        return this._first.getUndoPresentationName();
    }

    public String getRedoPresentationName() {
        return this._first.getRedoPresentationName();
    }

    public String toString() {
        return super.toString() + " edits: " + this._edits;
    }

    private boolean _can(boolean isUndo) {
        for (UndoableEdit edit : this._edits) {
            boolean cur;
            boolean bl = cur = isUndo ? edit.canUndo() : edit.canRedo();
            if (cur) continue;
            return false;
        }
        return true;
    }

    private void _do(boolean isUndo) {
        Iterator itor = ReverseListIterator.getIterator(this._edits, isUndo ^ true);
        while (itor.hasNext()) {
            UndoableEdit edit = (UndoableEdit)itor.next();
            if (isUndo) {
                edit.undo();
                continue;
            }
            edit.redo();
        }
    }

    private MultiUndoableEdit(List edits) {
        this._edits = edits;
        this._first = (UndoableEdit)edits.get(0);
    }
}

