/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyChange {
    private String _propertyName;
    private Object _oldValue;
    private Object _newValue;
    private transient int _hashCode;

    public PropertyChange(PropertyChangeEvent event) {
        this(event.getPropertyName(), event.getOldValue(), event.getNewValue());
    }

    public PropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Property name required");
        }
        this._propertyName = propertyName;
        this._oldValue = oldValue;
        this._newValue = newValue;
        int hashCode = propertyName.hashCode();
        if (oldValue != null) {
            hashCode ^= oldValue.hashCode() * 7;
        }
        if (newValue != null) {
            hashCode ^= newValue.hashCode() * 49;
        }
        this._hashCode = hashCode;
    }

    public static PropertyChange getPropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (!(oldValue == newValue || oldValue != null && oldValue.equals(newValue))) {
            return new PropertyChange(propertyName, oldValue, newValue);
        }
        return null;
    }

    public static PropertyChange mergePropertyChange(PropertyChange oldPropertyChange, PropertyChange newPropertyChange) {
        if (newPropertyChange == null) {
            return oldPropertyChange;
        }
        if (oldPropertyChange == null) {
            return newPropertyChange;
        }
        String oldPropertyName = oldPropertyChange.getPropertyName();
        if (!oldPropertyName.equals(newPropertyChange.getPropertyName())) {
            throw new IllegalArgumentException(oldPropertyChange + " and " + newPropertyChange + " have different property names");
        }
        Object oldNewValue = oldPropertyChange.getNewValue();
        Object newValue = newPropertyChange.getNewValue();
        Object oldOldValue = oldPropertyChange.getOldValue();
        if (PropertyChange._eq(oldNewValue, newValue)) {
            return oldPropertyChange;
        }
        if (PropertyChange._eq(oldOldValue, newValue)) {
            return null;
        }
        return PropertyChange.getPropertyChange(oldPropertyName, oldPropertyChange.getOldValue(), newValue);
    }

    public final PropertyChange mergePropertyChange(PropertyChange newPropertyChange) {
        return PropertyChange.mergePropertyChange(this, newPropertyChange);
    }

    public static Map<String, PropertyChange> mergePropertyChangeToMap(Map<String, PropertyChange> map, PropertyChange newChange) {
        return PropertyChange._mergePropertyChangeToMap(map, newChange, true);
    }

    public static Map<String, PropertyChange> mergePropertyChangeMaps(Map<String, PropertyChange> oldPropertyChangeMap, Map<String, PropertyChange> newPropertyChangeMap, Map<String, PropertyChange> mutableMap) {
        if (newPropertyChangeMap == null || newPropertyChangeMap.isEmpty()) {
            return oldPropertyChangeMap;
        }
        if (oldPropertyChangeMap == null || oldPropertyChangeMap.isEmpty()) {
            return newPropertyChangeMap;
        }
        Map<String, PropertyChange> mergedMap = mutableMap;
        if (mergedMap == null) {
            mergedMap = new HashMap<String, PropertyChange>(oldPropertyChangeMap);
        } else if (mergedMap != oldPropertyChangeMap) {
            mergedMap.clear();
            mergedMap.putAll(oldPropertyChangeMap);
        }
        for (Map.Entry<String, PropertyChange> currEntry : newPropertyChangeMap.entrySet()) {
            PropertyChange newPropertyChange = currEntry.getValue();
            mergedMap = PropertyChange._mergePropertyChangeToMap(mergedMap, newPropertyChange, false);
        }
        return mergedMap;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    public Object getOldValue() {
        return this._oldValue;
    }

    public Object getNewValue() {
        return this._newValue;
    }

    public final boolean getOldBooleanValue() {
        return Boolean.TRUE.equals(this.getOldValue());
    }

    public final boolean getNewBooleanValue() {
        return Boolean.TRUE.equals(this.getNewValue());
    }

    public int hashCode() {
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != PropertyChange.class || obj.hashCode() != this.hashCode()) {
            return false;
        }
        PropertyChange o = (PropertyChange)obj;
        return PropertyChange._eq(o.getPropertyName(), this.getPropertyName()) && PropertyChange._eq(o.getOldValue(), this.getOldValue()) && PropertyChange._eq(o.getNewValue(), this.getNewValue());
    }

    public String toString() {
        return this._propertyName + ": " + this._oldValue + " --> " + this._newValue;
    }

    private static boolean _eq(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    private static Map<String, PropertyChange> _mergePropertyChangeToMap(Map<String, PropertyChange> map, PropertyChange newChange, boolean checkMapMutability) {
        PropertyChange mergedChange;
        String propertyName = newChange.getPropertyName();
        PropertyChange currChange = map.get(propertyName);
        if (currChange != (mergedChange = PropertyChange.mergePropertyChange(currChange, newChange))) {
            if (checkMapMutability && !(map instanceof HashMap)) {
                map = new HashMap<String, PropertyChange>(map);
            }
            if (mergedChange == null) {
                map.remove(propertyName);
            } else {
                map.put(propertyName, mergedChange);
            }
        }
        return map;
    }
}

