/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.bali.share.util.BooleanUtils;
import oracle.bali.share.util.ClassLoaderUtils;
import oracle.bali.share.util.UnhandledException;
import oracle.bali.xml.share.BaliXmlProvider;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ReflectiveXerces1XmlProvider
implements BaliXmlProvider {
    public static final BaliXmlProvider INSTANCE = new ReflectiveXerces1XmlProvider();
    private static Class _SAX_PARSER_CLASS;
    private static Class _DOM_PARSER_CLASS;
    private static Method _DOM_PARSE_METHOD;
    private static Method _DOM_GET_DOCUMENT_METHOD;
    private static Method _SET_FEATURE_METHOD;
    private static final String _DOM_PARSER_NAME = "org.apache.xerces.parsers.DOMParser";
    private static final String _SAX_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    private static final String _SET_FEATURE_METHOD_NAME = "setFeature";
    private static final String _DOM_PARSE_METHOD_NAME = "parse";
    private static final String _DOM_GET_DOCUMENT_METHOD_NAME = "getDocument";
    private static final String _VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    private static final String _VALIDATION_DYNAMIC_FEATURE = "http://apache.org/xml/features/validation/dynamic";
    private static final String _LOAD_DTD_GRAMMAR_FEATURE = "http://apache.org/xml/features/nonvalidating/load-dtd-grammar";
    private static final String _LOAD_EXTERNAL_DTD_FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";

    private ReflectiveXerces1XmlProvider() {
    }

    public DOMImplementation getDOMImplementation() {
        try {
            Class implClass = ClassLoaderUtils.loadClass((String)"org.apache.xerces.dom.DOMImplementationImpl");
            Method getter = implClass.getMethod("getDOMImplementation", new Class[0]);
            DOMImplementation dOMImplementation = (DOMImplementation)getter.invoke(null, new Object[0]);
            return dOMImplementation;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            throw new UnhandledException(t);
        }
    }

    public XMLReader getXMLReader() {
        try {
            if (_SAX_PARSER_CLASS == null) {
                _SAX_PARSER_CLASS = ClassLoaderUtils.loadClass((String)_SAX_PARSER_NAME);
            }
            XMLReader xMLReader = (XMLReader)_SAX_PARSER_CLASS.newInstance();
            return xMLReader;
        }
        catch (InstantiationException e) {
            throw new UnhandledException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new UnhandledException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    public Document parseDocument(InputSource source) throws IOException, SAXException {
        try {
            if (_DOM_GET_DOCUMENT_METHOD == null) {
                _DOM_PARSER_CLASS = ClassLoaderUtils.loadClass((String)_DOM_PARSER_NAME);
                _DOM_PARSE_METHOD = _DOM_PARSER_CLASS.getMethod(_DOM_PARSE_METHOD_NAME, InputSource.class);
                _DOM_GET_DOCUMENT_METHOD = _DOM_PARSER_CLASS.getMethod(_DOM_GET_DOCUMENT_METHOD_NAME, new Class[0]);
            }
            Object parser = _DOM_PARSER_CLASS.newInstance();
            this._setFeature(parser, _VALIDATION_FEATURE, false);
            this._setFeature(parser, _VALIDATION_DYNAMIC_FEATURE, false);
            this._setFeature(parser, _LOAD_DTD_GRAMMAR_FEATURE, false);
            this._setFeature(parser, _LOAD_EXTERNAL_DTD_FEATURE, false);
            _DOM_PARSE_METHOD.invoke(parser, source);
            Object doc = _DOM_GET_DOCUMENT_METHOD.invoke(parser, new Object[0]);
            Document document = (Document)doc;
            return document;
        }
        catch (InstantiationException e) {
            throw new UnhandledException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new UnhandledException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new UnhandledException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new UnhandledException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            if (realException instanceof IOException) {
                throw (IOException)realException;
            }
            if (realException instanceof SAXException) {
                throw (SAXException)realException;
            }
            if (realException instanceof RuntimeException) {
                throw (RuntimeException)realException;
            }
            throw new UnhandledException(e.getTargetException());
        }
    }

    private void _setFeature(Object receiver, String feature, boolean value) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (_SET_FEATURE_METHOD == null) {
            _SET_FEATURE_METHOD = _DOM_PARSER_CLASS.getMethod(_SET_FEATURE_METHOD_NAME, String.class, Boolean.TYPE);
        }
        _SET_FEATURE_METHOD.invoke(receiver, feature, BooleanUtils.getBoolean((boolean)value));
    }
}

