/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.share.util.BooleanUtils;
import oracle.bali.share.util.IntegerUtils;
import oracle.bali.xml.share.SafeListenerManager;

public class SafePropertyChangeSupport {
    private final Object _sourceBean;
    private final SafeListenerManager _manager;

    public SafePropertyChangeSupport(Object sourceBean) {
        this.$init$();
        if (sourceBean == null) {
            throw new NullPointerException("Source bean can not be null!");
        }
        this._sourceBean = sourceBean;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._manager.addListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._manager.removeListener(listener);
    }

    public boolean hasListeners() {
        return this._manager.isEmpty() ^ true;
    }

    public void firePropertyChanges(Collection changeCollection) {
        Iterator listeners = this._manager.iterator();
        while (listeners.hasNext()) {
            PropertyChangeListener listener = (PropertyChangeListener)listeners.next();
            for (Object nextChange : changeCollection) {
                if (!(nextChange instanceof PropertyChangeEvent)) continue;
                try {
                    listener.propertyChange((PropertyChangeEvent)nextChange);
                }
                catch (RuntimeException re) {
                    Logger.getLogger(this._sourceBean.getClass().getName()).log(Level.WARNING, "Uncaught exception during event dispatching: event=" + nextChange + " listener=" + listener, re);
                }
            }
        }
    }

    public void firePropertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName() != null) {
            Object oldValue = event.getOldValue();
            Object newValue = event.getNewValue();
            if (oldValue != null && oldValue.equals(newValue)) {
                return;
            }
        }
        Iterator itor = this._manager.iterator();
        while (itor.hasNext()) {
            PropertyChangeListener listener = (PropertyChangeListener)itor.next();
            listener.propertyChange(event);
        }
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.firePropertyChange(new PropertyChangeEvent(this._sourceBean, propertyName, oldValue, newValue));
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.firePropertyChange(propertyName, BooleanUtils.getBoolean((boolean)oldValue), BooleanUtils.getBoolean((boolean)newValue));
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.firePropertyChange(propertyName, IntegerUtils.getInteger((int)oldValue), IntegerUtils.getInteger((int)newValue));
    }

    private void $init$() {
        this._manager = new SafeListenerManager();
    }
}

