/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share.clipboard;

import java.awt.GraphicsEnvironment;
import javax.swing.SwingUtilities;
import oracle.bali.share.util.ClassLoaderUtils;
import oracle.bali.xml.share.clipboard.ClipboardManager;
import oracle.bali.xml.share.clipboard.PollingClipboardManager;
import oracle.bali.xml.share.clipboard.StandaloneClipboardManager;

public abstract class AWTClipboardManager
extends ClipboardManager {
    private static final String _JDK15_CLASS_NAME = "oracle.bali.xml.share.clipboard.Jdk15AWTClipboardManager";
    private static final ClipboardManager _sINSTANCE = AWTClipboardManager._sCreate();

    public static ClipboardManager getClipboardManager() {
        return _sINSTANCE;
    }

    protected void notifyFlavorListeners() {
        if (this.areFlavorListenersAttached()) {
            SwingUtilities.invokeLater(new 1());
        }
    }

    private void _notifyFlavorListenersNow() {
        super.notifyFlavorListeners();
    }

    private static boolean _sAtLeastJDK15() {
        String specVerStr = System.getProperty("java.specification.version");
        if (specVerStr == null) {
            return false;
        }
        try {
            float specVerFloat = Float.parseFloat(specVerStr);
            boolean bl = specVerFloat >= 1.5f;
            return bl;
        }
        catch (NumberFormatException e) {
            boolean bl = false;
            return bl;
        }
    }

    private static ClipboardManager _sCreate() {
        if (GraphicsEnvironment.isHeadless()) {
            return new StandaloneClipboardManager();
        }
        if (AWTClipboardManager._sAtLeastJDK15()) {
            try {
                Class c = ClassLoaderUtils.loadClass((String)_JDK15_CLASS_NAME);
                Object instance = c.newInstance();
                if (instance instanceof AWTClipboardManager) {
                    AWTClipboardManager aWTClipboardManager = (AWTClipboardManager)instance;
                    return aWTClipboardManager;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return new PollingClipboardManager();
    }

    static void mav$_notifyFlavorListenersNow(AWTClipboardManager aWTClipboardManager) {
        aWTClipboardManager._notifyFlavorListenersNow();
    }

    final class 1
    implements Runnable {
        public void run() {
            AWTClipboardManager.mav$_notifyFlavorListenersNow(AWTClipboardManager.this);
        }
    }
}

