/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share.clipboard;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.logging.Level;
import oracle.bali.xml.share.clipboard.AWTClipboardManager;
import oracle.bali.xml.share.clipboard.ClipboardManager;
import oracle.javatools.datatransfer.ExtendedTransferable;

class PollingClipboardManager
extends AWTClipboardManager {
    static final /* synthetic */ boolean $assertionsDisabled;
    private int _state;
    private boolean _ownsClipboard;
    private Reference _cachedContentsRef;
    private final Clipboard _clipboard;
    private final ClipboardOwner _owner;
    private static final int _INITIAL_STATE = 0;
    private static final int _POLLING_STATE = 1;
    private static final int _DISABLED_STATE = 2;
    private static final long _MIN_MS_BETWEEN_CLIPBOARD_POLLS = 1000L;
    private static final long _FAST_POLL_THRESHOLD = 100L;

    public synchronized Transferable getContents() {
        Transferable contents = this._cached();
        if (contents == null) {
            long before = System.currentTimeMillis();
            contents = this._getContentsDirectly();
            long after = System.currentTimeMillis();
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().log(Level.FINER, "Foreground clipboard poll in {0} ms", new Long(after - before));
            }
            this._updateCachedContents(contents);
        }
        return contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContents(Transferable newContents) throws IllegalStateException {
        this._clipboard.setContents(newContents, this._owner);
        this.getLogger().log(Level.FINER, "Set clipboard contents to {0}", newContents);
        PollingClipboardManager pollingClipboardManager = this;
        synchronized (pollingClipboardManager) {
            this._setClipboardOwnership(true);
            this._updateCachedContents(newContents);
        }
    }

    protected synchronized void areFlavorListenersAttachedChanged() {
        super.areFlavorListenersAttachedChanged();
        this._potentiallySwitchState();
    }

    protected synchronized void applicationActiveChanged() {
        super.applicationActiveChanged();
        this._potentiallySwitchState();
    }

    PollingClipboardManager() {
        this.$init$();
    }

    private synchronized boolean _shouldBePolling() {
        return !this._ownsClipboard && this.isApplicationActive() && this.areFlavorListenersAttached();
    }

    private synchronized void _potentiallySwitchState() {
        boolean shouldPoll = this._shouldBePolling();
        if (shouldPoll) {
            if (this._state == 0) {
                this._transitionInitialToPolling();
            } else if (this._state == 2) {
                this._transitionDisabledToPolling();
            }
        } else if (this._state == 1) {
            this._transitionPollingToDisabled();
        }
    }

    private synchronized void _setClipboardOwnership(boolean newVal) {
        if (newVal != this._ownsClipboard) {
            this._ownsClipboard = newVal;
            this._potentiallySwitchState();
        }
    }

    static {
        $assertionsDisabled = PollingClipboardManager.class.desiredAssertionStatus() ^ true;
    }

    private synchronized void _transitionInitialToPolling() {
        if (!$assertionsDisabled && this._state != 0) {
            throw new AssertionError();
        }
        this._state = 1;
        this.getLogger().finer("Transitioning from initial to polling");
        Thread pollThread = new Thread(new Poller(null));
        pollThread.setName(this.getClass().getName());
        pollThread.setDaemon(true);
        pollThread.setPriority(1);
        pollThread.start();
        this.getLogger().finer("Polling thread started");
    }

    private synchronized void _transitionPollingToDisabled() {
        if (!$assertionsDisabled && this._state != 1) {
            throw new AssertionError();
        }
        this._state = 2;
        this.getLogger().finer("Transitioning from polling to disabled");
    }

    private synchronized void _transitionDisabledToPolling() {
        if (!$assertionsDisabled && this._state != 2) {
            throw new AssertionError();
        }
        this._state = 1;
        this.getLogger().finer("Transitioning from disabled to polling");
    }

    private Transferable _getContentsDirectly() {
        try {
            Transferable contents = this._clipboard.getContents(this);
            if (contents == null) {
                contents = ClipboardManager.EMPTY_CONTENTS;
            }
            this.getLogger().log(Level.FINER, "Fetched clipboard contents: {0}", contents);
            ExtendedTransferable extended = ExtendedTransferable.getExtendedTransferable((Transferable)contents);
            if (extended != null) {
                contents = extended;
            }
            Transferable transferable = contents;
            return transferable;
        }
        catch (IllegalStateException e) {
            this.getLogger().log(Level.FINER, "Got IllegalStateException fetching clipboard contents!", e);
            Transferable transferable = ClipboardManager.UNKNOWN_CONTENTS;
            return transferable;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            this.getLogger().log(Level.FINER, "Got unexpected exception fetching clipboard contents!", t);
            Transferable transferable = ClipboardManager.UNKNOWN_CONTENTS;
            return transferable;
        }
    }

    private synchronized void _updateCachedContents(Transferable newContents) {
        Transferable cached;
        if (newContents == null) {
            newContents = ClipboardManager.EMPTY_CONTENTS;
        }
        if (newContents != (cached = this._cached())) {
            Transferable oldContents = cached;
            this._cachedContentsRef = new SoftReference<Transferable>(newContents);
            if (oldContents == null || PollingClipboardManager.areDifferent(oldContents.getTransferDataFlavors(), newContents.getTransferDataFlavors())) {
                this.notifyFlavorListeners();
            }
        }
    }

    private synchronized boolean _isInPollingState() {
        return this._state == 1;
    }

    private synchronized Transferable _cached() {
        return this._cachedContentsRef == null ? null : (Transferable)this._cachedContentsRef.get();
    }

    private void $init$() {
        this._state = 0;
        this._ownsClipboard = false;
        this._cachedContentsRef = null;
        this._clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        this._owner = new Owner(null);
    }

    static void mav$_setClipboardOwnership(PollingClipboardManager pollingClipboardManager, boolean bl) {
        pollingClipboardManager._setClipboardOwnership(bl);
    }

    static int ra$_state(PollingClipboardManager pollingClipboardManager) {
        return pollingClipboardManager._state;
    }

    static boolean mav$_isInPollingState(PollingClipboardManager pollingClipboardManager) {
        return pollingClipboardManager._isInPollingState();
    }

    static Transferable mav$_getContentsDirectly(PollingClipboardManager pollingClipboardManager) {
        return pollingClipboardManager._getContentsDirectly();
    }

    static void mav$_updateCachedContents(PollingClipboardManager pollingClipboardManager, Transferable transferable) {
        pollingClipboardManager._updateCachedContents(transferable);
    }

    private class Owner
    implements ClipboardOwner {
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
            PollingClipboardManager.mav$_setClipboardOwnership(PollingClipboardManager.this, false);
        }

        private Owner() {
        }

        Owner(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class Poller
    implements Runnable {
        static final /* synthetic */ boolean $assertionsDisabled;
        private long _msUntilNextPoll;

        static {
            $assertionsDisabled = Poller.class.desiredAssertionStatus() ^ true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            PollingClipboardManager pollingClipboardManager = PollingClipboardManager.this;
            synchronized (pollingClipboardManager) {
                if (!$assertionsDisabled && PollingClipboardManager.ra$_state(PollingClipboardManager.this) == 0) {
                    throw new AssertionError();
                }
            }
            while (true) {
                if (PollingClipboardManager.mav$_isInPollingState(PollingClipboardManager.this)) {
                    long before = System.currentTimeMillis();
                    Transferable contents = PollingClipboardManager.mav$_getContentsDirectly(PollingClipboardManager.this);
                    long after = System.currentTimeMillis();
                    long delta = after - before;
                    if (PollingClipboardManager.this.getLogger().isLoggable(Level.FINER)) {
                        PollingClipboardManager.this.getLogger().log(Level.FINER, "Background clipboard poll in {0} ms", new Long(delta));
                    }
                    PollingClipboardManager.mav$_updateCachedContents(PollingClipboardManager.this, contents);
                    if (delta < (long)100) {
                        if (this._msUntilNextPoll != 1000L) {
                            PollingClipboardManager.this.getLogger().finer("Clipboard poll time reset to minimum");
                            this._msUntilNextPoll = 1000L;
                        }
                    } else {
                        this._msUntilNextPoll = 1000L + (long)5 * delta;
                        if (PollingClipboardManager.this.getLogger().isLoggable(Level.FINER)) {
                            PollingClipboardManager.this.getLogger().log(Level.FINER, "Clipboard poll time set to {0} ms", new Long(this._msUntilNextPoll));
                        }
                    }
                }
                try {
                    Thread.sleep(this._msUntilNextPoll);
                }
                catch (InterruptedException e) {
                }
            }
        }

        private void $init$() {
            this._msUntilNextPoll = 1000L;
        }

        private Poller() {
            this.$init$();
        }

        Poller(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

